/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.DagGraphToolbar;
import edu.cmu.tetradapp.editor.EdgeTypeTable;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphFileMenu;
import edu.cmu.tetradapp.editor.GraphParamsEditor;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.PasteSubgraphAction;
import edu.cmu.tetradapp.editor.PathsAction;
import edu.cmu.tetradapp.editor.SelectBidirectedAction;
import edu.cmu.tetradapp.editor.SelectDirectedAction;
import edu.cmu.tetradapp.editor.SelectLatentsAction;
import edu.cmu.tetradapp.editor.SelectUndirectedAction;
import edu.cmu.tetradapp.editor.UnderliningsAction;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.GraphUtils;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class DagEditor
extends JPanel
implements GraphEditable,
LayoutEditable,
DelegatesEditing,
IndTestProducer {
    private static final long serialVersionUID = -6082746735835257666L;
    private GraphWorkbench workbench;
    private final Parameters parameters;
    private final JScrollPane graphEditorScroll = new JScrollPane();
    private final EdgeTypeTable edgeTypeTable;

    public DagEditor(DagWrapper dagWrapper) {
        this.setLayout(new BorderLayout());
        this.parameters = dagWrapper.getParameters();
        this.edgeTypeTable = new EdgeTypeTable();
        this.initUI(dagWrapper);
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public JComponent getEditDelegate() {
        return this.getWorkbench();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public List getSelectedModelComponents() {
        List<Component> selectedComponents = this.getWorkbench().getSelectedComponents();
        ArrayList selectedModelComponents = new ArrayList();
        selectedComponents.forEach(comp -> {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
            } else if (comp instanceof DisplayEdge) {
                selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
            }
        });
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List<Object> sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        sessionElements.forEach(sessionElement -> {
            if (sessionElement instanceof GraphNode) {
                Node modelNode = (Node)sessionElement;
                this.getWorkbench().selectNode(modelNode);
            }
        });
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    public Map getModelEdgesToDisplay() {
        return this.workbench.getModelEdgesToDisplay();
    }

    public Map getModelNodesToDisplay() {
        return this.workbench.getModelNodesToDisplay();
    }

    @Override
    public void setGraph(Graph graph) {
        try {
            Dag dag = new Dag(graph);
            this.workbench.setGraph(dag);
        }
        catch (Exception e) {
            throw new RuntimeException("Not a DAG", e);
        }
    }

    @Override
    public Knowledge getKnowledge() {
        return null;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getWorkbench().getGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public void layoutByKnowledge() {
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    private void initUI(DagWrapper dagWrapper) {
        Graph graph = dagWrapper.getGraph();
        this.workbench = new GraphWorkbench(graph);
        this.workbench.addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            String[] events = new String[]{"graph", "edgeAdded", "edgeRemoved"};
            if (Arrays.asList(events).contains(propertyName)) {
                if (this.getWorkbench() != null) {
                    Graph targetGraph = this.getWorkbench().getGraph();
                    dagWrapper.setGraph(targetGraph);
                    this.updateBootstrapTable(targetGraph);
                }
            } else if ("modelChanged".equals(propertyName)) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JMenuBar menuBar = this.createGraphMenuBar();
        this.modelSelectin(dagWrapper);
        DagGraphToolbar graphToolbar = new DagGraphToolbar(this.getWorkbench());
        graphToolbar.setMaximumSize(new Dimension(140, 450));
        this.graphEditorScroll.setPreferredSize(new Dimension(760, 450));
        this.graphEditorScroll.setViewportView(this.workbench);
        Box topBox = Box.createVerticalBox();
        topBox.setPreferredSize(new Dimension(820, 400));
        Box topGraphBox = Box.createHorizontalBox();
        topGraphBox.add(graphToolbar);
        topGraphBox.add(this.graphEditorScroll);
        Box instructionBox = Box.createHorizontalBox();
        instructionBox.setMaximumSize(new Dimension(820, 40));
        JLabel label = new JLabel("Double click variable/node rectangle to change name. More information on graph edge types and colorings");
        label.setFont(new Font("SansSerif", 0, 12));
        JButton infoBtn = new JButton(new ImageIcon(ImageUtils.getImage(this, "info.png")));
        infoBtn.setBorder(new EmptyBorder(0, 0, 0, 0));
        infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String helpHS = "/resources/javahelp/TetradHelp.hs";
                try {
                    URL url = this.getClass().getResource("/resources/javahelp/TetradHelp.hs");
                    HelpSet helpSet = new HelpSet(null, url);
                    helpSet.setHomeID("graph_edge_types");
                    HelpBroker broker = helpSet.createHelpBroker();
                    CSH.DisplayHelpFromSource listener = new CSH.DisplayHelpFromSource(broker);
                    listener.actionPerformed(e);
                }
                catch (Exception ee) {
                    System.out.println("HelpSet " + ee.getMessage());
                    System.out.println("HelpSet /resources/javahelp/TetradHelp.hs not found");
                    throw new IllegalArgumentException();
                }
            }
        });
        instructionBox.add(label);
        instructionBox.add(Box.createHorizontalStrut(2));
        instructionBox.add(infoBtn);
        topBox.add(topGraphBox);
        topBox.add(instructionBox);
        this.edgeTypeTable.setPreferredSize(new Dimension(820, 150));
        JTabbedPane tabbedPane = new JTabbedPane(4);
        tabbedPane.addTab("Graph", new PaddingPanel(topBox));
        tabbedPane.addTab("Edges", this.edgeTypeTable);
        this.add((Component)menuBar, "North");
        this.add((Component)tabbedPane, "Center");
        this.edgeTypeTable.update(graph);
        this.validate();
    }

    private void updateGraphWorkbench(Graph graph) {
        this.workbench = new GraphWorkbench(graph);
        this.graphEditorScroll.setViewportView(this.workbench);
        this.validate();
    }

    private void updateBootstrapTable(Graph graph) {
        this.edgeTypeTable.update(graph);
        this.validate();
    }

    private void modelSelectin(DagWrapper dagWrapper) {
        int numModels = dagWrapper.getNumModels();
        if (numModels > 1) {
            ArrayList<Integer> models = new ArrayList<Integer>();
            for (int i = 0; i < numModels; ++i) {
                models.add(i + 1);
            }
            JComboBox<Object> comboBox = new JComboBox<Object>(models.toArray());
            comboBox.setSelectedIndex(dagWrapper.getModelIndex());
            comboBox.addActionListener(e -> {
                dagWrapper.setModelIndex(comboBox.getSelectedIndex());
                this.updateGraphWorkbench(dagWrapper.getGraph());
                this.updateBootstrapTable(dagWrapper.getGraph());
            });
            Box modelSelectionBox = Box.createHorizontalBox();
            modelSelectionBox.add(new JLabel("Using model "));
            modelSelectionBox.add(comboBox);
            modelSelectionBox.add(new JLabel(" from "));
            modelSelectionBox.add(new JLabel(dagWrapper.getModelSourceName()));
            modelSelectionBox.add(Box.createHorizontalStrut(20));
            modelSelectionBox.add(Box.createHorizontalGlue());
            this.add((Component)modelSelectionBox, "East");
        }
    }

    private JMenuBar createGraphMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        GraphFileMenu fileMenu = new GraphFileMenu(this, this.getWorkbench(), false);
        JMenu editMenu = this.createEditMenu();
        JMenu graphMenu = this.createGraphMenu();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(graphMenu);
        menuBar.add(new LayoutMenu(this));
        return menuBar;
    }

    private JMenu createEditMenu() {
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        JMenuItem paste = new JMenuItem(new PasteSubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        edit.add(copy);
        edit.add(paste);
        return edit;
    }

    private JMenu createGraphMenu() {
        JMenu graph = new JMenu("Graph");
        JMenuItem randomGraph = new JMenuItem("Random Graph");
        graph.add(randomGraph);
        graph.addSeparator();
        graph.add(new GraphPropertiesAction(this.workbench));
        graph.add(new PathsAction(this.workbench));
        graph.add(new UnderliningsAction(this.workbench));
        graph.add(new JMenuItem(new SelectDirectedAction(this.workbench)));
        graph.add(new JMenuItem(new SelectBidirectedAction(this.workbench)));
        graph.add(new JMenuItem(new SelectUndirectedAction(this.workbench)));
        graph.add(new JMenuItem(new SelectLatentsAction(this.workbench)));
        randomGraph.addActionListener(e -> {
            GraphParamsEditor editor = new GraphParamsEditor();
            editor.setParams(this.parameters);
            EditorWindow editorWindow = new EditorWindow(editor, "Edit Random Graph Parameters", "Done", true, this);
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
            editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e1) {
                    EditorWindow window = (EditorWindow)e1.getSource();
                    if (window.isCanceled()) {
                        return;
                    }
                    Graph graph1 = GraphUtils.makeRandomGraph(DagEditor.this.getGraph(), DagEditor.this.parameters);
                    boolean addCycles = DagEditor.this.parameters.getBoolean("randomAddCycles", false);
                    if (addCycles) {
                        int newGraphNumMeasuredNodes = DagEditor.this.parameters.getInt("newGraphNumMeasuredNodes", 10);
                        int newGraphNumEdges = DagEditor.this.parameters.getInt("newGraphNumEdges", 10);
                        graph1 = RandomGraph.randomCyclicGraph2(newGraphNumMeasuredNodes, newGraphNumEdges, 8);
                    }
                    DagEditor.this.getWorkbench().setGraph(graph1);
                }
            });
        });
        return graph;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return new IndTestDSep(this.workbench.getGraph());
    }
}

