/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

class DataCellEditor
extends DefaultCellEditor {
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private final JTextField textField = (JTextField)this.editorComponent;

    public DataCellEditor() {
        super(new JTextField());
        this.textField.setHorizontalAlignment(2);
        this.textField.setBorder(new LineBorder(Color.BLACK));
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value == null) {
                    DataCellEditor.this.textField.setText("");
                } else if (value instanceof String) {
                    DataCellEditor.this.textField.setText((String)value);
                } else if (value instanceof Integer) {
                    DataCellEditor.this.textField.setText(value.toString());
                } else if (value instanceof Double) {
                    double doubleValue = (Double)value;
                    if (Double.isNaN(doubleValue)) {
                        DataCellEditor.this.textField.setText("");
                    } else {
                        DataCellEditor.this.textField.setText(DataCellEditor.this.nf.format(doubleValue));
                    }
                }
                DataCellEditor.this.textField.selectAll();
            }

            @Override
            public Object getCellEditorValue() {
                return DataCellEditor.this.textField.getText();
            }
        };
        this.textField.addActionListener(this.delegate);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }
}

