/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetradapp.editor.TabularDataJTable;
import edu.cmu.tetradapp.editor.TabularDataTable;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class DataCellRenderer
extends DefaultTableCellRenderer {
    private final NumberFormat nf;
    private final DataSet dataSet;
    private final int numLeadingCols;

    public DataCellRenderer(TabularDataJTable tableTabular, int numLeadingCols) {
        this.dataSet = ((TabularDataTable)tableTabular.getModel()).getDataSet();
        this.numLeadingCols = numLeadingCols;
        this.nf = this.dataSet.getNumberFormat();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.setText((String)value);
        } else if (value instanceof Integer) {
            this.setText(value.toString());
        } else if (value instanceof Double) {
            this.setText(this.nf.format((Double)value));
        } else {
            this.setText("");
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)c;
        if (this.dataSet.getNumColumns() > 0 && col >= this.getNumLeadingCols() && col < this.dataSet.getNumColumns() + this.getNumLeadingCols()) {
            renderer.setHorizontalAlignment(4);
        }
        return renderer;
    }

    private int getNumLeadingCols() {
        return this.numLeadingCols;
    }
}

