/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TextTable;
import java.text.NumberFormat;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

class DescriptiveStats {
    DescriptiveStats() {
    }

    public static String generateDescriptiveStats(DataSet dataSet, Node variable) {
        int i;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        int col = dataSet.getColumn(variable);
        double[] data = new double[dataSet.getNumRows()];
        boolean continuous = false;
        if (variable instanceof ContinuousVariable) {
            continuous = true;
            for (i = 0; i < dataSet.getNumRows(); ++i) {
                data[i] = dataSet.getDouble(i, col);
            }
        } else {
            try {
                for (i = 0; i < dataSet.getNumRows(); ++i) {
                    DiscreteVariable var = (DiscreteVariable)variable;
                    String category = var.getCategory(dataSet.getInt(i, col));
                    int value = Integer.parseInt(category);
                    data[i] = value;
                }
            }
            catch (NumberFormatException e) {
                return "Not a numerical discrete column.";
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("Descriptive Statistics for: ").append(variable.getName()).append("\n\n");
        double[] normalValues = DescriptiveStats.normalParams(data);
        TextTable table = continuous ? new TextTable(10, 2) : new TextTable(6, 2);
        int rowindex = 0;
        table.setToken(rowindex, 0, "Sample Size:");
        table.setToken(rowindex++, 1, "" + dataSet.getNumRows());
        table.setToken(rowindex, 0, "Mean:");
        table.setToken(rowindex++, 1, nf.format(normalValues[0]));
        table.setToken(rowindex, 0, "Standard Deviation:");
        table.setToken(rowindex++, 1, nf.format(normalValues[1]));
        table.setToken(rowindex, 0, "Variance:");
        table.setToken(rowindex++, 1, nf.format(normalValues[2]));
        table.setToken(rowindex, 0, "Skewness:");
        table.setToken(rowindex++, 1, nf.format(StatUtils.skewness(data)));
        table.setToken(rowindex, 0, "Kurtosis:");
        table.setToken(rowindex++, 1, nf.format(StatUtils.kurtosis(data)));
        if (continuous) {
            double[] median = DescriptiveStats.median(data);
            table.setToken(rowindex, 0, "SE Mean:");
            table.setToken(rowindex++, 1, nf.format(DescriptiveStats.standardErrorMean(normalValues[1], dataSet.getNumRows())));
            table.setToken(rowindex, 0, "Median:");
            table.setToken(rowindex++, 1, nf.format(median[0]));
            table.setToken(rowindex, 0, "Minimum:");
            table.setToken(rowindex++, 1, nf.format(median[1]));
            table.setToken(rowindex, 0, "Maximum:");
            table.setToken(rowindex, 1, nf.format(median[2]));
        }
        b.append(table);
        return b.toString();
    }

    private static double[] median(double[] data) {
        Arrays.sort(data);
        double[] result = new double[3];
        result[1] = data[0];
        result[2] = data[data.length - 1];
        if (data.length % 2 == 1) {
            result[0] = data[data.length / 2];
        } else {
            double firstValue = data[data.length / 2];
            double secondValue = data[data.length / 2 - 1];
            result[0] = (firstValue + secondValue) / 2.0;
        }
        return result;
    }

    private static double standardErrorMean(double stdDev, double sampleSize) {
        return stdDev / FastMath.sqrt(sampleSize);
    }

    private static double[] normalParams(double[] data) {
        double mean = 0.0;
        double sd = 0.0;
        for (double datum : data) {
            mean += datum;
        }
        mean /= (double)data.length;
        for (double datum : data) {
            sd += (datum - mean) * (datum - mean);
        }
        double[] result = new double[3];
        result[2] = sd /= (double)data.length - 1.0;
        sd = FastMath.sqrt(sd);
        result[0] = mean;
        result[1] = sd;
        return result;
    }
}

