/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.DescriptiveStats;
import edu.cmu.tetradapp.editor.DescriptiveStatsEditorPanel;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class DescriptiveStatsAction
extends AbstractAction {
    private final DataEditor dataEditor;

    public DescriptiveStatsAction(DataEditor editor) {
        super("Descriptive Statistics...");
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        if (dataSet == null || dataSet.getNumColumns() == 0) {
            JOptionPane.showMessageDialog(this.findOwner(), "Cannot generate descriptive statistics on an empty data set.");
            return;
        }
        Node selected = null;
        for (Node node : dataSet.getVariables()) {
            if (!dataSet.isSelected(node)) continue;
            selected = node;
            break;
        }
        JPanel panel = this.createDescriptiveStatsDialog(selected);
        EditorWindow window = new EditorWindow(panel, "Descriptive Statistics", "Close", false, this.dataEditor);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private JPanel createDescriptiveStatsDialog(Node selected) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        if (selected == null) {
            assert (dataSet != null);
            if (dataSet.getNumColumns() != 0) {
                selected = dataSet.getVariable(0);
            }
        }
        assert (dataSet != null);
        DescriptiveStatsEditorPanel editorPanel = new DescriptiveStatsEditorPanel(selected, dataSet);
        JTextArea display = new JTextArea(DescriptiveStats.generateDescriptiveStats(dataSet, selected), 20, 65);
        display.setEditable(false);
        display.setFont(new Font("Monospaced", 0, 12));
        editorPanel.addPropertyChangeListener(new DescriptiveStatsListener(display));
        Box box = Box.createHorizontalBox();
        box.add(display);
        box.add(Box.createHorizontalStrut(3));
        box.add(editorPanel);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)vBox, "Center");
        return panel;
    }

    private JFrame findOwner() {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.dataEditor);
    }

    private static class DescriptiveStatsListener
    implements PropertyChangeListener {
        private final JTextArea display;

        public DescriptiveStatsListener(JTextArea display) {
            this.display = display;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("histogramChange".equals(evt.getPropertyName())) {
                this.display.setText((String)evt.getNewValue());
            }
        }
    }
}

