/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.editor.DirichletBayesImCountsWizard;
import edu.cmu.tetradapp.editor.DirichletBayesImProbsWizard;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class DirichletBayesImEditor
extends JPanel {
    private final DirichletBayesImProbsWizard probsWizard;
    private final DirichletBayesImCountsWizard countsWizard;

    private DirichletBayesImEditor(DirichletBayesIm dirichletBayesIm) {
        if (dirichletBayesIm == null) {
            throw new NullPointerException("Bayes IM must not be null.");
        }
        this.setLayout(new BorderLayout());
        BayesPm bayesPm = dirichletBayesIm.getBayesPm();
        Graph graph = bayesPm.getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        this.setLayout(new BorderLayout());
        this.add((Component)menuBar, "North");
        this.probsWizard = new DirichletBayesImProbsWizard(dirichletBayesIm, workbench);
        this.probsWizard.enableEditing(false);
        this.countsWizard = new DirichletBayesImCountsWizard(dirichletBayesIm, workbench);
        this.probsWizard.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        this.countsWizard.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        JScrollPane probsScroll = new JScrollPane(this.getProbsWizard());
        JScrollPane countsScroll = new JScrollPane(this.getCountsWizard());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Probabilities", probsScroll);
        tabbedPane.add("Pseudocounts", countsScroll);
        tabbedPane.addChangeListener(e -> {
            JTabbedPane tabbedPane1 = (JTabbedPane)e.getSource();
            tabbedPane1.getSelectedComponent().requestFocus();
        });
        workbenchScroll.setPreferredSize(new Dimension(400, 400));
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, tabbedPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        this.add((Component)splitPane, "Center");
        this.setName("Dirichlet Bayes IM Editor");
        this.getProbsWizard().addPropertyChangeListener(evt -> {
            if ("editorClosing".equals(evt.getPropertyName())) {
                this.firePropertyChange("editorClosing", null, this.getName());
            }
            if ("closeFrame".equals(evt.getPropertyName())) {
                this.firePropertyChange("closeFrame", null, null);
                this.firePropertyChange("editorClosing", true, true);
            }
        });
    }

    public DirichletBayesImEditor(DirichletBayesImWrapper dirichletBayesImWrapper) {
        this(dirichletBayesImWrapper.getDirichletBayesIm());
    }

    public DirichletBayesImEditor(DirichletEstimatorWrapper dirichletEstWrapper) {
        this(dirichletEstWrapper.getEstimatedBayesIm());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private DirichletBayesImProbsWizard getProbsWizard() {
        return this.probsWizard;
    }

    private DirichletBayesImCountsWizard getCountsWizard() {
        return this.countsWizard;
    }
}

