/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.NumberCellEditor;
import edu.cmu.tetradapp.editor.NumberCellRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

class DirichletBayesImNodeCountsTable
extends JTable {
    private int focusRow;
    private int focusCol;
    private int lastX;
    private int lastY;

    public DirichletBayesImNodeCountsTable(Node node, DirichletBayesIm dirichletBayesIm) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (dirichletBayesIm == null) {
            throw new NullPointerException();
        }
        if (dirichletBayesIm.getNodeIndex(node) < 0) {
            throw new IllegalArgumentException("Node " + node + " is not a node in this DirichletBayesIm.");
        }
        this.resetModel(node, dirichletBayesIm);
        this.setDefaultEditor(Number.class, new NumberCellEditor(NumberFormatUtil.getInstance().getNumberFormat()));
        this.setDefaultRenderer(Number.class, new NumberCellRenderer(NumberFormatUtil.getInstance().getNumberFormat()));
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        ListSelectionModel rowSelectionModel = this.getSelectionModel();
        rowSelectionModel.addListSelectionListener(e -> {
            ListSelectionModel m = (ListSelectionModel)e.getSource();
            this.setFocusRow(m.getAnchorSelectionIndex());
        });
        ListSelectionModel columnSelectionModel = this.getColumnModel().getSelectionModel();
        columnSelectionModel.addListSelectionListener(e -> {
            ListSelectionModel m = (ListSelectionModel)e.getSource();
            this.setFocusColumn(m.getAnchorSelectionIndex());
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    DirichletBayesImNodeCountsTable.this.showPopup(e);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((Model)DirichletBayesImNodeCountsTable.this.getModel()).fireTableDataChanged();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((Model)DirichletBayesImNodeCountsTable.this.getModel()).fireTableDataChanged();
            }
        });
        this.setFocusRow(0);
        this.setFocusColumn(0);
    }

    private void resetModel(Node node, DirichletBayesIm dirichletBayesIm) {
        Model model = new Model(node, dirichletBayesIm, this);
        model.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("editorValueChanged", null, null);
            }
        });
        this.setModel(model);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        if (this.getModel() instanceof Model) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Model model = (Model)this.getModel();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                int minimumWidth;
                TableColumn column = this.getColumnModel().getColumn(i);
                String columnName = model.getColumnName(i);
                int currentWidth = column.getPreferredWidth();
                if (columnName == null || (minimumWidth = fontMetrics.stringWidth(columnName) + 8) <= currentWidth) continue;
                column.setPreferredWidth(minimumWidth);
            }
        }
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem randomizeRow = new JMenuItem("Randomize this row");
        JMenuItem randomizeIncompleteRows = new JMenuItem("Randomize incomplete rows in table");
        JMenuItem randomizeEntireTable = new JMenuItem("Randomize entire table");
        JMenuItem randomizeAllTables = new JMenuItem("Randomize all tables");
        JMenuItem clearRow = new JMenuItem("Clear this row");
        JMenuItem clearEntireTable = new JMenuItem("Clear entire table");
        randomizeRow.addActionListener(e12 -> {
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            DirichletBayesImNodeCountsTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            Point point = new Point(this.getLastX(), this.getLastY());
            int rowIndex = editingTable.rowAtPoint(point);
            DirichletBayesIm dirichletBayesIm = this.getDirichletBayesIm();
            dirichletBayesIm.randomizeRow(nodeIndex, rowIndex);
            this.getEditingTableModel().fireTableDataChanged();
        });
        randomizeIncompleteRows.addActionListener(e1 -> {
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            DirichletBayesIm dirichletBayesIm = this.getDirichletBayesIm();
            if (!this.existsIncompleteRow(dirichletBayesIm, nodeIndex)) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There are no incomplete rows in this table.");
                return;
            }
            DirichletBayesImNodeCountsTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            dirichletBayesIm.randomizeIncompleteRows(nodeIndex);
            this.getEditingTableModel().fireTableDataChanged();
        });
        randomizeEntireTable.addActionListener(e13 -> {
            int ret;
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            DirichletBayesIm dirichletBayesIm = this.getDirichletBayesIm();
            if (this.existsCompleteRow(dirichletBayesIm, nodeIndex) && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will modify all values in the table. Continue?", "Warning", 0)) == 1) {
                return;
            }
            DirichletBayesImNodeCountsTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            dirichletBayesIm.randomizeTable(nodeIndex);
            this.getEditingTableModel().fireTableDataChanged();
        });
        randomizeAllTables.addActionListener(e14 -> {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will modify all values in the entire Dirichlet model! Continue?", "Warning", 0);
            if (ret == 1) {
                return;
            }
            DirichletBayesIm dirichletBayesIm = this.getDirichletBayesIm();
            for (int nodeIndex = 0; nodeIndex < dirichletBayesIm.getNumNodes(); ++nodeIndex) {
                DirichletBayesImNodeCountsTable editingTable = this;
                TableCellEditor cellEditor = editingTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                dirichletBayesIm.randomizeTable(nodeIndex);
                this.getEditingTableModel().fireTableDataChanged();
            }
        });
        clearRow.addActionListener(e15 -> {
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            DirichletBayesImNodeCountsTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            Point point = new Point(this.getLastX(), this.getLastY());
            int rowIndex = editingTable.rowAtPoint(point);
            DirichletBayesIm dirichletBayesIm = this.getDirichletBayesIm();
            dirichletBayesIm.clearRow(nodeIndex, rowIndex);
            this.getEditingTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
        });
        clearEntireTable.addActionListener(e16 -> {
            int ret;
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            DirichletBayesIm dirichletBayesIm = this.getDirichletBayesIm();
            if (this.existsCompleteRow(dirichletBayesIm, nodeIndex) && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will delete all values in the table. Continue?", "Warning", 0)) == 1) {
                return;
            }
            DirichletBayesImNodeCountsTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            dirichletBayesIm.clearTable(nodeIndex);
            this.getEditingTableModel().fireTableDataChanged();
        });
        popup.add(randomizeRow);
        popup.add(randomizeIncompleteRows);
        popup.add(randomizeEntireTable);
        popup.add(randomizeAllTables);
        popup.addSeparator();
        popup.add(clearRow);
        popup.add(clearEntireTable);
        this.lastX = e.getX();
        this.lastY = e.getY();
        popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private boolean existsCompleteRow(DirichletBayesIm dirichletBayesIm, int nodeIndex) {
        boolean existsCompleteRow = false;
        for (int rowIndex = 0; rowIndex < dirichletBayesIm.getNumRows(nodeIndex); ++rowIndex) {
            if (dirichletBayesIm.isIncomplete(nodeIndex, rowIndex)) continue;
            existsCompleteRow = true;
            break;
        }
        return existsCompleteRow;
    }

    private boolean existsIncompleteRow(DirichletBayesIm dirichletBayesIm, int nodeIndex) {
        boolean existsCompleteRow = false;
        for (int rowIndex = 0; rowIndex < dirichletBayesIm.getNumRows(nodeIndex); ++rowIndex) {
            if (!dirichletBayesIm.isIncomplete(nodeIndex, rowIndex)) continue;
            existsCompleteRow = true;
            break;
        }
        return existsCompleteRow;
    }

    @Override
    public void setModel(@NotNull TableModel model) {
        super.setModel(model);
    }

    private void setFocusRow(int row) {
        Model editingTableModel = (Model)this.getModel();
        int failedRow = editingTableModel.getFailedRow();
        if (failedRow != -1) {
            row = failedRow;
            editingTableModel.resetFailedRow();
        }
        this.focusRow = row;
        if (this.focusCol < this.getRowCount()) {
            this.setRowSelectionInterval(this.focusRow, this.focusRow);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private void setFocusColumn(int col) {
        Model editingTableModel = (Model)this.getModel();
        int failedCol = editingTableModel.getFailedCol();
        if (failedCol != -1) {
            col = failedCol;
            editingTableModel.resetFailedCol();
        }
        if (col < this.getNumParents()) {
            col = this.getNumParents();
        }
        this.focusCol = FastMath.max(col, this.getNumParents());
        if (this.focusCol >= this.getNumParents() && this.focusCol < this.getColumnCount()) {
            this.setColumnSelectionInterval(this.focusCol, this.focusCol);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private int getNumParents() {
        Model editingTableModel = (Model)this.getModel();
        DirichletBayesIm dirichletBayesIm = editingTableModel.getDirichletBayesIm();
        int nodeIndex = editingTableModel.getNodeIndex();
        return dirichletBayesIm.getNumParents(nodeIndex);
    }

    private Model getEditingTableModel() {
        return (Model)this.getModel();
    }

    private DirichletBayesIm getDirichletBayesIm() {
        return this.getEditingTableModel().getDirichletBayesIm();
    }

    private int getLastX() {
        return this.lastX;
    }

    private int getLastY() {
        return this.lastY;
    }

    static final class Model
    extends AbstractTableModel {
        private final DirichletBayesIm dirichletBayesIm;
        private final int nodeIndex;
        private int failedRow = -1;
        private int failedCol = -1;
        private PropertyChangeSupport pcs;

        public Model(Node node, DirichletBayesIm dirichletBayesIm, JComponent messageAnchor) {
            if (node == null) {
                throw new NullPointerException("Node must not be null.");
            }
            if (dirichletBayesIm == null) {
                throw new NullPointerException("Bayes IM must not be null.");
            }
            if (messageAnchor == null) {
                throw new NullPointerException("Message anchor must not be null.");
            }
            this.dirichletBayesIm = dirichletBayesIm;
            this.nodeIndex = dirichletBayesIm.getNodeIndex(node);
        }

        @Override
        public String getColumnName(int col) {
            Node node = this.getDirichletBayesIm().getNode(this.getNodeIndex());
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            int totalsColumn = numParents + numColumns;
            if (col < numParents) {
                int parent = this.getDirichletBayesIm().getParent(this.getNodeIndex(), col);
                return this.getDirichletBayesIm().getNode(parent).getName();
            }
            if (col < numParents + numColumns) {
                int valIndex = col - numParents;
                String value = this.getDirichletBayesIm().getBayesPm().getCategory(node, valIndex);
                return node.getName() + "=" + value;
            }
            if (col == totalsColumn) {
                return "TOTAL COUNT";
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.getDirichletBayesIm().getNumRows(this.getNodeIndex());
        }

        @Override
        public int getColumnCount() {
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            return numParents + numColumns + 1;
        }

        @Override
        public Object getValueAt(int tableRow, int tableCol) {
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            int totalsColumn = numParents + numColumns;
            int[] parentVals = this.getDirichletBayesIm().getParentValues(this.getNodeIndex(), tableRow);
            if (tableCol < numParents) {
                Node columnNode = this.getDirichletBayesIm().getNode(this.getDirichletBayesIm().getParent(this.getNodeIndex(), tableCol));
                BayesPm bayesPm = this.getDirichletBayesIm().getBayesPm();
                return bayesPm.getCategory(columnNode, parentVals[tableCol]);
            }
            if (tableCol < numParents + numColumns) {
                int colIndex = tableCol - numParents;
                double value = this.getDirichletBayesIm().getPseudocount(this.getNodeIndex(), tableRow, colIndex);
                if (value == -1.0) {
                    return null;
                }
                return value;
            }
            if (tableCol == totalsColumn) {
                return this.getDirichletBayesIm().getRowPseudocount(this.getNodeIndex(), tableRow);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex());
            return col >= numParents && col < numParents + numColumns + 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            int numColumns;
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            if (col == numParents + (numColumns = this.getDirichletBayesIm().getNumColumns(this.getNodeIndex()))) {
                this.setTotal(row, aValue);
            } else {
                this.setPseudocount(row, col, aValue);
            }
        }

        @Override
        public int findColumn(String columnName) {
            return super.findColumn(columnName);
        }

        private void setTotal(int row, Object aValue) {
            if ("".equals(aValue) || aValue == null) {
                return;
            }
            try {
                double total = Double.parseDouble((String)aValue);
                if (total < 0.0) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Total must be nonnegative.");
                    this.failedRow = row;
                } else {
                    double currentTotal = this.getDirichletBayesIm().getRowPseudocount(this.getNodeIndex(), row);
                    double ratio = total / currentTotal;
                    for (int i = 0; i < this.getDirichletBayesIm().getNumColumns(this.getNodeIndex()); ++i) {
                        double count = this.getDirichletBayesIm().getPseudocount(this.getNodeIndex(), row, i);
                        this.getDirichletBayesIm().setPseudocount(this.getNodeIndex(), row, i, count * ratio);
                    }
                    this.fireTableRowsUpdated(row, row);
                    this.getPcs().firePropertyChange("editorValueChanged", null, null);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not interpret '" + aValue + "'");
                this.failedRow = row;
            }
        }

        private void setPseudocount(int row, int col, Object aValue) {
            int numParents = this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            int colIndex = col - numParents;
            if ("".equals(aValue) || aValue == null) {
                return;
            }
            try {
                double pseudocount = Double.parseDouble((String)aValue);
                if (this.countIsNegative(pseudocount)) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Counts must be nonnegative.");
                    this.failedRow = row;
                    this.failedCol = col;
                } else {
                    this.getDirichletBayesIm().setPseudocount(this.getNodeIndex(), row, colIndex, pseudocount);
                    this.fireTableRowsUpdated(row, row);
                    this.getPcs().firePropertyChange("editorValueChanged", null, null);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not interpret '" + aValue + "'");
                this.failedRow = row;
                this.failedCol = col;
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.getPcs().addPropertyChangeListener(l);
        }

        private PropertyChangeSupport getPcs() {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            return this.pcs;
        }

        private boolean countIsNegative(double count) {
            return count < 0.0;
        }

        public Class getColumnClass(int col) {
            boolean isParent = col < this.getDirichletBayesIm().getNumParents(this.getNodeIndex());
            return isParent ? Object.class : Number.class;
        }

        public DirichletBayesIm getDirichletBayesIm() {
            return this.dirichletBayesIm;
        }

        public int getNodeIndex() {
            return this.nodeIndex;
        }

        public int getFailedRow() {
            return this.failedRow;
        }

        public int getFailedCol() {
            return this.failedCol;
        }

        public void resetFailedRow() {
            this.failedRow = -1;
        }

        public void resetFailedCol() {
            this.failedCol = -1;
        }
    }
}

