/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DirichletBayesImParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params;

    @Override
    public void setParams(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    @Override
    public void setup() {
        this.setLayout(new BorderLayout());
        JRadioButton manual = new JRadioButton();
        JRadioButton randomRetain = new JRadioButton();
        manual.setText("Manually");
        randomRetain.setText("Using a symmetric prior for each row of each conditional probability table.");
        ButtonGroup group = new ButtonGroup();
        group.add(manual);
        group.add(randomRetain);
        DoubleTextField symmetricAlphaField = new DoubleTextField(this.params.getDouble("symmetricAlpha", 1.0), 5, NumberFormatUtil.getInstance().getNumberFormat());
        symmetricAlphaField.setFilter((value, oldValue) -> {
            try {
                this.params.set("symmetricAlpha", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        if (this.getParams().getString("initializationMode", "symmetricPrior").equals("manual")) {
            manual.setSelected(true);
            symmetricAlphaField.setEnabled(false);
        } else if (this.getParams().getString("initializationMode", "symmetricPrior").equals("symmetricPrior")) {
            randomRetain.setSelected(true);
            symmetricAlphaField.setEnabled(true);
        } else {
            throw new IllegalStateException();
        }
        manual.addActionListener(e -> {
            this.getParams().set("initializationMode", "manual");
            symmetricAlphaField.setEnabled(false);
        });
        randomRetain.addActionListener(e -> {
            this.getParams().set("initializationMode", "symmetricPrior");
            symmetricAlphaField.setEnabled(true);
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Pseudocounts for this Dirichlet Bayes IM should be initialized:"));
        b2.add(Box.createHorizontalGlue());
        Box b3 = Box.createHorizontalBox();
        b3.add(manual);
        b3.add(Box.createHorizontalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add(randomRetain);
        b4.add(Box.createHorizontalGlue());
        Box b5 = Box.createHorizontalBox();
        b5.add(Box.createRigidArea(new Dimension(30, 0)));
        b5.add(new JLabel("All pseudocounts = "));
        b5.add(symmetricAlphaField);
        b5.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        b1.add(b3);
        b1.add(b4);
        b1.add(b5);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }

    private synchronized Parameters getParams() {
        return this.params;
    }
}

