/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DirichletEstimatorParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params;

    @Override
    public void setParams(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    @Override
    public void setup() {
        this.setLayout(new BorderLayout());
        DoubleTextField symmetricAlphaField = new DoubleTextField(this.params.getDouble("symmetricAlpha", 1.0), 5, NumberFormatUtil.getInstance().getNumberFormat());
        symmetricAlphaField.setFilter((value, oldValue) -> {
            try {
                this.params.set("symmetricAlpha", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("<html>If you make a Dirichlet estimator using a Bayes PM and a <br>discrete data set as parents, a Dirichlet Bayes IM will<br>be created behind the scenes for you using the number you<br>provide below as pseudocount for every cell. This Dirichlet<br>Bayes IM will be used as the prior for the estimation. If<br>you would like to have more control over how this prior is<br>created, please remove the PM-->Estimator edge, add a new<br>IM box, connect it as PM-->IM-->Estimator, and create the<br>prior you want as a Dirichlet Bayes IM in the IM box.</html>"));
        Box b7 = Box.createHorizontalBox();
        b7.add(Box.createHorizontalGlue());
        b7.add(new JLabel("<html><i>Estimate using a prior with all pseudocounts =</i></html>"));
        b7.add(symmetricAlphaField);
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        b1.add(b7);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }

    protected synchronized Parameters getParams() {
        return this.params;
    }
}

