/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;

class DiscDetIndepParamsEditor
extends JComponent {
    private final Parameters params;
    private final DoubleTextField alphaField;
    private final IntTextField depthField;

    public DiscDetIndepParamsEditor(Parameters params) {
        this.params = params;
        this.alphaField = new DoubleTextField(params.getDouble("alpha", 0.001), 5, NumberFormatUtil.getInstance().getNumberFormat());
        this.alphaField.setFilter((value, oldValue) -> {
            try {
                this.params().set("alpha", (Object)0.001);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        this.depthField = new IntTextField(params.getInt("depth", -1), 5);
        this.depthField.setFilter((value, oldValue) -> {
            try {
                this.params().set("depth", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        this.buildGui();
    }

    private void buildGui() {
        this.setLayout(new BoxLayout(this, 1));
        if (this.alphaField != null) {
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Alpha:"));
            b1.add(Box.createHorizontalGlue());
            b1.add(this.alphaField);
            this.add(b1);
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Depth:"));
        b2.add(Box.createHorizontalGlue());
        b2.add(this.depthField);
        this.add(b2);
        this.add(Box.createHorizontalGlue());
    }

    private Parameters params() {
        return this.params;
    }
}

