/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.BayesEstimatorNodeEditingTable;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellEditor;

final class EMBayesEstimatorEditorWizard
extends JPanel {
    private static final long serialVersionUID = -4844735953555314165L;
    private final BayesIm bayesIm;
    private final JComboBox<Node> varNamesComboBox;
    private final GraphWorkbench workbench;
    private BayesEstimatorNodeEditingTable editingTable;
    private final JPanel tablePanel;
    private boolean enableEditing = true;

    public EMBayesEstimatorEditorWizard(BayesIm bayesIm, GraphWorkbench workbench) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setFont(new Font("SanSerif", 1, 12));
        this.varNamesComboBox = this.createVarNamesComboBox(bayesIm.getBayesPm());
        workbench.scrollWorkbenchToNode((Node)this.varNamesComboBox.getSelectedItem());
        JButton nextButton = new JButton("Next");
        nextButton.setMnemonic('N');
        Node node = (Node)this.varNamesComboBox.getSelectedItem();
        this.editingTable = new BayesEstimatorNodeEditingTable(node, bayesIm);
        this.editingTable.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("editorValueChanged", null, null);
            }
        });
        JScrollPane scroll = new JScrollPane(this.editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)scroll, "Center");
        this.editingTable.grabFocus();
        this.setLayout(new BorderLayout());
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Probability table for values of "));
        b2.add(this.varNamesComboBox);
        b2.add(new JLabel(" conditional on values of its"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("parents:"));
        b3.add(Box.createHorizontalGlue());
        b1.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add((Component)this.tablePanel, "Center");
        b1.add(b4);
        Box b5 = Box.createHorizontalBox();
        b5.add(new JLabel("Asterisks in table indicate undefined values."));
        b5.add(Box.createHorizontalGlue());
        b1.add(b5);
        b1.add(Box.createVerticalStrut(15));
        this.add((Component)b1, "Center");
        this.varNamesComboBox.addActionListener(e -> {
            Node n = (Node)this.varNamesComboBox.getSelectedItem();
            this.getWorkbench().scrollWorkbenchToNode(n);
            this.setCurrentNode(n);
        });
        nextButton.addActionListener(e -> {
            int current = this.varNamesComboBox.getSelectedIndex();
            int max = this.varNamesComboBox.getItemCount();
            if (++current == max) {
                JOptionPane.showMessageDialog(this, "There are no more variables.");
            }
            int set = current < max ? current : 0;
            this.varNamesComboBox.setSelectedIndex(set);
        });
        workbench.addPropertyChangeListener(evt -> {
            List selection;
            if (evt.getPropertyName().equals("selectedNodes") && (selection = (List)evt.getNewValue()).size() == 1) {
                this.varNamesComboBox.setSelectedItem(selection.get(0));
            }
        });
        this.bayesIm = bayesIm;
        this.workbench = workbench;
    }

    private JComboBox<Node> createVarNamesComboBox(BayesPm bayesPm) {
        JComboBox<Node> varNameComboBox = new JComboBox<Node>();
        varNameComboBox.setBackground(Color.white);
        Graph graph = bayesPm.getDag();
        ArrayList<Node> nodes = new ArrayList<Node>(graph.getNodes());
        Collections.sort(nodes);
        nodes.forEach(varNameComboBox::addItem);
        if (varNameComboBox.getItemCount() > 0) {
            varNameComboBox.setSelectedIndex(0);
        }
        return varNameComboBox;
    }

    private void setCurrentNode(Node node) {
        TableCellEditor cellEditor = this.editingTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        this.editingTable = new BayesEstimatorNodeEditingTable(node, this.getBayesIm());
        this.editingTable.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("editorValueChanged", null, null);
            }
        });
        JScrollPane scroll = new JScrollPane(this.editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        this.tablePanel.removeAll();
        this.tablePanel.add((Component)scroll, "Center");
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
        this.editingTable.grabFocus();
    }

    private BayesIm getBayesIm() {
        return this.bayesIm;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public boolean isEnableEditing() {
        return this.enableEditing;
    }

    public void enableEditing(boolean enableEditing) {
        this.enableEditing = enableEditing;
        if (this.workbench != null) {
            this.workbench.enableEditing(enableEditing);
        }
    }
}

