/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.math3.util.FastMath;

public class EdgeTypeTable
extends JPanel {
    private static final long serialVersionUID = -9104061917163909746L;
    private static final String[] EDGES = new String[]{"", "Node 1", "Interaction", "Node 2"};
    private static final String[] EDGES_AND_EDGE_TYPES = new String[]{"", "Node 1", "Interaction", "Node 2", "Ensemble", "Edge", "No edge", "\u2192", "\u2190", "---", "\u2192", "\u2190", "\u2192", "\u2190", "o->", "<-o", "o-o", "<->"};
    private final JLabel title = new JLabel();
    private final JTable table = new EdgeInfoTable(new DefaultTableModel());

    public EdgeTypeTable() {
        this.initComponents();
    }

    private void initComponents() {
        this.title.setHorizontalAlignment(0);
        this.title.setVerticalAlignment(0);
        this.setLayout(new BorderLayout(0, 10));
        this.add((Component)this.title, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public void update(Graph graph) {
        ArrayList<Edge> edges = new ArrayList<Edge>(graph.getEdges());
        Edges.sortEdges(edges);
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        tableModel.setRowCount(0);
        if (this.hasEdgeProbabilities(graph)) {
            this.title.setText("Edges and Edge Type Frequencies");
            this.table.setAutoResizeMode(0);
            tableModel.setColumnIdentifiers(EDGES_AND_EDGE_TYPES);
            JTableHeader header = this.table.getTableHeader();
            Font boldFont = new Font(header.getFont().getFontName(), 1, 18);
            TableCellRenderer headerRenderer = header.getDefaultRenderer();
            header.setDefaultRenderer((tbl, value, isSelected, hasFocus, row, column) -> {
                Component comp = headerRenderer.getTableCellRendererComponent(tbl, value, isSelected, hasFocus, row, column);
                if (column >= 10 && column <= 13) {
                    comp.setForeground(Color.BLUE);
                }
                if (column >= 12 && column <= 13) {
                    comp.setFont(boldFont);
                }
                return comp;
            });
            edges.forEach(edge -> {
                Object[] rowData = new String[EDGES_AND_EDGE_TYPES.length];
                this.addEdgeData((Edge)edge, (String[])rowData);
                this.addEdgeProbabilityData((Edge)edge, (String[])rowData);
                tableModel.addRow(rowData);
            });
        } else {
            this.title.setText("Edges");
            this.table.setAutoResizeMode(4);
            tableModel.setColumnIdentifiers(EDGES);
            edges.forEach(edge -> {
                Object[] rowData = new String[EDGES.length];
                this.addEdgeData((Edge)edge, (String[])rowData);
                tableModel.addRow(rowData);
            });
        }
        tableModel.fireTableDataChanged();
    }

    private void addEdgeProbabilityData(Edge edge, String[] rowData) {
        edge.getEdgeTypeProbabilities().stream().filter(edgeTypeProb -> edgeTypeProb.getProbability() > 0.0).forEach(edgeTypeProb -> {
            String probValue = String.format("%.4f", edgeTypeProb.getProbability());
            switch (edgeTypeProb.getEdgeType()) {
                case nil: {
                    rowData[6] = probValue;
                    break;
                }
                case ta: {
                    boolean nl = false;
                    boolean pd = false;
                    boolean dd = false;
                    for (Edge.Property p : edgeTypeProb.getProperties()) {
                        if (p == Edge.Property.dd) {
                            dd = true;
                        }
                        if (p == Edge.Property.nl) {
                            nl = true;
                        }
                        if (p != Edge.Property.pd) continue;
                        pd = true;
                    }
                    if (nl && dd) {
                        rowData[12] = probValue;
                        break;
                    }
                    if (nl && pd) {
                        rowData[10] = probValue;
                        break;
                    }
                    rowData[7] = probValue;
                    break;
                }
                case at: {
                    boolean nl = false;
                    boolean pd = false;
                    boolean dd = false;
                    for (Edge.Property p : edgeTypeProb.getProperties()) {
                        if (p == Edge.Property.dd) {
                            dd = true;
                        }
                        if (p == Edge.Property.nl) {
                            nl = true;
                        }
                        if (p != Edge.Property.pd) continue;
                        pd = true;
                    }
                    if (nl && dd) {
                        rowData[13] = probValue;
                        break;
                    }
                    if (nl && pd) {
                        rowData[11] = probValue;
                        break;
                    }
                    rowData[8] = probValue;
                    break;
                }
                case tt: {
                    rowData[9] = probValue;
                    break;
                }
                case ca: {
                    rowData[14] = probValue;
                    break;
                }
                case ac: {
                    rowData[15] = probValue;
                    break;
                }
                case cc: {
                    rowData[16] = probValue;
                    break;
                }
                case aa: {
                    rowData[17] = probValue;
                }
            }
        });
        double maxEdgeProbability = edge.getEdgeTypeProbabilities().stream().filter(e -> e.getEdgeType() != EdgeTypeProbability.EdgeType.nil).mapToDouble(EdgeTypeProbability::getProbability).max().orElse(0.0);
        rowData[4] = String.format("%.4f", maxEdgeProbability);
        rowData[5] = String.format("%.4f", edge.getProbability());
    }

    private void addEdgeData(Edge edge, String[] rowData) {
        String node1Name = edge.getNode1().getName();
        String node2Name = edge.getNode2().getName();
        Endpoint endpoint1 = edge.getEndpoint1();
        Endpoint endpoint2 = edge.getEndpoint2();
        String endpoint1Str = "";
        if (endpoint1 == Endpoint.TAIL) {
            endpoint1Str = "-";
        } else if (endpoint1 == Endpoint.ARROW) {
            endpoint1Str = "<";
        } else if (endpoint1 == Endpoint.CIRCLE) {
            endpoint1Str = "o";
        }
        String endpoint2Str = "";
        if (endpoint2 == Endpoint.TAIL) {
            endpoint2Str = "-";
        } else if (endpoint2 == Endpoint.ARROW) {
            endpoint2Str = ">";
        } else if (endpoint2 == Endpoint.CIRCLE) {
            endpoint2Str = "o";
        }
        String edgeType = endpoint1Str + "-" + endpoint2Str;
        rowData[1] = node1Name;
        rowData[2] = edgeType;
        rowData[3] = node2Name;
    }

    private boolean hasEdgeProbabilities(Graph graph) {
        Iterator<Edge> iterator = graph.getEdges().iterator();
        if (iterator.hasNext()) {
            Edge edge = iterator.next();
            return !edge.getEdgeTypeProbabilities().isEmpty();
        }
        return false;
    }

    class EdgeInfoTable
    extends JTable {
        private static final long serialVersionUID = -4052775309418269033L;

        public EdgeInfoTable(TableModel dm) {
            super(dm);
            this.initComponents();
        }

        private void initComponents() {
            this.setFillsViewportHeight(true);
            this.setDefaultRenderer(Object.class, new StripedRowTableCellRenderer());
            this.setOpaque(true);
            this.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>(this.getModel()){

                @Override
                public boolean isSortable(int column) {
                    return column != 0;
                }
            });
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component component = super.prepareRenderer(renderer, row, column);
            int rendererWidth = component.getPreferredSize().width;
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            tableColumn.setPreferredWidth(FastMath.max(rendererWidth + this.getIntercellSpacing().width, tableColumn.getPreferredWidth()));
            return component;
        }
    }

    private static class StripedRowTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4603884548966502824L;
        private final Color STRIPE = new Color(0.929f, 0.953f, 0.996f);
        private final Color NON_STRIPE = Color.WHITE;

        public StripedRowTableCellRenderer() {
            this.initComponents();
        }

        private void initComponents() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                label.setBackground(row % 2 == 0 ? this.NON_STRIPE : this.STRIPE);
            }
            if (column == 0) {
                this.setText(Integer.toString(row + 1));
                label.setHorizontalAlignment(0);
                label.setFont(new Font("SansSerif", 1, 12));
            }
            return label;
        }
    }
}

