/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.EdgewiseComparisonModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class EdgewiseComparisonEditor
extends JPanel {
    private static final long serialVersionUID = 7921819261142670181L;
    private final EdgewiseComparisonModel comparison;
    private JTextArea area;
    private final Parameters params;

    public EdgewiseComparisonEditor(EdgewiseComparisonModel comparison) {
        this.comparison = comparison;
        this.params = comparison.getParams();
        this.setup();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        Font font = new Font("Monospaced", 0, 14);
        this.area = new JTextArea();
        this.area.setText(this.tableTextWithHeader());
        this.area.setFont(font);
        JScrollPane scrollTextPane = new JScrollPane(this.area);
        scrollTextPane.setPreferredSize(new Dimension(500, 600));
        pane.add((Component)scrollTextPane, new BorderLayout());
        this.add(pane);
        this.add((Component)this.menubar(), "North");
    }

    @NotNull
    private JMenuBar menubar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("Compare To...");
        JCheckBoxMenuItem graph = new JCheckBoxMenuItem("DAG");
        graph.setBackground(Color.WHITE);
        JCheckBoxMenuItem cpdag = new JCheckBoxMenuItem("CPDAG");
        cpdag.setBackground(Color.YELLOW);
        JCheckBoxMenuItem pag = new JCheckBoxMenuItem("PAG");
        pag.setBackground(Color.GREEN.brighter().brighter());
        ButtonGroup group = new ButtonGroup();
        group.add(graph);
        group.add(cpdag);
        group.add(pag);
        menu.add(graph);
        menu.add(cpdag);
        menu.add(pag);
        menubar.add(menu);
        switch (this.params.getString("graphComparisonType")) {
            case "CPDAG": {
                menu.setText("Compare to CPDAG...");
                cpdag.setSelected(true);
                break;
            }
            case "PAG": {
                menu.setText("Compare to PAG...");
                pag.setSelected(true);
                break;
            }
            default: {
                menu.setText("Compare to DAG...");
                graph.setSelected(true);
            }
        }
        graph.addActionListener(e -> {
            this.params.set("graphComparisonType", "DAG");
            menu.setText("Compare to DAG...");
            menu.setBackground(Color.WHITE);
            this.area.setText(this.comparison.getComparisonString());
            this.area.moveCaretPosition(0);
            this.area.setSelectionStart(0);
            this.area.setSelectionEnd(0);
            this.area.repaint();
        });
        cpdag.addActionListener(e -> {
            this.params.set("graphComparisonType", "CPDAG");
            menu.setText("Compare to CPDAG...");
            menu.setBackground(Color.YELLOW);
            this.area.setText(this.comparison.getComparisonString());
            this.area.moveCaretPosition(0);
            this.area.setSelectionStart(0);
            this.area.setSelectionEnd(0);
            this.area.repaint();
        });
        pag.addActionListener(e -> {
            this.params.set("graphComparisonType", "PAG");
            menu.setText("Compare to PAG...");
            menu.setBackground(Color.GREEN.brighter().brighter());
            this.area.setText(this.comparison.getComparisonString());
            this.area.moveCaretPosition(0);
            this.area.setSelectionStart(0);
            this.area.setSelectionEnd(0);
            this.area.repaint();
        });
        return menubar;
    }

    private String tableTextWithHeader() {
        return this.comparison.getComparisonString();
    }
}

