/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.GraphSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EdgewiseComparisonParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params;
    private SessionModel model1;
    private SessionModel model2;
    private Object[] parentModels;

    @Override
    public void setParentModels(Object[] parentModels) {
        this.parentModels = parentModels;
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    @Override
    public void setup() {
        LinkedList<GraphSource> graphSources = new LinkedList<GraphSource>();
        for (Object parentModel : this.parentModels) {
            if (!(parentModel instanceof GraphSource)) continue;
            graphSources.add((GraphSource)parentModel);
        }
        if (graphSources.size() != 2) {
            throw new IllegalArgumentException("Expecting two graph sources as input.");
        }
        String name1 = ((GraphSource)graphSources.get(0)).getName();
        String name2 = ((GraphSource)graphSources.get(1)).getName();
        String storedName = Preferences.userRoot().get("__referenceSessionModel", "");
        System.out.println("In body, name1 = " + name1 + " name2 = " + name2 + ", storedName = " + storedName);
        if (name1.startsWith("Simulation")) {
            this.model1 = (SessionModel)graphSources.get(0);
            this.model2 = (SessionModel)graphSources.get(1);
        } else if (name2.startsWith("Simulation")) {
            this.model1 = (SessionModel)graphSources.get(1);
            this.model2 = (SessionModel)graphSources.get(0);
        } else if (storedName.equals(name1)) {
            this.model1 = (SessionModel)graphSources.get(0);
            this.model2 = (SessionModel)graphSources.get(1);
        } else if (storedName.equals(name2)) {
            this.model1 = (SessionModel)graphSources.get(1);
            this.model2 = (SessionModel)graphSources.get(0);
        } else {
            this.model1 = (SessionModel)graphSources.get(0);
            this.model2 = (SessionModel)graphSources.get(1);
        }
        System.out.println("Decision: reference = " + this.model1.getName() + ", target = " + this.model2.getName());
        this.params.set("referenceGraphName", this.model1.getName());
        this.params.getString("targetGraphName", this.model2.getName());
        this.setLayout(new BorderLayout());
        JRadioButton resetOnExecute = new JRadioButton("Reset");
        JRadioButton dontResetOnExecute = new JRadioButton("Appended to");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(resetOnExecute);
        group1.add(dontResetOnExecute);
        resetOnExecute.addActionListener(e -> this.getParams().set("resetTableOnExecute", (Object)true));
        dontResetOnExecute.addActionListener(e -> this.getParams().set("resetTableOnExecute", (Object)false));
        if (this.getParams().getBoolean("resetTableOnExecute", false)) {
            resetOnExecute.setSelected(true);
        } else {
            dontResetOnExecute.setSelected(true);
        }
        JRadioButton latents = new JRadioButton("Yes");
        JRadioButton noLatents = new JRadioButton("No");
        ButtonGroup group2 = new ButtonGroup();
        group2.add(latents);
        group2.add(noLatents);
        latents.addActionListener(e -> this.getParams().set("keepLatents", (Object)true));
        if (this.getParams().getBoolean("keepLatents", false)) {
            latents.setSelected(true);
        } else {
            noLatents.setSelected(true);
        }
        JRadioButton graph1 = new JRadioButton(this.model1.getName());
        JRadioButton graph2 = new JRadioButton(this.model2.getName());
        graph1.addActionListener(e -> {
            System.out.println("Graph1 button reference = " + this.model1.getName() + ", target = " + this.model2.getName());
            Preferences.userRoot().put("__referenceSessionModel", this.model1.getName());
            this.params.set("referenceGraphName", this.model1.getName());
            this.params.getString("targetGraphName", this.model1.getName());
        });
        graph2.addActionListener(e -> {
            System.out.println("Graph2 button reference = " + this.model2.getName() + ", target = " + this.model1.getName());
            Preferences.userRoot().put("__referenceSessionModel", this.model2.getName());
            this.params.set("referenceGraphName", this.model2.getName());
            this.params.getString("targetGraphName", this.model1.getName());
        });
        ButtonGroup group = new ButtonGroup();
        group.add(graph1);
        group.add(graph2);
        graph1.setSelected(true);
        Box b1 = Box.createVerticalBox();
        Box b8 = Box.createHorizontalBox();
        b8.add(new JLabel("Which of the two input graphs is the true graph?"));
        b8.add(Box.createHorizontalGlue());
        b1.add(b8);
        Box b9 = Box.createHorizontalBox();
        b9.add(graph1);
        b9.add(Box.createHorizontalGlue());
        b1.add(b9);
        Box b10 = Box.createHorizontalBox();
        b10.add(graph2);
        b10.add(Box.createHorizontalGlue());
        b1.add(b10);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }

    private synchronized Parameters getParams() {
        return this.params;
    }

    @Override
    public void setParams(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
    }
}

