/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.session.ModificationRegistery;
import edu.cmu.tetradapp.editor.DoNotScroll;
import edu.cmu.tetradapp.util.EditorWindowIndirectRef;
import edu.cmu.tetradapp.util.FinalizingEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

public class EditorWindow
extends JInternalFrame
implements EditorWindowIndirectRef,
Comparable {
    private JPanel editor;
    private boolean canceled;
    private final String buttonName;
    private final Component centeringComp;
    private JButton okButton;

    public EditorWindow(JPanel editor, String title, String buttonName, boolean cancellable, Component centeringComp) {
        super(title, true, true, true, false);
        if (editor == null) {
            throw new NullPointerException("Editor must not be null.");
        }
        this.buttonName = buttonName;
        this.doSetup(editor, cancellable);
        this.centeringComp = centeringComp;
        this.setClosable(false);
    }

    public int compareTo(@NotNull Object o) {
        EditorWindow to = (EditorWindow)o;
        return ((EditorWindow)o).getName().compareTo(to.getName());
    }

    private void doSetup(JPanel editor, boolean cancellable) {
        this.editor = editor;
        this.okButton = null;
        if (this.buttonName != null) {
            this.okButton = new JButton(this.buttonName);
        }
        JButton cancelButton = new JButton("Cancel");
        if (this.okButton != null) {
            this.okButton.setPreferredSize(new Dimension(100, 50));
            this.okButton.addActionListener(new OkListener());
        }
        cancelButton.setPreferredSize(new Dimension(100, 50));
        cancelButton.addActionListener(new CancelListener());
        Box b0 = Box.createVerticalBox();
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        if (this.okButton != null) {
            b.add(this.okButton);
        }
        b.add(Box.createHorizontalStrut(5));
        if (cancellable) {
            b.add(cancelButton);
        }
        b.add(Box.createHorizontalGlue());
        b0.add(editor);
        b0.add(b);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = FastMath.min(b0.getPreferredSize().width + 50, screensize.width);
        int height = FastMath.min(b0.getPreferredSize().height + 50, screensize.height - 100);
        if (!(editor instanceof DoNotScroll || b0.getPreferredSize().width <= width && b0.getPreferredSize().height <= height)) {
            JScrollPane scroll = new JScrollPane(b0);
            scroll.setPreferredSize(new Dimension(width, height));
            this.getContentPane().add(scroll);
        } else {
            this.getContentPane().add(b0);
        }
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root != null) {
            root.setDefaultButton(this.okButton);
        }
        this.pack();
    }

    public void closeDialog() {
        this.setVisible(false);
        ModificationRegistery.unregisterEditor(this.getEditor());
        this.doDefaultCloseAction();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private JComponent getEditor() {
        return this.editor;
    }

    public Component getCenteringComp() {
        return this.centeringComp;
    }

    public void addActionListener(ActionListener l) {
        if (this.okButton != null) {
            this.okButton.addActionListener(l);
        }
    }

    private class OkListener
    implements ActionListener {
        private OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditorWindow.this.editor instanceof FinalizingEditor) {
                boolean ok = ((FinalizingEditor)((Object)EditorWindow.this.editor)).finalizeEditor();
                if (ok) {
                    EditorWindow.this.closeDialog();
                }
            } else {
                EditorWindow.this.closeDialog();
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditorWindow.this.canceled = true;
            EditorWindow.this.closeDialog();
        }
    }
}

