/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicButtonUI;

class EvidenceEditorObs
extends JPanel {
    private final Evidence evidence;
    private final JToggleButton[][] buttons;
    private final HashMap<JToggleButton, Integer> buttonsToVariables = new HashMap();
    private final HashMap<JToggleButton, Integer> buttonsToCategories = new HashMap();
    private final HashMap<JCheckBox, Integer> checkBoxesToVariables = new HashMap();
    private final HashMap<Integer, JCheckBox> variablesToCheckboxes = new HashMap();

    public EvidenceEditorObs(Evidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        this.evidence = evidence;
        this.setLayout(new BoxLayout(this, 1));
        Box d = Box.createHorizontalBox();
        d.add(new JLabel("Variable/Categories"));
        d.add(Box.createHorizontalGlue());
        d.add(new JLabel("Manipulated"));
        this.add(d);
        this.buttons = new JToggleButton[evidence.getNumNodes()][];
        for (int i = 0; i < evidence.getNumNodes(); ++i) {
            if (evidence.getNode(i).getNodeType() == NodeType.LATENT) continue;
            Box c = Box.createHorizontalBox();
            c.add(new JLabel(evidence.getNode(i).getName() + ":  "){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            });
            this.buttons[i] = new JToggleButton[evidence.getNumCategories(i)];
            Node node = evidence.getNode(i);
            for (int j = 0; j < evidence.getNumCategories(i); ++j) {
                String name = evidence.getCategory(node, j);
                JToggleButton button = new JToggleButton(" " + name + " "){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                button.setBorder(new CompoundBorder(new LineBorder(Color.DARK_GRAY, 1, true), new EmptyBorder(0, 2, 0, 1)));
                button.setBackground(Color.WHITE);
                button.setUI(new BasicButtonUI());
                button.setFont(new Font("Serif", 1, 12));
                this.buttonsToVariables.put(button, i);
                this.buttonsToCategories.put(button, j);
                this.buttons[i][j] = button;
                button.addActionListener(e -> {
                    JToggleButton button1 = (JToggleButton)e.getSource();
                    int i1 = this.buttonsToVariables.get(button1);
                    int j1 = this.buttonsToCategories.get(button1);
                    Proposition proposition = this.getEvidence().getProposition();
                    if (proposition.getNumAllowed(i1) == this.getEvidence().getNumCategories(i1)) {
                        proposition.setCategory(i1, j1);
                        this.getEvidence().setManipulated(i1, true);
                        JCheckBox checkbox = this.variablesToCheckboxes.get(i1);
                        checkbox.setSelected(true);
                    } else if (proposition.getNumAllowed(i1) == 1) {
                        if (proposition.getSingleCategory(i1) == j1) {
                            proposition.removeCategory(i1, j1);
                        } else {
                            if ((1 & e.getModifiers()) != 1) {
                                proposition.setVariable(i1, false);
                            }
                            proposition.setCategory(i1, j1);
                        }
                    } else if (proposition.isAllowed(i1, j1)) {
                        proposition.removeCategory(i1, j1);
                    } else {
                        proposition.addCategory(i1, j1);
                    }
                    if (proposition.getNumAllowed(i1) == 0) {
                        proposition.setVariable(i1, true);
                    }
                    this.resetSelected(i1);
                });
                c.add(button);
                c.add(Box.createHorizontalStrut(2));
            }
            c.add(Box.createHorizontalGlue());
            JCheckBox checkbox = new JCheckBox(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            checkbox.setSelected(this.getEvidence().isManipulated(i));
            this.checkBoxesToVariables.put(checkbox, i);
            this.variablesToCheckboxes.put(i, checkbox);
            checkbox.addActionListener(e -> {
                JCheckBox checkbox1 = (JCheckBox)e.getSource();
                int variable = this.checkBoxesToVariables.get(checkbox1);
                if (this.getEvidence().getProposition().getSingleCategory(variable) == -1) {
                    JOptionPane.showMessageDialog(checkbox1, "Please choose a single category to manipulate on.");
                    checkbox1.setSelected(false);
                    this.getEvidence().setManipulated(variable, false);
                } else {
                    this.getEvidence().setManipulated(variable, true);
                    checkbox1.setSelected(true);
                }
            });
            checkbox.setBackground(Color.WHITE);
            checkbox.setBorder(null);
            c.add(checkbox);
            c.setMaximumSize(new Dimension(1000, 30));
            this.add(c);
            this.resetSelected(i);
        }
    }

    private void highlightCorrectly(Proposition proposition) {
        for (JToggleButton _button : this.buttonsToVariables.keySet()) {
            int _i = this.buttonsToVariables.get(_button);
            int _j = this.buttonsToCategories.get(_button);
            if (proposition.isConditioned(_i) && proposition.isAllowed(_i, _j)) {
                _button.setBackground(Color.LIGHT_GRAY);
                continue;
            }
            _button.setBackground(Color.WHITE);
        }
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    private void resetSelected(int variable) {
        int j;
        if (this.evidence.hasNoEvidence(variable)) {
            for (j = 0; j < this.buttons[variable].length; ++j) {
                this.buttons[variable][j].setSelected(false);
            }
        } else {
            for (j = 0; j < this.buttons[variable].length; ++j) {
                this.buttons[variable][j].setSelected(this.evidence.getProposition().isAllowed(variable, j));
            }
        }
        if (this.evidence.getProposition().getSingleCategory(variable) == -1) {
            JCheckBox checkbox = this.variablesToCheckboxes.get(variable);
            checkbox.setSelected(false);
            this.getEvidence().setManipulated(variable, false);
        }
        this.highlightCorrectly(this.evidence.getProposition());
    }
}

