/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.EvidenceEditor;
import edu.cmu.tetradapp.model.UpdaterWrapper;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

class EvidenceWizardSingle
extends JPanel {
    private final UpdaterWrapper updaterWrapper;
    private final GraphWorkbench workbench;
    private final EvidenceEditor evidenceEditor;

    public EvidenceWizardSingle(UpdaterWrapper updaterWrapper, GraphWorkbench workbench) {
        if (updaterWrapper == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        Node node = workbench.getGraph().getNodes().get(0);
        workbench.deselectAll();
        workbench.selectNode(node);
        this.updaterWrapper = updaterWrapper;
        this.workbench = workbench;
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        JButton updateButton = new JButton("Do Update Now");
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>Select the node in the graph that you would like to see updated<br>probabilities for. In the list below, select the evidence that<br>you would like to update on. Click the 'Do Update Now' button<br>to view updated probabilities.</html>"));
        b0.add(Box.createHorizontalGlue());
        this.add(b0);
        this.add(Box.createVerticalStrut(10));
        this.evidenceEditor = new EvidenceEditor(updaterWrapper.getBayesUpdater().getEvidence());
        this.getUpdaterWrapper().getParams().set("evidence", (Object)this.evidenceEditor.getEvidence());
        this.add(this.evidenceEditor);
        this.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(updateButton);
        this.add(b2);
        this.add(Box.createVerticalGlue());
        updateButton.addActionListener(e -> {
            DisplayNode graphNode = this.getWorkbench().getSelectedNode();
            if (graphNode == null) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Please select exactly one node in the graph.");
                return;
            }
            Node tetradNode = graphNode.getModelNode();
            String selectedNodeName = tetradNode.getName();
            this.getUpdaterWrapper().getParams().set("evidence", (Object)this.evidenceEditor.getEvidence());
            this.getUpdaterWrapper().getParams().set("variable", (Object)updaterWrapper.getBayesUpdater().getBayesIm().getBayesPm().getVariable(tetradNode));
            this.getUpdaterWrapper().getBayesUpdater().setEvidence(this.evidenceEditor.getEvidence());
            Graph updatedGraph = this.getUpdaterWrapper().getBayesUpdater().getManipulatedGraph();
            Node selectedNode = updatedGraph.getNode(selectedNodeName);
            this.getWorkbench().setGraph(updatedGraph);
            this.getWorkbench().deselectAll();
            this.getWorkbench().selectNode(selectedNode);
            this.firePropertyChange("updateButtonPressed", null, null);
            this.firePropertyChange("modelChanged", null, null);
        });
    }

    private UpdaterWrapper getUpdaterWrapper() {
        return this.updaterWrapper;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }
}

