/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetradapp.editor.AbstractSearchEditor;
import edu.cmu.tetradapp.model.FactorAnalysisRunner;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Box;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FactorAnalysisEditor
extends AbstractSearchEditor {
    public FactorAnalysisEditor(FactorAnalysisRunner runner) {
        super(runner, "Factor Analysis");
    }

    @Override
    public Graph getGraph() {
        return this.getWorkbench().getGraph();
    }

    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    @Override
    protected void setup(String resultLabel) {
        FactorAnalysisRunner runner = (FactorAnalysisRunner)this.getAlgorithmRunner();
        Graph graph = runner.getGraph();
        JTextArea display = new JTextArea(runner.getOutput());
        JScrollPane scrollPane = new JScrollPane(display);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        display.setEditable(false);
        display.setFont(new Font("Monospaced", 0, 12));
        LayoutUtil.circleLayout(graph, 225, 200, 150);
        LayoutUtil.fruchtermanReingoldLayout(graph);
        GraphWorkbench workbench = new GraphWorkbench(graph);
        JScrollPane graphPane = new JScrollPane(workbench);
        graphPane.setPreferredSize(new Dimension(500, 400));
        Box box = Box.createHorizontalBox();
        box.add(scrollPane);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        box.add(graphPane);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)vBox, "Center");
        this.add(panel);
    }

    @Override
    protected void addSpecialMenus(JMenuBar menuBar) {
    }

    @Override
    public Graph getSourceGraph() {
        Graph sourceGraph = this.getWorkbench().getGraph();
        if (sourceGraph == null) {
            sourceGraph = this.getAlgorithmRunner().getSourceGraph();
        }
        return sourceGraph;
    }

    public List<String> getVarNames() {
        return (List)this.getAlgorithmRunner().getParams().get("varNames", null);
    }

    @Override
    public JPanel getToolbar() {
        return null;
    }

    @Override
    protected void doDefaultArrangement(Graph resultGraph) {
        if (this.getLatestWorkbenchGraph() != null) {
            LayoutUtil.arrangeBySourceGraph(resultGraph, this.getLatestWorkbenchGraph());
        } else {
            LayoutUtil.circleLayout(resultGraph, 200, 200, 150);
        }
    }
}

