/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.JsonUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.editor.search.AlgorithmCard;
import edu.cmu.tetradapp.editor.search.GraphCard;
import edu.cmu.tetradapp.editor.search.ParameterCard;
import edu.cmu.tetradapp.model.GeneralAlgorithmRunner;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.ui.model.AlgorithmModel;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.FinalizingEditor;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GeneralAlgorithmEditor
extends JPanel
implements PropertyChangeListener,
ActionListener,
FinalizingEditor {
    private static final long serialVersionUID = -5719467682865706447L;
    private final JButton algoFwdBtn = new JButton("Set Parameters   >");
    private final JButton paramBkBtn = new JButton("<   Choose Algorithm");
    private final JButton paramFwdBtn = new JButton("Run Search & Generate Graph   >");
    private final JButton graphBkBtn = new JButton("<   Set Parameters");
    private final AlgorithmCard algorithmCard;
    private final ParameterCard parameterCard;
    private final GraphCard graphCard;
    private String jsonResult;
    private final GeneralAlgorithmRunner algorithmRunner;
    private final TetradDesktop desktop;

    public GeneralAlgorithmEditor(GeneralAlgorithmRunner algorithmRunner) {
        this.algorithmRunner = algorithmRunner;
        this.desktop = (TetradDesktop)DesktopController.getInstance();
        this.algorithmCard = new AlgorithmCard(algorithmRunner);
        this.parameterCard = new ParameterCard(algorithmRunner);
        this.graphCard = new GraphCard(algorithmRunner);
        this.initComponents();
        this.initListeners();
        if (algorithmRunner.getGraphs() != null && algorithmRunner.getGraphs().size() > 0) {
            this.algorithmCard.refresh();
            this.parameterCard.refresh();
            this.graphCard.refresh();
            this.showGraphCard();
        }
    }

    private void initComponents() {
        if (this.algorithmRunner.hasMissingValues()) {
            this.setPreferredSize(new Dimension(827, 670));
        } else {
            this.setPreferredSize(new Dimension(827, 620));
        }
        this.setLayout(new CardLayout());
        this.add(new SingleButtonCard(this.algorithmCard, this.algoFwdBtn));
        this.add(new DualButtonCard(this.parameterCard, this.paramBkBtn, this.paramFwdBtn));
        this.add(new SingleButtonCard(this.graphCard, this.graphBkBtn));
    }

    private void initListeners() {
        this.algoFwdBtn.addActionListener(this);
        this.paramBkBtn.addActionListener(this);
        this.paramFwdBtn.addActionListener(this);
        this.graphBkBtn.addActionListener(this);
        this.algorithmCard.addPropertyChangeListener(this);
        this.parameterCard.addPropertyChangeListener(this);
        this.graphCard.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("algoFwdBtn".equals(evt.getPropertyName())) {
            this.algoFwdBtn.setEnabled((Boolean)evt.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.algoFwdBtn) {
            if (this.algorithmCard.isAllValid()) {
                this.parameterCard.refresh();
                this.showNextCard();
            }
        } else if (obj == this.paramBkBtn) {
            this.showPreviousCard();
        } else if (obj == this.paramFwdBtn) {
            this.doSearch();
        } else if (obj == this.graphBkBtn) {
            this.showPreviousCard();
        }
    }

    public void setAlgorithmResult(String jsonResult) {
        this.jsonResult = jsonResult;
        System.out.println("json result: " + jsonResult);
        Graph graph = JsonUtils.parseJSONObjectToTetradGraph(jsonResult);
        this.algorithmRunner.getGraphs().clear();
        this.algorithmRunner.getGraphs().add(graph);
        TetradLogger.getInstance().forceLogMessage("Remote graph result assigned to algorithmRunner!");
        this.firePropertyChange("modelChanged", null, null);
        this.graphCard.refresh();
        this.showGraphCard();
    }

    public void setAlgorithmErrorResult(String errorResult) {
        JOptionPane.showMessageDialog(this.desktop, this.jsonResult);
        throw new IllegalArgumentException(errorResult);
    }

    private void showNextCard() {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.next(this);
    }

    private void showPreviousCard() {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.previous(this);
    }

    private void showGraphCard() {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.last(this);
    }

    private void doSearch() {
        new WatchedProcess((Window)this.getTopLevelAncestor()){

            @Override
            public void watch() {
                AlgorithmModel algoModel = GeneralAlgorithmEditor.this.algorithmCard.getSelectedAlgorithm();
                if (algoModel != null) {
                    try {
                        GeneralAlgorithmEditor.this.algorithmCard.saveStates();
                        GeneralAlgorithmEditor.this.algorithmRunner.execute();
                        GeneralAlgorithmEditor.this.firePropertyChange("modelChanged", null, null);
                        GeneralAlgorithmEditor.this.graphCard.refresh();
                        GeneralAlgorithmEditor.this.showGraphCard();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        JOptionPane.showMessageDialog(GeneralAlgorithmEditor.this.getTopLevelAncestor(), "Stopped with error:\n" + exception.getMessage());
                    }
                }
            }
        };
    }

    @Override
    public boolean finalizeEditor() {
        List<Graph> graphs = this.algorithmRunner.getGraphs();
        if (graphs == null || graphs.isEmpty()) {
            int option = JOptionPane.showConfirmDialog(this, "You have not performed a search. Close anyway?", "Close?", 0);
            return option == 0;
        }
        return true;
    }

    private static class SingleButtonCard
    extends JPanel {
        private static final long serialVersionUID = 7154917933096522203L;
        private final JComponent component;
        private final JButton button;

        public SingleButtonCard(JComponent component, JButton button) {
            this.component = component;
            this.button = button;
            this.initComponents();
        }

        private void initComponents() {
            Dimension buttonSize = new Dimension(268, 25);
            this.button.setMinimumSize(buttonSize);
            this.button.setMaximumSize(buttonSize);
            this.button.setPreferredSize(buttonSize);
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(new PaddingPanel(this.component)), "Center");
            this.add((Component)new SouthPanel(), "South");
        }

        private class SouthPanel
        extends JPanel {
            private static final long serialVersionUID = -126249189388443046L;

            public SouthPanel() {
                this.initComponents();
            }

            private void initComponents() {
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(SingleButtonCard.this.button).addContainerGap(-1, Short.MAX_VALUE)));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(SingleButtonCard.this.button).addContainerGap()));
            }
        }
    }

    private static class DualButtonCard
    extends JPanel {
        private static final long serialVersionUID = 7995297102462362969L;
        private final JComponent component;
        private final JButton backButton;
        private final JButton forwardButton;

        public DualButtonCard(JComponent component, JButton backButton, JButton forwardButton) {
            this.component = component;
            this.backButton = backButton;
            this.forwardButton = forwardButton;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            Dimension buttonSize = new Dimension(268, 25);
            this.backButton.setMinimumSize(buttonSize);
            this.backButton.setMaximumSize(buttonSize);
            this.backButton.setPreferredSize(buttonSize);
            this.forwardButton.setMinimumSize(buttonSize);
            this.forwardButton.setMaximumSize(buttonSize);
            this.forwardButton.setPreferredSize(buttonSize);
            this.add((Component)new JScrollPane(new PaddingPanel(this.component)), "Center");
            this.add((Component)new SouthPanel(), "South");
        }

        private class SouthPanel
        extends JPanel {
            private static final long serialVersionUID = 3980233325015220843L;

            public SouthPanel() {
                this.initComponents();
            }

            private void initComponents() {
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(DualButtonCard.this.backButton).addGap(18, 18, 18).addComponent(DualButtonCard.this.forwardButton).addContainerGap(-1, Short.MAX_VALUE)));
                layout.linkSize(0, DualButtonCard.this.backButton, DualButtonCard.this.forwardButton);
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(DualButtonCard.this.backButton).addComponent(DualButtonCard.this.forwardButton)).addContainerGap()));
            }
        }
    }
}

