/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.calculator.parser.ExpressionParser;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.util.MillisecondTimes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

class GeneralizedExpressionEditor
extends JComponent {
    private Color color = Color.BLACK;
    private int start;
    private int stringWidth;
    private long recolorTime = MillisecondTimes.timeMillis();
    private final JTextPane expressionTextPane;
    private final GeneralizedSemPm semPm;
    private ExpressionParser latestParser;
    private Node node;
    private final Node errorNode;
    private String parameter;
    private final JTextArea resultTextPane;
    private String expressionString;
    private final Set<String> otherVariables;
    private final JLabel referencedParametersLabel;
    private final JCheckBox errorTermCheckBox;

    public GeneralizedExpressionEditor(GeneralizedSemPm semPm, Node node) {
        ExpressionParser parser;
        if (semPm == null) {
            throw new NullPointerException("SEM PM must be provided.");
        }
        if (node == null) {
            throw new NullPointerException("Node must be provided.");
        }
        if (!semPm.getNodes().contains(node)) {
            throw new IllegalArgumentException("The node provided must be in the graph of the SEM PM.");
        }
        this.semPm = semPm;
        this.node = node;
        this.errorNode = semPm.getErrorNode(node);
        this.expressionString = semPm.getNodeExpressionString(node);
        StyleContext sc = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(sc);
        this.expressionTextPane = new JTextPane(doc);
        this.resultTextPane = new JTextArea(semPm.getNodeExpressionString(node));
        try {
            doc.insertString(0, semPm.getNodeExpressionString(node), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Couldn't construct editor", e);
        }
        this.otherVariables = new LinkedHashSet<String>();
        for (Node _node : semPm.getNodes()) {
            if (semPm.getParents(node).contains(_node)) continue;
            this.otherVariables.add(_node.getName());
        }
        this.latestParser = parser = new ExpressionParser(this.otherVariables, ExpressionParser.RestrictionType.MAY_NOT_CONTAIN);
        try {
            parser.parseExpression(this.expressionString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parser the stored expression.", e);
        }
        this.resultTextPane.setEditable(false);
        this.resultTextPane.setBackground(Color.LIGHT_GRAY);
        Map<String, String> expressionsMap = this.getExpressionMap(semPm, node);
        String[] expressionTokens = this.getExpressionTokens(semPm, node, expressionsMap);
        JComboBox<String> expressionsBox = new JComboBox<String>(expressionTokens);
        expressionsBox.setMaximumSize(expressionsBox.getPreferredSize());
        JButton insertButton = new JButton("Insert");
        insertButton.addActionListener(actionEvent -> {
            String token = (String)expressionsBox.getSelectedItem();
            String signature = "-New Parameter-".equals(token) ? this.nextParameterName() : (String)expressionsMap.get(token);
            while (signature.contains("%")) {
                signature = signature.replaceFirst("%", this.nextParameterName());
            }
            this.expressionTextPane.replaceSelection(signature);
        });
        this.errorTermCheckBox = new JCheckBox("Automatically add error term");
        this.errorTermCheckBox.setSelected(Preferences.userRoot().getBoolean("automaticallyAddErrorTerms", true));
        this.errorTermCheckBox.addActionListener(event -> {
            JCheckBox box = (JCheckBox)event.getSource();
            Preferences.userRoot().putBoolean("automaticallyAddErrorTerms", box.isSelected());
        });
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Parents of " + node + ":  " + this.niceParentsList(semPm.getParents(node))));
        b1.add(Box.createHorizontalGlue());
        b.add(b1);
        b.add(Box.createVerticalStrut(5));
        Box b2 = Box.createHorizontalBox();
        this.referencedParametersLabel = new JLabel("Parameters:  " + this.parameterString(parser));
        b2.add(this.referencedParametersLabel);
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        b.add(Box.createVerticalStrut(5));
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Type Expression:"));
        b4.add(Box.createHorizontalGlue());
        b4.add(expressionsBox);
        b4.add(Box.createHorizontalStrut(5));
        b4.add(insertButton);
        b.add(b4);
        b.add(Box.createVerticalStrut(5));
        JScrollPane expressionScroll = new JScrollPane(this.expressionTextPane);
        expressionScroll.setPreferredSize(new Dimension(500, 50));
        Box b5 = Box.createHorizontalBox();
        b5.add(expressionScroll);
        b.add(b5);
        b.add(Box.createVerticalStrut(5));
        Box b6 = Box.createHorizontalBox();
        b6.add(new JLabel("Result:"));
        b6.add(Box.createHorizontalGlue());
        b.add(b6);
        b.add(Box.createVerticalStrut(5));
        JScrollPane resultScroll = new JScrollPane(this.resultTextPane);
        resultScroll.setPreferredSize(new Dimension(500, 50));
        Box b7 = Box.createHorizontalBox();
        b7.add(resultScroll);
        b.add(b7);
        b.add(Box.createVerticalStrut(5));
        Box b8 = Box.createHorizontalBox();
        b8.add(this.errorTermCheckBox);
        b8.add(Box.createHorizontalGlue());
        b8.add(new JLabel("* Parameter appears in other expressions."));
        b.add(b8);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GeneralizedExpressionEditor.this.listen();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GeneralizedExpressionEditor.this.listen();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GeneralizedExpressionEditor.this.listen();
            }
        });
        class ColorThread
        extends Thread {
            private boolean stop;

            ColorThread() {
            }

            @Override
            public void run() {
                StyledDocument document = (StyledDocument)GeneralizedExpressionEditor.this.expressionTextPane.getDocument();
                Style red = GeneralizedExpressionEditor.this.expressionTextPane.addStyle("Red", null);
                StyleConstants.setForeground(red, Color.RED);
                Style black = GeneralizedExpressionEditor.this.expressionTextPane.addStyle("Black", null);
                StyleConstants.setForeground(black, Color.BLACK);
                while (!this.stop) {
                    if (MillisecondTimes.timeMillis() < GeneralizedExpressionEditor.this.recolorTime) continue;
                    if (GeneralizedExpressionEditor.this.color == Color.RED) {
                        document.setCharacterAttributes(GeneralizedExpressionEditor.this.start, GeneralizedExpressionEditor.this.stringWidth, GeneralizedExpressionEditor.this.expressionTextPane.getStyle("Red"), true);
                    } else if (GeneralizedExpressionEditor.this.color == Color.BLACK) {
                        document.setCharacterAttributes(GeneralizedExpressionEditor.this.start, GeneralizedExpressionEditor.this.stringWidth, GeneralizedExpressionEditor.this.expressionTextPane.getStyle("Black"), true);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void scheduleStop() {
                this.stop = true;
            }
        }
        final ColorThread thread = new ColorThread();
        thread.start();
        this.addComponentListener(new ComponentAdapter(){
            {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                thread.scheduleStop();
            }
        });
        this.expressionTextPane.setCaretPosition(this.expressionTextPane.getText().length());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                GeneralizedExpressionEditor.this.listen();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.setFocusCycleRoot(true);
        this.expressionTextPane.grabFocus();
    }

    public GeneralizedExpressionEditor(GeneralizedSemPm semPm, String parameter) {
        if (semPm == null) {
            throw new NullPointerException("SEM PM must be provided.");
        }
        if (parameter == null) {
            throw new NullPointerException("Parameter must be provided.");
        }
        if (!semPm.getParameters().contains(parameter)) {
            throw new IllegalArgumentException("The parameter provided must be in the graph of the SEM PM.");
        }
        this.semPm = semPm;
        this.parameter = parameter;
        this.errorNode = null;
        this.expressionString = semPm.getParameterExpressionString(parameter);
        StyleContext sc = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(sc);
        this.expressionTextPane = new JTextPane(doc);
        this.resultTextPane = new JTextArea(semPm.getParameterExpressionString(parameter));
        try {
            try {
                doc.insertString(0, semPm.getParameterExpressionString(parameter), null);
            }
            catch (BadLocationException badLocationException) {}
        }
        catch (Exception e) {
            System.exit(1);
        }
        this.otherVariables = new LinkedHashSet<String>();
        for (Node _node : semPm.getNodes()) {
            this.otherVariables.add(_node.getName());
        }
        ExpressionParser parser = new ExpressionParser(this.otherVariables, ExpressionParser.RestrictionType.MAY_NOT_CONTAIN);
        try {
            parser.parseExpression(this.expressionString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parser the stored expression.", e);
        }
        this.resultTextPane.setEditable(false);
        this.resultTextPane.setBackground(Color.LIGHT_GRAY);
        Map<String, String> expressionsMap = this.getExpressionMap(semPm, this.node);
        String[] expressionTokens = this.getExpressionTokens(semPm, this.node, expressionsMap);
        JComboBox<String> expressionsBox = new JComboBox<String>(expressionTokens);
        expressionsBox.setMaximumSize(expressionsBox.getPreferredSize());
        JButton insertButton = new JButton("Insert");
        insertButton.addActionListener(actionEvent -> {
            String token = (String)expressionsBox.getSelectedItem();
            String signature = "-New Parameter-".equals(token) ? this.nextParameterName() : (String)expressionsMap.get(token);
            while (signature.contains("%")) {
                signature = signature.replaceFirst("%", this.nextParameterName());
            }
            this.expressionTextPane.replaceSelection(signature);
        });
        this.errorTermCheckBox = new JCheckBox("Automatically add error term");
        this.errorTermCheckBox.setSelected(Preferences.userRoot().getBoolean("automaticallyAddErrorTerms", true));
        Box b = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        this.referencedParametersLabel = new JLabel("Parameters:  " + this.parameterString(parser));
        b2.add(this.referencedParametersLabel);
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        b.add(Box.createVerticalStrut(5));
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Type Expression:"));
        b4.add(Box.createHorizontalGlue());
        b4.add(expressionsBox);
        b4.add(Box.createHorizontalStrut(5));
        b4.add(insertButton);
        b.add(b4);
        b.add(Box.createVerticalStrut(5));
        JScrollPane expressionScroll = new JScrollPane(this.expressionTextPane);
        expressionScroll.setPreferredSize(new Dimension(500, 50));
        Box b5 = Box.createHorizontalBox();
        b5.add(expressionScroll);
        b.add(b5);
        b.add(Box.createVerticalStrut(5));
        Box b6 = Box.createHorizontalBox();
        b6.add(new JLabel("Result:"));
        b6.add(Box.createHorizontalGlue());
        b.add(b6);
        b.add(Box.createVerticalStrut(5));
        JScrollPane resultScroll = new JScrollPane(this.resultTextPane);
        resultScroll.setPreferredSize(new Dimension(500, 50));
        Box b7 = Box.createHorizontalBox();
        b7.add(resultScroll);
        b.add(b7);
        b.add(Box.createVerticalStrut(5));
        Box b8 = Box.createHorizontalBox();
        b8.add(this.errorTermCheckBox);
        b8.add(Box.createHorizontalGlue());
        b8.add(new JLabel("* Parameter appears in other expressions."));
        b.add(b8);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GeneralizedExpressionEditor.this.listen();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GeneralizedExpressionEditor.this.listen();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GeneralizedExpressionEditor.this.listen();
            }
        });
        class ColorThread
        extends Thread {
            private boolean stop;

            ColorThread() {
            }

            @Override
            public void run() {
                StyledDocument document = (StyledDocument)GeneralizedExpressionEditor.this.expressionTextPane.getDocument();
                Style red = GeneralizedExpressionEditor.this.expressionTextPane.addStyle("Red", null);
                StyleConstants.setForeground(red, Color.RED);
                Style black = GeneralizedExpressionEditor.this.expressionTextPane.addStyle("Black", null);
                StyleConstants.setForeground(black, Color.BLACK);
                while (!this.stop) {
                    if (MillisecondTimes.timeMillis() < GeneralizedExpressionEditor.this.recolorTime) continue;
                    if (GeneralizedExpressionEditor.this.color == Color.RED) {
                        document.setCharacterAttributes(GeneralizedExpressionEditor.this.start, GeneralizedExpressionEditor.this.stringWidth, GeneralizedExpressionEditor.this.expressionTextPane.getStyle("Red"), true);
                    } else if (GeneralizedExpressionEditor.this.color == Color.BLACK) {
                        document.setCharacterAttributes(GeneralizedExpressionEditor.this.start, GeneralizedExpressionEditor.this.stringWidth, GeneralizedExpressionEditor.this.expressionTextPane.getStyle("Black"), true);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void scheduleStop() {
                this.stop = true;
            }
        }
        final ColorThread thread = new ColorThread();
        thread.start();
        this.addComponentListener(new ComponentAdapter(){
            {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                thread.scheduleStop();
            }
        });
        this.setFocusCycleRoot(true);
        this.expressionTextPane.grabFocus();
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    private String nextParameterName() {
        Set<String> parameters = this.semPm.getParameters();
        parameters.addAll(this.latestParser.getParameters());
        System.out.println("*" + parameters);
        System.out.println(this.latestParser.getParameters());
        int i = 0;
        block0: while (true) {
            String name = "b" + ++i;
            for (String parameter : parameters) {
                if (!parameter.equals(name)) continue;
                continue block0;
            }
            break;
        }
        return "b" + i;
    }

    private String niceParentsList(List<Node> nodes) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (Node node : nodes) {
            nodeNames.add(node.getName());
        }
        ArrayList _nodeNames = new ArrayList(nodeNames);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < _nodeNames.size(); ++i) {
            buf.append((String)_nodeNames.get(i));
            if (i >= nodeNames.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private void listen() {
        String valueExpressionString;
        String expressionString = this.expressionTextPane.getText();
        ExpressionParser parser = new ExpressionParser(this.otherVariables, ExpressionParser.RestrictionType.MAY_NOT_CONTAIN);
        try {
            if (!"".equals(expressionString)) {
                parser.parseExpression(expressionString);
            }
            this.color = Color.BLACK;
            this.start = 0;
            this.stringWidth = expressionString.length();
            this.recolorTime = MillisecondTimes.timeMillis();
            valueExpressionString = expressionString;
        }
        catch (ParseException e) {
            this.color = Color.RED;
            this.start = e.getErrorOffset();
            this.stringWidth = parser.getNextOffset() - e.getErrorOffset();
            this.recolorTime = MillisecondTimes.timeMillis();
            valueExpressionString = null;
        }
        if (valueExpressionString != null) {
            String formula = this.expressionTextPane.getText();
            if (this.node != null) {
                if (this.node.getNodeType() != NodeType.ERROR && !formula.contains(this.errorNode.getName()) && this.errorTermCheckBox.isSelected()) {
                    if (!formula.trim().endsWith("+") && !"".equals(formula)) {
                        formula = formula + " + ";
                    }
                    formula = formula + this.errorNode.getName();
                }
                this.expressionString = formula;
                if (this.node.getNodeType() == NodeType.ERROR) {
                    this.resultTextPane.setText(this.node + " ~ " + formula);
                } else {
                    this.resultTextPane.setText(this.node + " = " + formula);
                }
            } else if (this.parameter != null) {
                this.expressionString = formula;
                this.resultTextPane.setText(this.parameter + " ~ " + formula);
            }
            this.referencedParametersLabel.setText("Parameters:  " + this.parameterString(parser));
        }
        this.latestParser = parser;
    }

    private String parameterString(ExpressionParser parser) {
        LinkedHashSet<String> parameters = new LinkedHashSet<String>(parser.getParameters());
        for (Node _node : this.semPm.getNodes()) {
            parameters.remove(_node.getName());
        }
        ArrayList<String> parametersList = new ArrayList<String>(parameters);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < parametersList.size(); ++i) {
            buf.append((String)parametersList.get(i));
            Set<Node> referencingNodes = this.semPm.getReferencingNodes((String)parametersList.get(i));
            referencingNodes.remove(this.node);
            if (referencingNodes.size() > 0) {
                buf.append("*");
            }
            if (i >= parametersList.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private String[] getExpressionTokens(GeneralizedSemPm semPm, Node node, Map<String, String> expressionsMap) {
        ArrayList<String> _tokens = new ArrayList<String>(expressionsMap.keySet());
        if (node != null) {
            _tokens.add(semPm.getParents(node).size(), "-New Parameter-");
        }
        String[] expressionTokens = new String[_tokens.size()];
        int i = -1;
        for (String token : _tokens) {
            expressionTokens[++i] = token;
        }
        return expressionTokens;
    }

    private Map<String, String> getExpressionMap(GeneralizedSemPm semPm, Node node) {
        String[][] expressions = new String[][]{{"+", " + "}, {"-", " - "}, {"*", " * "}, {"/", " / "}, {"^", "^"}, {"pow(a, b)", "pow(%, %)"}, {"sqrt(a)", "sqrt(%)"}, {"sin(a)", "sin(%)"}, {"cos(a)", "cos(%)"}, {"tan(a)", "tan(%)"}, {"asin(a)", "asin(%)"}, {"acos(a)", "acos(%)"}, {"atan(a)", "atan(%)"}, {"sinh(a)", "sinh(%)"}, {"tanh(a)", "tanh(%)"}, {"ln(a)", "ln(%)"}, {"log10(a)", "log10(%)"}, {"round(a)", "round(%)"}, {"ceil(a)", "ceil(%)"}, {"floor(a)", "floor(%)"}, {"abs(a)", "abs(%)"}, {"max(a, b, ...)", "max(%, %)"}, {"min(a, b, ...)", "min(%, %)"}, {"AND(a, b)", "AND(%, %)"}, {"OR(a, b)", "OR(%, %)"}, {"XOR(a, b)", "XOR(%, %)"}, {"IF(a, b, c)", "IF(%, %, %)"}, {"<", " < "}, {"<=", " <= "}, {"=", " = "}, {">=", " >= "}, {">", " > "}, {"Normal(mean, sd)", "Normal(%, %)"}, {"TruncNormal(mean, sd, low, high)", "TruncNormal(%, %, %, %)"}, {"Uniform(low, high)", "Uniform(%, %)"}, {"StudentT(df)", "StudentT(%)"}, {"Beta(alpha, beta)", "Beta(%, %)"}, {"Gamma(alpha, lambda)", "Gamma(%, %)"}, {"ChiSquare(df)", "ChiSquare(%)"}, {"Hyperbolic(alpha, beta)", "Hyperbolic(%, %)"}, {"Poisson(lambda)", "Poisson(%)"}, {"ExponentialPower(tau)", "ExponentialPower(%)"}, {"Exponential(lambda)", "ExponentialLambda(%)"}, {"VonMises(freedom)", "VonMises(%)"}, {"Split(a1, b1, a2, b2, ...)", "Split(%, %, %, %)"}, {"Discrete(a1, a2, a3, a4, ...)", "Discrete(%, %, %, %)"}, {"Indicator(p)", "Indicator(.5)"}, {"Mixture(a1, dist1, b1, dist2, ...)", "Mixture(%, Normal(%, %), %, Normal(%, %))"}};
        LinkedHashMap<String, String> expressionsMap = new LinkedHashMap<String, String>();
        if (node != null) {
            List<Node> parents = semPm.getParents(node);
            for (Node parent : parents) {
                expressionsMap.put(parent.getName(), parent.getName());
            }
        }
        for (String[] expression : expressions) {
            expressionsMap.put(expression[0], expression[1]);
        }
        return expressionsMap;
    }
}

