/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.calculator.parser.ExpressionParser;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class GeneralizedExpressionParameterizer
extends JComponent {
    private final Node node;
    private final GeneralizedSemPm semPm;
    private final Map<String, Double> substitutedValues;
    private final JTextArea resultTextPane;

    public GeneralizedExpressionParameterizer(GeneralizedSemIm semIm, Node node) {
        if (semIm == null) {
            throw new NullPointerException("SEM IM must be provided.");
        }
        if (node == null) {
            throw new NullPointerException("Node must be provided.");
        }
        if (!semIm.getSemPm().getNodes().contains(node)) {
            throw new IllegalArgumentException("The node provided must be in the graph of the SEM PM.");
        }
        this.semPm = semIm.getSemPm();
        this.node = node;
        String expressionString1 = this.semPm.getNodeExpressionString(node);
        LinkedHashSet<String> otherVariables = new LinkedHashSet<String>();
        for (Node _node : this.semPm.getNodes()) {
            if (this.semPm.getParents(node).contains(_node)) continue;
            otherVariables.add(_node.getName());
        }
        ExpressionParser parser = new ExpressionParser(otherVariables, ExpressionParser.RestrictionType.MAY_NOT_CONTAIN);
        try {
            parser.parseExpression(expressionString1);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parser the stored expression.", e);
        }
        String expressionString = this.semPm.getNodeExpressionString(node);
        Set<String> referencedParameters = this.semPm.getReferencedParameters(node);
        this.substitutedValues = new HashMap<String, Double>();
        for (String parameter : referencedParameters) {
            this.substitutedValues.put(parameter, semIm.getParameterValue(parameter));
        }
        String substitutedString = semIm.getNodeSubstitutedString(node, this.substitutedValues);
        this.resultTextPane = node.getNodeType() == NodeType.ERROR ? new JTextArea(node + " ~ " + substitutedString) : new JTextArea(node + " = " + substitutedString);
        this.resultTextPane.setEditable(false);
        this.resultTextPane.setBackground(Color.LIGHT_GRAY);
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        if (node.getNodeType() == NodeType.ERROR) {
            b1.add(new JLabel(node + " ~ " + expressionString));
        } else {
            b1.add(new JLabel(node + " = " + expressionString));
        }
        b1.add(Box.createHorizontalGlue());
        b.add(b1);
        b.add(Box.createVerticalStrut(5));
        Box b2 = Box.createHorizontalBox();
        String parameterString = this.parameterString(parser);
        if ("".equals(parameterString)) {
            parameterString = "--NONE--";
        }
        JLabel referencedParametersLabel = new JLabel("Parameters:  " + parameterString);
        b2.add(referencedParametersLabel);
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        b.add(Box.createVerticalStrut(5));
        for (String parameter : referencedParameters) {
            Box c = Box.createHorizontalBox();
            c.add(new JLabel(parameter + " = "));
            class MyTextField
            extends DoubleTextField {
                private final String parameter;

                public MyTextField(String parameter, double value, int width, NumberFormat format) {
                    super(value, width, format);
                    this.parameter = parameter;
                }

                public String getParameter() {
                    return this.parameter;
                }
            }
            MyTextField field = new MyTextField(parameter, semIm.getParameterValue(parameter), 8, NumberFormatUtil.getInstance().getNumberFormat());
            field.setFilter((value, oldValue) -> {
                this.substitutedValues.put(field.getParameter(), value);
                this.resultTextPane.setText(node + " = " + semIm.getNodeSubstitutedString(node, this.substitutedValues));
                return value;
            });
            c.add(field);
            c.add(Box.createHorizontalGlue());
            b.add(c);
            b.add(Box.createVerticalStrut(5));
        }
        Box b6 = Box.createHorizontalBox();
        b6.add(new JLabel("Result:"));
        b6.add(Box.createHorizontalGlue());
        b.add(b6);
        b.add(Box.createVerticalStrut(5));
        JScrollPane resultScroll = new JScrollPane(this.resultTextPane);
        resultScroll.setPreferredSize(new Dimension(500, 50));
        Box b7 = Box.createHorizontalBox();
        b7.add(resultScroll);
        b.add(b7);
        b.add(Box.createVerticalStrut(5));
        Box b8 = Box.createHorizontalBox();
        b8.add(Box.createHorizontalGlue());
        b8.add(new JLabel("* Parameter appears in other expressions."));
        b.add(b8);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    public Map<String, Double> getParameterValues() {
        return this.substitutedValues;
    }

    private String parameterString(ExpressionParser parser) {
        LinkedHashSet<String> parameters = new LinkedHashSet<String>(parser.getParameters());
        for (Node _node : this.semPm.getNodes()) {
            parameters.remove(_node.getName());
        }
        ArrayList<String> parametersList = new ArrayList<String>(parameters);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < parametersList.size(); ++i) {
            buf.append((String)parametersList.get(i));
            Set<Node> referencingNodes = this.semPm.getReferencingNodes((String)parametersList.get(i));
            referencingNodes.remove(this.node);
            if (referencingNodes.size() > 0) {
                buf.append("*");
            }
            if (i >= parametersList.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

