/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedSemImGraphicalEditor;
import edu.cmu.tetradapp.editor.GeneralizedSemImListEditor;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.GeneralizedSemEstimatorWrapper;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class GeneralizedSemEstimatorEditor
extends JPanel
implements DelegatesEditing,
LayoutEditable {
    private static final long serialVersionUID = 5161532456725190959L;
    private GeneralizedSemImGraphicalEditor graphicalEditor;
    private final JMenuItem errorTerms;
    private final Map<Object, EditorWindow> launchedEditors = new HashMap<Object, EditorWindow>();
    private final GeneralizedSemEstimatorWrapper wrapper;

    public GeneralizedSemEstimatorEditor(GeneralizedSemEstimatorWrapper wrapper) {
        this.setLayout(new BorderLayout());
        this.wrapper = wrapper;
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Variables", this.listEditor());
        tabbedPane.add("Graph", this.graphicalEditor());
        tabbedPane.add("Report", this.estimationReport());
        this.add((Component)tabbedPane, "Center");
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        JButton execute = new JButton("Execute");
        execute.addActionListener(e -> {
            wrapper.execute();
            tabbedPane.removeAll();
            tabbedPane.add("Variables", this.listEditor());
            tabbedPane.add("Graph", this.graphicalEditor());
            tabbedPane.add("Report", this.estimationReport());
        });
        b.add(execute);
        this.add((Component)b, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.graphicalEditor.getWorkbench(), "Save Graph Image..."));
        SemGraph graph = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
        boolean shown = wrapper.isShowErrors();
        graph.setShowErrorTerms(shown);
        this.errorTerms = new JMenuItem();
        if (shown) {
            this.errorTerms.setText("Hide Error Terms");
        } else {
            this.errorTerms.setText("Show Error Terms");
        }
        this.errorTerms.addActionListener(e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if ("Hide Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Show Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
                graph1.setShowErrorTerms(false);
                wrapper.setShowErrors(false);
                this.graphicalEditor().refreshLabels();
            } else if ("Show Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Hide Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
                graph1.setShowErrorTerms(true);
                wrapper.setShowErrors(true);
                this.graphicalEditor().refreshLabels();
            }
        });
        JMenuItem lengthCutoff = new JMenuItem("Formula Cutoff");
        lengthCutoff.addActionListener(event -> {
            int length = Preferences.userRoot().getInt("maxExpressionLength", 25);
            IntTextField lengthField = new IntTextField(length, 4);
            lengthField.setFilter((value, oldValue) -> {
                try {
                    if (value > 0) {
                        Preferences.userRoot().putInt("maxExpressionLength", value);
                        return value;
                    }
                    return 0;
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            Box b12 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Formulas longer than "));
            b1.add(lengthField);
            b1.add(new JLabel(" will be replaced in the graph by \"--long formula--\"."));
            b12.add(b1);
            b12.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)b12, "Center");
            EditorWindow editorWindow = new EditorWindow(panel, "Apply Templates", "OK", false, this);
            editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent event) {
                    GeneralizedSemEstimatorEditor.this.graphicalEditor.refreshLabels();
                }
            });
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
        });
        JMenu tools = new JMenu("Tools");
        tools.add(this.errorTerms);
        tools.add(lengthCutoff);
        menuBar.add(tools);
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                for (Object o : GeneralizedSemEstimatorEditor.this.launchedEditors.keySet()) {
                    EditorWindow window = (EditorWindow)GeneralizedSemEstimatorEditor.this.launchedEditors.get(o);
                    window.closeDialog();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    @Override
    public JComponent getEditDelegate() {
        return this.graphicalEditor();
    }

    @Override
    public Graph getGraph() {
        return this.graphicalEditor().getWorkbench().getGraph();
    }

    public Map getModelEdgesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelEdgesToDisplay();
    }

    public Map getModelNodesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelNodesToDisplay();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.graphicalEditor().getWorkbench().getKnowledge();
    }

    @Override
    public Graph getSourceGraph() {
        return this.graphicalEditor().getWorkbench().getSourceGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByGraph(graph);
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    @Override
    public void layoutByKnowledge() {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByKnowledge();
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    private GeneralizedSemImGraphicalEditor graphicalEditor() {
        this.graphicalEditor = new GeneralizedSemImGraphicalEditor(this.getEstIm(), this.launchedEditors);
        this.graphicalEditor.enableEditing(false);
        return this.graphicalEditor;
    }

    private GeneralizedSemImListEditor listEditor() {
        return new GeneralizedSemImListEditor(this.getEstIm(), this.launchedEditors);
    }

    private JPanel estimationReport() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JTextArea report = new JTextArea(this.wrapper.getReport());
        p.add((Component)report, "Center");
        return p;
    }

    private GeneralizedSemIm getEstIm() {
        return this.wrapper.getSemIm();
    }
}

