/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedSemImGraphicalEditor;
import edu.cmu.tetradapp.editor.GeneralizedSemImListEditor;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.GeneralizedSemEstimatorWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemImWrapper;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class GeneralizedSemImEditor
extends JPanel
implements DelegatesEditing,
LayoutEditable {
    private final GeneralizedSemIm semIm;
    private GeneralizedSemImGraphicalEditor graphicalEditor;
    private GeneralizedSemImListEditor listEditor;
    private final JMenuItem errorTerms;
    private final Map<Object, EditorWindow> launchedEditors = new HashMap<Object, EditorWindow>();

    public GeneralizedSemImEditor(GeneralizedSemEstimatorWrapper wrapper) {
        GeneralizedSemIm semIm = wrapper.getSemIm();
        if (semIm == null) {
            throw new NullPointerException("Generalized SEM IM must not be null.");
        }
        this.semIm = semIm;
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Variables", this.listEditor());
        tabbedPane.add("Graph", this.graphicalEditor());
        this.add((Component)tabbedPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.graphicalEditor.getWorkbench(), "Save Graph Image..."));
        SemGraph graph = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
        boolean shown = wrapper.isShowErrors();
        graph.setShowErrorTerms(shown);
        this.errorTerms = new JMenuItem();
        if (shown) {
            this.errorTerms.setText("Hide Error Terms");
        } else {
            this.errorTerms.setText("Show Error Terms");
        }
        this.errorTerms.addActionListener(e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if ("Hide Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Show Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
                graph1.setShowErrorTerms(false);
                wrapper.setShowErrors(false);
                this.graphicalEditor().refreshLabels();
            } else if ("Show Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Hide Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
                graph1.setShowErrorTerms(true);
                wrapper.setShowErrors(true);
                this.graphicalEditor().refreshLabels();
            }
        });
        JMenuItem lengthCutoff = new JMenuItem("Formula Cutoff");
        lengthCutoff.addActionListener(event -> {
            int length = Preferences.userRoot().getInt("maxExpressionLength", 25);
            IntTextField lengthField = new IntTextField(length, 4);
            lengthField.setFilter((value, oldValue) -> {
                try {
                    if (value > 0) {
                        Preferences.userRoot().putInt("maxExpressionLength", value);
                        return value;
                    }
                    return 0;
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            Box b = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Formulas longer than "));
            b1.add(lengthField);
            b1.add(new JLabel(" will be replaced in the graph by \"--long formula--\"."));
            b.add(b1);
            b.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)b, "Center");
            EditorWindow editorWindow = new EditorWindow(panel, "Apply Templates", "OK", false, this);
            editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent event) {
                    GeneralizedSemImEditor.this.graphicalEditor.refreshLabels();
                }
            });
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
        });
        JMenu tools = new JMenu("Tools");
        tools.add(this.errorTerms);
        tools.add(lengthCutoff);
        menuBar.add(tools);
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                System.out.println("Ancestor removed: " + ancestorEvent.getAncestor());
                for (Object o : GeneralizedSemImEditor.this.launchedEditors.keySet()) {
                    EditorWindow window = (EditorWindow)GeneralizedSemImEditor.this.launchedEditors.get(o);
                    window.closeDialog();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    public GeneralizedSemImEditor(GeneralizedSemImWrapper wrapper) {
        if (wrapper.getSemIms() == null || wrapper.getSemIms().size() > 1) {
            throw new IllegalArgumentException("I'm sorry; this editor can only edit a single generalized SEM IM.");
        }
        GeneralizedSemIm semIm = wrapper.getSemIms().get(0);
        if (semIm == null) {
            throw new NullPointerException("Generalized SEM IM must not be null.");
        }
        this.semIm = semIm;
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Variables", this.listEditor());
        tabbedPane.add("Graph", this.graphicalEditor());
        this.add((Component)tabbedPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.graphicalEditor.getWorkbench(), "Save Graph Image..."));
        SemGraph graph = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
        boolean shown = wrapper.isShowErrors();
        graph.setShowErrorTerms(shown);
        this.errorTerms = new JMenuItem();
        if (shown) {
            this.errorTerms.setText("Hide Error Terms");
        } else {
            this.errorTerms.setText("Show Error Terms");
        }
        this.errorTerms.addActionListener(e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if ("Hide Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Show Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
                graph1.setShowErrorTerms(false);
                wrapper.setShowErrors(false);
                this.graphicalEditor().refreshLabels();
            } else if ("Show Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Hide Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
                graph1.setShowErrorTerms(true);
                wrapper.setShowErrors(true);
                this.graphicalEditor().refreshLabels();
            }
        });
        JMenuItem lengthCutoff = new JMenuItem("Formula Cutoff");
        lengthCutoff.addActionListener(event -> {
            int length = Preferences.userRoot().getInt("maxExpressionLength", 25);
            IntTextField lengthField = new IntTextField(length, 4);
            lengthField.setFilter((value, oldValue) -> {
                try {
                    if (value > 0) {
                        Preferences.userRoot().putInt("maxExpressionLength", value);
                        return value;
                    }
                    return 0;
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            Box b = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Formulas longer than "));
            b1.add(lengthField);
            b1.add(new JLabel(" will be replaced in the graph by \"--long formula--\"."));
            b.add(b1);
            b.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)b, "Center");
            EditorWindow editorWindow = new EditorWindow(panel, "Apply Templates", "OK", false, this);
            editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent event) {
                    GeneralizedSemImEditor.this.graphicalEditor.refreshLabels();
                }
            });
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
        });
        JMenu tools = new JMenu("Tools");
        tools.add(this.errorTerms);
        tools.add(lengthCutoff);
        menuBar.add(tools);
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                System.out.println("Ancestor removed: " + ancestorEvent.getAncestor());
                for (Object o : GeneralizedSemImEditor.this.launchedEditors.keySet()) {
                    EditorWindow window = (EditorWindow)GeneralizedSemImEditor.this.launchedEditors.get(o);
                    window.closeDialog();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    @Override
    public JComponent getEditDelegate() {
        return this.graphicalEditor();
    }

    @Override
    public Graph getGraph() {
        return this.graphicalEditor().getWorkbench().getGraph();
    }

    public Map getModelEdgesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelEdgesToDisplay();
    }

    public Map getModelNodesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelNodesToDisplay();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.graphicalEditor().getWorkbench().getKnowledge();
    }

    @Override
    public Graph getSourceGraph() {
        return this.graphicalEditor().getWorkbench().getSourceGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByGraph(graph);
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    @Override
    public void layoutByKnowledge() {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByKnowledge();
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    private GeneralizedSemImGraphicalEditor graphicalEditor() {
        if (this.graphicalEditor == null) {
            this.graphicalEditor = new GeneralizedSemImGraphicalEditor(this.getSemIm(), this.launchedEditors);
            this.graphicalEditor.enableEditing(false);
        }
        return this.graphicalEditor;
    }

    private GeneralizedSemImListEditor listEditor() {
        if (this.listEditor == null) {
            this.listEditor = new GeneralizedSemImListEditor(this.getSemIm(), this.launchedEditors);
        }
        return this.listEditor;
    }

    private GeneralizedSemIm getSemIm() {
        return this.semIm;
    }
}

