/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedExpressionParameterizer;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class GeneralizedSemImGraphicalEditor
extends JPanel {
    private static final long serialVersionUID = -478255924494220807L;
    private final GeneralizedSemIm semIm;
    private GraphWorkbench workbench;
    private final Map<Object, EditorWindow> launchedEditors;
    private boolean enableEditing = true;

    public GeneralizedSemImGraphicalEditor(GeneralizedSemIm semIm, Map<Object, EditorWindow> launchedEditors) {
        this.semIm = semIm;
        this.launchedEditors = launchedEditors;
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.workbench());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
        this.setBorder(new TitledBorder("Double click expressions to edit"));
    }

    public void refreshLabels() {
        List<Node> nodes = this.graph().getNodes();
        for (Node node : nodes) {
            this.resetNodeLabel(node);
        }
        this.workbench().repaint();
    }

    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    private void beginNodeEdit(final Node node) {
        if (this.launchedEditors.containsKey(node)) {
            this.launchedEditors.get(node).moveToFront();
            return;
        }
        final GeneralizedExpressionParameterizer paramEditor = new GeneralizedExpressionParameterizer(this.semIm, node);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)paramEditor, "Center");
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        final EditorWindow editorWindow = new EditorWindow(panel, "Parameter Properties", "OK", true, this.workbench());
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.pack();
        editorWindow.setVisible(true);
        this.launchedEditors.put(node, editorWindow);
        editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (!editorWindow.isCanceled()) {
                    GeneralizedSemImGraphicalEditor.this.semIm.setSubstitutions(paramEditor.getParameterValues());
                    GeneralizedSemImGraphicalEditor.this.refreshLabels();
                    GeneralizedSemImGraphicalEditor.this.launchedEditors.remove(node);
                    GeneralizedSemImGraphicalEditor.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
    }

    private GeneralizedSemIm semIm() {
        return this.semIm;
    }

    private Graph graph() {
        return this.semIm().getSemPm().getGraph();
    }

    private GraphWorkbench workbench() {
        if (this.getWorkbench() == null) {
            this.workbench = new GraphWorkbench(this.graph());
            this.getWorkbench().setAllowDoubleClickActions(false);
            this.refreshLabels();
        }
        return this.getWorkbench();
    }

    private void resetNodeLabel(Node node) {
        int maxExpressionLength = Preferences.userRoot().getInt("maxExpressionLength", 25);
        String expressionString = this.semIm.getNodeSubstitutedString(node);
        if (expressionString == null) {
            this.workbench().setNodeLabel(node, null, 0, 0);
            this.firePropertyChange("modelChanged", null, null);
            return;
        }
        if (expressionString.length() > maxExpressionLength) {
            expressionString = "- long formula -";
        }
        JLabel label = new JLabel();
        label.setForeground(Color.BLACK);
        label.setBackground(Color.WHITE);
        label.setText(expressionString);
        label.addMouseListener(new NodeMouseListener(node, this));
        if (node.getNodeType() == NodeType.ERROR) {
            label.setOpaque(false);
            Node error = this.workbench.getGraph().getNode(node.getName());
            if (error != null) {
                this.workbench().setNodeLabel(error, label, -10, -10);
            }
        } else {
            label.setOpaque(false);
            if (this.workbench.getGraph().containsNode(node)) {
                this.workbench().setNodeLabel(node, label, 0, 0);
            }
        }
        this.firePropertyChange("modelChanged", null, null);
    }

    public boolean isEnableEditing() {
        return this.enableEditing;
    }

    public void enableEditing(boolean enableEditing) {
        this.enableEditing = enableEditing;
        if (this.workbench != null) {
            this.workbench.enableEditing(enableEditing);
        }
    }

    private static final class NodeMouseListener
    extends MouseAdapter {
        private final Node node;
        private final GeneralizedSemImGraphicalEditor editor;

        public NodeMouseListener(Node node, GeneralizedSemImGraphicalEditor editor) {
            this.node = node;
            this.editor = editor;
        }

        private Node getNode() {
            return this.node;
        }

        private GeneralizedSemImGraphicalEditor getEditor() {
            return this.editor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.getEditor().beginNodeEdit(this.getNode());
            }
        }
    }
}

