/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedExpressionParameterizer;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class GeneralizedSemImListEditor
extends JPanel {
    private static final Font SMALL_FONT = new Font("Dialog", 0, 10);
    private final GeneralizedSemIm semIm;
    private Map<Object, EditorWindow> launchedEditors = new HashMap<Object, EditorWindow>();
    private final Box formulasBox;

    public GeneralizedSemImListEditor(GeneralizedSemIm semIm, Map<Object, EditorWindow> launchedEditors) {
        System.out.println("List editor : " + semIm);
        this.semIm = semIm;
        this.launchedEditors = launchedEditors;
        GeneralizedSemPm semPm = semIm.getSemPm();
        this.setLayout(new BorderLayout());
        this.formulasBox = Box.createVerticalBox();
        this.refreshLabels();
        JScrollPane scroll = new JScrollPane(this.formulasBox);
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
    }

    private JComponent refreshLabels() {
        JLabel label;
        Box c;
        this.formulasBox.removeAll();
        for (final Node node : this.semIm().getSemPm().getVariableNodes()) {
            c = Box.createHorizontalBox();
            label = new JLabel(node + " := " + this.semIm.getNodeSubstitutedString(node));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        GeneralizedSemImListEditor.this.beginNodeEdit(node, label, label);
                    }
                }
            });
            c.add(label);
            c.add(Box.createHorizontalGlue());
            this.formulasBox.add(c);
            this.formulasBox.add(Box.createVerticalStrut(5));
        }
        for (final Node node : this.semIm().getSemPm().getErrorNodes()) {
            c = Box.createHorizontalBox();
            label = new JLabel(node + " ~ " + this.semIm.getNodeSubstitutedString(node));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        GeneralizedSemImListEditor.this.beginNodeEdit(node, label, label);
                    }
                }
            });
            c.add(label);
            c.add(Box.createHorizontalGlue());
            this.formulasBox.add(c);
            this.formulasBox.add(Box.createVerticalStrut(5));
        }
        this.formulasBox.add(Box.createVerticalGlue());
        this.formulasBox.setBorder(new CompoundBorder(new TitledBorder("Double click expressions to edit."), new EmptyBorder(5, 5, 5, 5)));
        this.formulasBox.revalidate();
        this.formulasBox.repaint();
        return this.formulasBox;
    }

    private void beginNodeEdit(final Node node, JLabel label, JComponent centering) {
        if (this.launchedEditors.containsKey(node)) {
            this.launchedEditors.get(node).moveToFront();
            return;
        }
        final GeneralizedExpressionParameterizer paramEditor = new GeneralizedExpressionParameterizer(this.semIm, node);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)paramEditor, "Center");
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        final EditorWindow editorWindow = new EditorWindow(panel, "Parameter Properties", "OK", true, centering);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.pack();
        editorWindow.setVisible(true);
        this.launchedEditors.put(node, editorWindow);
        editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (!editorWindow.isCanceled()) {
                    GeneralizedSemImListEditor.this.semIm.setSubstitutions(paramEditor.getParameterValues());
                    GeneralizedSemImListEditor.this.refreshLabels();
                    GeneralizedSemImListEditor.this.launchedEditors.remove(node);
                    GeneralizedSemImListEditor.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
    }

    private GeneralizedSemIm semIm() {
        return this.semIm;
    }
}

