/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

class GeneralizedSemImParamsEditor
extends JPanel {
    private static final Font SMALL_FONT = new Font("Dialog", 0, 10);
    private final GeneralizedSemIm semIm;
    private final GeneralizedSemPm semPm;

    public GeneralizedSemImParamsEditor(GeneralizedSemIm semIm, Map<Object, EditorWindow> launchedEditors) {
        this.semIm = semIm;
        this.semPm = semIm.getSemPm();
        this.freshenDisplay();
    }

    private void freshenDisplay() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.initialValuesPane());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
    }

    private JComponent initialValuesPane() {
        Box b = Box.createVerticalBox();
        ArrayList<String> parameters = new ArrayList<String>(this.semPm().getParameters());
        Collections.sort(parameters);
        ArrayList<String> _parameters = new ArrayList<String>(this.semPm.getParameters());
        Collections.sort(_parameters);
        for (final String parameter : _parameters) {
            Box c = Box.createHorizontalBox();
            c.add(new JLabel(parameter + " = "));
            class MyTextField
            extends DoubleTextField {
                private final String parameter;

                public MyTextField(String parameter, double value, int width, NumberFormat format) {
                    super(value, width, format);
                    this.parameter = parameter;
                }

                public String getParameter() {
                    return this.parameter;
                }
            }
            MyTextField field = new MyTextField(parameter, this.semIm.getParameterValue(parameter), 8, NumberFormatUtil.getInstance().getNumberFormat());
            field.setFilter(new DoubleTextField.Filter(){

                @Override
                public double filter(double value, double oldValue) {
                    GeneralizedSemImParamsEditor.this.semIm.setParameterValue(parameter, value);
                    return value;
                }
            });
            c.add(field);
            c.add(Box.createHorizontalGlue());
            b.add(c);
            b.add(Box.createVerticalStrut(5));
        }
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        return b;
    }

    private GeneralizedSemPm semPm() {
        return this.semPm;
    }
}

