/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedSemPmGraphicalEditor;
import edu.cmu.tetradapp.editor.GeneralizedSemPmListEditor;
import edu.cmu.tetradapp.editor.GeneralizedSemPmParamsEditor;
import edu.cmu.tetradapp.editor.GeneralizedTemplateEditor;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.GeneralizedSemPmWrapper;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class GeneralizedSemPmEditor
extends JPanel
implements DelegatesEditing,
LayoutEditable {
    private final GeneralizedSemPm semPm;
    private GeneralizedSemPmGraphicalEditor graphicalEditor;
    private GeneralizedSemPmListEditor listEditor;
    private GeneralizedSemPmParamsEditor parameterEditor;
    private final JMenuItem errorTerms;
    private final Map<Object, EditorWindow> launchedEditors = new HashMap<Object, EditorWindow>();

    public GeneralizedSemPmEditor(final GeneralizedSemPmWrapper wrapper) {
        GeneralizedSemPm semPm = wrapper.getSemPm();
        if (semPm == null) {
            throw new NullPointerException("Generalized SEM PM must not be null.");
        }
        this.semPm = semPm;
        this.setLayout(new BorderLayout());
        final JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Variables", this.listEditor());
        tabbedPane.add("Parameters", this.initialValuesEditor());
        tabbedPane.add("Graph", this.graphicalEditor());
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GeneralizedSemPmEditor.this.graphicalEditor.refreshLabels();
                GeneralizedSemPmEditor.this.listEditor.refreshLabels();
                GeneralizedSemPmEditor.this.parameterEditor.refreshLabels();
            }
        });
        this.add((Component)tabbedPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.graphicalEditor.getWorkbench(), "Save Graph Image..."));
        SemGraph graph = (SemGraph)this.graphicalEditor.getWorkbench().getGraph();
        boolean shown = wrapper.isShowErrors();
        graph.setShowErrorTerms(shown);
        this.errorTerms = new JMenuItem();
        if (shown) {
            this.errorTerms.setText("Hide Error Terms");
        } else {
            this.errorTerms.setText("Show Error Terms");
        }
        this.errorTerms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                if ("Hide Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Show Error Terms");
                    SemGraph graph = (SemGraph)GeneralizedSemPmEditor.this.graphicalEditor.getWorkbench().getGraph();
                    graph.setShowErrorTerms(false);
                    wrapper.setShowErrors(false);
                    GeneralizedSemPmEditor.this.graphicalEditor().refreshLabels();
                } else if ("Show Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Hide Error Terms");
                    SemGraph graph = (SemGraph)GeneralizedSemPmEditor.this.graphicalEditor.getWorkbench().getGraph();
                    graph.setShowErrorTerms(true);
                    wrapper.setShowErrors(true);
                    GeneralizedSemPmEditor.this.graphicalEditor().refreshLabels();
                }
            }
        });
        JMenuItem templateMenu = new JMenuItem("Apply Templates...");
        templateMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final GeneralizedTemplateEditor editor = new GeneralizedTemplateEditor(GeneralizedSemPmEditor.this.getSemPm());
                String tabTitle = tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
                if ("Parameters".equals(tabTitle)) {
                    // empty if block
                }
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)editor, "Center");
                final EditorWindow editorWindow = new EditorWindow(panel, "Apply Templates", "OK", false, GeneralizedSemPmEditor.this);
                DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                editorWindow.pack();
                editorWindow.setVisible(true);
                editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                        if (!editorWindow.isCanceled()) {
                            GeneralizedSemPm _semPm = editor.getSemPm();
                            GeneralizedSemPm semPm = GeneralizedSemPmEditor.this.semPm;
                            for (Node node : _semPm.getNodes()) {
                                try {
                                    semPm.setNodeExpression(node, _semPm.getNodeExpressionString(node));
                                }
                                catch (ParseException e) {
                                    JOptionPane.showMessageDialog(GeneralizedSemPmEditor.this, "Could not set the expression for " + node + " to " + _semPm.getNodeExpressionString(node));
                                }
                            }
                            for (String startsWith : _semPm.startsWithPrefixes()) {
                                try {
                                    semPm.setStartsWithParametersTemplate(startsWith, _semPm.getStartsWithParameterTemplate(startsWith));
                                }
                                catch (ParseException e) {
                                    JOptionPane.showMessageDialog(GeneralizedSemPmEditor.this, "Could not set the expression for " + startsWith + " to " + _semPm.getParameterExpressionString(_semPm.getStartsWithParameterTemplate(startsWith)));
                                }
                            }
                            for (String parameter : _semPm.getParameters()) {
                                try {
                                    boolean found = false;
                                    for (String startsWith : _semPm.startsWithPrefixes()) {
                                        if (!parameter.startsWith(startsWith)) continue;
                                        semPm.setParameterExpression(parameter, _semPm.getStartsWithParameterTemplate(startsWith));
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    semPm.setParameterExpression(parameter, _semPm.getParameterExpressionString(parameter));
                                }
                                catch (ParseException e) {
                                    JOptionPane.showMessageDialog(GeneralizedSemPmEditor.this, "Could not set the expression for " + parameter + " to " + _semPm.getParameterExpressionString(parameter));
                                }
                            }
                            try {
                                semPm.setVariablesTemplate(_semPm.getVariablesTemplate());
                                semPm.setErrorsTemplate(_semPm.getErrorsTemplate());
                                semPm.setParametersTemplate(_semPm.getParametersTemplate());
                            }
                            catch (ParseException e) {
                                throw new RuntimeException("Could not set templates from copy of GeneralizedPm to actual GeneralizedPm.");
                            }
                            GeneralizedSemPmEditor.this.graphicalEditor.refreshLabels();
                            GeneralizedSemPmEditor.this.listEditor.refreshLabels();
                            GeneralizedSemPmEditor.this.parameterEditor.refreshLabels();
                            GeneralizedSemPmEditor.this.firePropertyChange("modelChanged", null, null);
                        }
                    }
                });
            }
        });
        JMenuItem lengthCutoff = new JMenuItem("Formula Cutoff");
        lengthCutoff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int length = Preferences.userRoot().getInt("maxExpressionLength", 25);
                IntTextField lengthField = new IntTextField(length, 4);
                lengthField.setFilter(new IntTextField.Filter(){

                    @Override
                    public int filter(int value, int oldValue) {
                        try {
                            if (value > 0) {
                                Preferences.userRoot().putInt("maxExpressionLength", value);
                                return value;
                            }
                            return 0;
                        }
                        catch (Exception e) {
                            return oldValue;
                        }
                    }
                });
                Box b = Box.createVerticalBox();
                Box b1 = Box.createHorizontalBox();
                b1.add(new JLabel("Formulas longer than "));
                b1.add(lengthField);
                b1.add(new JLabel(" will be replaced in the graph by \"--long formula--\"."));
                b.add(b1);
                b.setBorder(new EmptyBorder(5, 5, 5, 5));
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)b, "Center");
                EditorWindow editorWindow = new EditorWindow(panel, "Apply Templates", "OK", false, GeneralizedSemPmEditor.this);
                editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent event) {
                        GeneralizedSemPmEditor.this.graphicalEditor.refreshLabels();
                    }
                });
                DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                editorWindow.pack();
                editorWindow.setVisible(true);
            }
        });
        JMenu params = new JMenu("Tools");
        params.add(this.errorTerms);
        params.add(templateMenu);
        params.add(lengthCutoff);
        menuBar.add(params);
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                for (Object o : GeneralizedSemPmEditor.this.launchedEditors.keySet()) {
                    EditorWindow window = (EditorWindow)GeneralizedSemPmEditor.this.launchedEditors.get(o);
                    window.closeDialog();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private SemGraph getSemGraph() {
        return this.semPm.getGraph();
    }

    @Override
    public JComponent getEditDelegate() {
        return this.graphicalEditor();
    }

    @Override
    public Graph getGraph() {
        return this.graphicalEditor().getWorkbench().getGraph();
    }

    public Map getModelEdgesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelEdgesToDisplay();
    }

    public Map getModelNodesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelNodesToDisplay();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.graphicalEditor().getWorkbench().getKnowledge();
    }

    @Override
    public Graph getSourceGraph() {
        return this.graphicalEditor().getWorkbench().getSourceGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByGraph(graph);
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    @Override
    public void layoutByKnowledge() {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByKnowledge();
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    private GeneralizedSemPm getSemPm() {
        return this.semPm;
    }

    private GeneralizedSemPmGraphicalEditor graphicalEditor() {
        if (this.graphicalEditor == null) {
            this.graphicalEditor = new GeneralizedSemPmGraphicalEditor(this.getSemPm(), this.launchedEditors);
            this.graphicalEditor.enableEditing(false);
            this.graphicalEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if ("modelChanged".equals(event.getPropertyName())) {
                        GeneralizedSemPmEditor.this.firePropertyChange("modelChanged", null, null);
                    }
                }
            });
        }
        return this.graphicalEditor;
    }

    private GeneralizedSemPmListEditor listEditor() {
        if (this.listEditor == null) {
            this.listEditor = new GeneralizedSemPmListEditor(this.getSemPm(), this.initialValuesEditor(), this.launchedEditors);
            this.listEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if ("modelChanged".equals(event.getPropertyName())) {
                        GeneralizedSemPmEditor.this.firePropertyChange("modelChanged", null, null);
                    }
                }
            });
        }
        return this.listEditor;
    }

    private GeneralizedSemPmParamsEditor initialValuesEditor() {
        if (this.parameterEditor == null) {
            this.parameterEditor = new GeneralizedSemPmParamsEditor(this.getSemPm(), this.launchedEditors);
        }
        return this.parameterEditor;
    }
}

