/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedExpressionEditor;
import edu.cmu.tetradapp.editor.GeneralizedSemPmParamsEditor;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class GeneralizedSemPmListEditor
extends JPanel {
    private static final Font SMALL_FONT = new Font("Dialog", 0, 10);
    private final GeneralizedSemPm semPm;
    private final GeneralizedSemPmParamsEditor paramsEditor;
    private Map<Object, EditorWindow> launchedEditors = new HashMap<Object, EditorWindow>();
    private Box formulasBox;

    public GeneralizedSemPmListEditor(GeneralizedSemPm semPm, GeneralizedSemPmParamsEditor paramsEditor, Map<Object, EditorWindow> launchedEditors) {
        this.semPm = semPm;
        this.paramsEditor = paramsEditor;
        this.launchedEditors = launchedEditors;
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.equationPane());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
    }

    private JComponent equationPane() {
        this.formulasBox = Box.createVerticalBox();
        this.refreshLabels();
        return this.formulasBox;
    }

    public void refreshLabels() {
        this.formulasBox.removeAll();
        for (final Node node : this.semPm().getNodes()) {
            if (!this.semPm().getGraph().isParameterizable(node)) continue;
            Box c = Box.createHorizontalBox();
            String symbol = node.getNodeType() == NodeType.ERROR ? " ~ " : " = ";
            final JLabel label = new JLabel(node + symbol + this.semPm().getNodeExpressionString(node));
            c.add(label);
            c.add(Box.createHorizontalGlue());
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        GeneralizedSemPmListEditor.this.beginNodeEdit(node, label, label);
                    }
                }
            });
            this.formulasBox.add(c);
            this.formulasBox.add(Box.createVerticalStrut(5));
        }
        this.formulasBox.revalidate();
        this.formulasBox.repaint();
        this.formulasBox.setBorder(new CompoundBorder(new TitledBorder("Double click expressions to edit."), new EmptyBorder(5, 5, 5, 5)));
    }

    private void beginNodeEdit(final Node node, JComponent centering, final JLabel label) {
        if (this.launchedEditors.containsKey(node)) {
            this.launchedEditors.get(node).moveToFront();
            return;
        }
        final GeneralizedExpressionEditor paramEditor = new GeneralizedExpressionEditor(this.semPm, node);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)paramEditor, "Center");
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        final EditorWindow editorWindow = new EditorWindow(panel, "Edit Expression", "OK", true, centering);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.pack();
        editorWindow.setVisible(true);
        this.launchedEditors.put(node, editorWindow);
        editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (!editorWindow.isCanceled()) {
                    String expressionString = paramEditor.getExpressionString();
                    try {
                        GeneralizedSemPmListEditor.this.semPm.setNodeExpression(node, expressionString);
                        if (node.getNodeType() == NodeType.ERROR) {
                            label.setText(node + " = " + GeneralizedSemPmListEditor.this.semPm().getNodeExpressionString(node));
                        } else {
                            label.setText(node + " ~ " + GeneralizedSemPmListEditor.this.semPm().getNodeExpressionString(node));
                        }
                    }
                    catch (ParseException e) {
                        GeneralizedSemPmListEditor.this.launchedEditors.remove(node);
                        e.printStackTrace();
                        throw new RuntimeException("The expression editor returned an unparseable string: " + expressionString, e);
                    }
                    GeneralizedSemPmListEditor.this.paramsEditor.refreshLabels();
                    GeneralizedSemPmListEditor.this.firePropertyChange("modelChanged", null, null);
                }
                GeneralizedSemPmListEditor.this.launchedEditors.remove(node);
            }
        });
    }

    private GeneralizedSemPm semPm() {
        return this.semPm;
    }
}

