/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedExpressionEditor;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class GeneralizedSemPmParamsEditor
extends JPanel {
    private static final Font SMALL_FONT = new Font("Dialog", 0, 10);
    private final GeneralizedSemPm semPm;
    private Map<Object, EditorWindow> launchedEditors = new HashMap<Object, EditorWindow>();
    private Box formulasBox;

    public GeneralizedSemPmParamsEditor(GeneralizedSemPm semPm, Map<Object, EditorWindow> launchedEditors) {
        this.semPm = semPm;
        this.launchedEditors = launchedEditors;
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.initialValuesPane());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
        this.refreshLabels();
    }

    private JComponent initialValuesPane() {
        this.formulasBox = Box.createVerticalBox();
        this.refreshLabels();
        return this.formulasBox;
    }

    public void refreshLabels() {
        this.formulasBox.removeAll();
        ArrayList<String> parameters = new ArrayList<String>(this.semPm().getParameters());
        Collections.sort(parameters);
        for (final String parameter : parameters) {
            Box c = Box.createHorizontalBox();
            final JLabel label = new JLabel(parameter + " ~ " + this.semPm().getParameterExpressionString(parameter));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        GeneralizedSemPmParamsEditor.this.beginParamEdit(parameter, label, label);
                    }
                }
            });
            c.add(label);
            c.add(Box.createHorizontalGlue());
            this.formulasBox.add(c);
            this.formulasBox.add(Box.createVerticalStrut(5));
        }
        this.formulasBox.setBorder(new CompoundBorder(new TitledBorder("Double click expressions to edit."), new EmptyBorder(5, 5, 5, 5)));
        this.formulasBox.revalidate();
        this.formulasBox.repaint();
    }

    private void beginParamEdit(final String parameter, JLabel label, JComponent centering) {
        if (this.launchedEditors.containsKey(parameter)) {
            this.launchedEditors.get(parameter).moveToFront();
            return;
        }
        final GeneralizedExpressionEditor paramEditor = new GeneralizedExpressionEditor(this.semPm, parameter);
        final JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)paramEditor, "Center");
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        final EditorWindow editorWindow = new EditorWindow(panel, "Edit Expression", "OK", true, centering);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.pack();
        editorWindow.setVisible(true);
        this.launchedEditors.put(parameter, editorWindow);
        editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (!editorWindow.isCanceled()) {
                    String expressionString = paramEditor.getExpressionString();
                    try {
                        GeneralizedSemPmParamsEditor.this.semPm.setParameterExpression(parameter, expressionString);
                        GeneralizedSemPmParamsEditor.this.refreshLabels();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        GeneralizedSemPmParamsEditor.this.launchedEditors.remove(parameter);
                        throw new RuntimeException("The expression editor returned an unparseable string: " + expressionString, e);
                    }
                    catch (IllegalArgumentException e) {
                        JOptionPane.showMessageDialog(panel, e.getMessage());
                        GeneralizedSemPmParamsEditor.this.launchedEditors.remove(parameter);
                    }
                    GeneralizedSemPmParamsEditor.this.firePropertyChange("modelChanged", null, null);
                }
                GeneralizedSemPmParamsEditor.this.launchedEditors.remove(parameter);
            }
        });
    }

    private GeneralizedSemPm semPm() {
        return this.semPm;
    }

    private Graph graph() {
        return this.semPm().getGraph();
    }
}

