/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.calculator.parser.ExpressionParser;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.sem.TemplateExpander;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

class GeneralizedTemplateEditor
extends JComponent {
    private static final long serialVersionUID = 3455126100397759982L;
    private Color color = Color.BLACK;
    private int start;
    private int stringWidth;
    private long recolorTime = MillisecondTimes.timeMillis();
    private final JTextPane expressionTextPane;
    private final DefaultStyledDocument expressionTextDoc;
    private final GeneralizedSemPm semPm;
    private ExpressionParser latestParser;
    private Box equationsBox = Box.createVerticalBox();
    private final JComboBox<String> combo = new JComboBox();
    private final StringTextField startsWithField;

    public GeneralizedTemplateEditor(GeneralizedSemPm semPm) {
        ExpressionParser parser;
        if (semPm == null) {
            throw new NullPointerException("SEM PM must be provided.");
        }
        this.semPm = new GeneralizedSemPm(semPm);
        this.equationsBox = Box.createVerticalBox();
        JScrollPane scroll = new JScrollPane(this.equationsBox);
        scroll.setPreferredSize(new Dimension(400, 300));
        StyleContext sc = new StyleContext();
        this.expressionTextDoc = new DefaultStyledDocument(sc);
        this.expressionTextPane = new JTextPane(this.expressionTextDoc);
        this.setParseText(semPm.getVariablesTemplate());
        this.latestParser = parser = new ExpressionParser();
        try {
            String template = this.getSemPm().getVariablesTemplate();
            parser.parseExpression(template);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse the stored expression.", e);
        }
        final Map<String, String> expressionsMap = this.getExpressionsMap(semPm);
        String[] expressionTokens = this.getExpressionTokens(expressionsMap);
        final JComboBox<String> expressionsBox = new JComboBox<String>(expressionTokens);
        expressionsBox.setMaximumSize(expressionsBox.getPreferredSize());
        JButton insertButton = new JButton("Insert");
        insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String token = (String)expressionsBox.getSelectedItem();
                String signature = "-New Parameter-".equals(token) ? GeneralizedTemplateEditor.this.nextParameterName("b") : (String)expressionsMap.get(token);
                while (signature.contains("%")) {
                    signature = signature.replaceFirst("%", GeneralizedTemplateEditor.this.nextParameterName("b"));
                }
                GeneralizedTemplateEditor.this.expressionTextPane.replaceSelection(signature);
            }
        });
        this.combo.addItem("Variables");
        this.combo.addItem("Errors");
        this.combo.addItem("Parameter Initializations");
        this.combo.addItem("Estimation Starting Values");
        this.combo.setSelectedItem("Variables");
        this.updateEquationsDisplay();
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                String item = (String)source.getSelectedItem();
                if ("Variables".equals(item)) {
                    String variablesTemplate = GeneralizedTemplateEditor.this.getSemPm().getVariablesTemplate();
                    GeneralizedTemplateEditor.this.setParseText(variablesTemplate);
                    GeneralizedTemplateEditor.this.updateEquationsDisplay();
                } else if ("Errors".equals(item)) {
                    String errorsTemplate = GeneralizedTemplateEditor.this.getSemPm().getErrorsTemplate();
                    GeneralizedTemplateEditor.this.setParseText(errorsTemplate);
                    GeneralizedTemplateEditor.this.updateEquationsDisplay();
                } else if ("Parameter Initializations".equals(item)) {
                    String startsWith = GeneralizedTemplateEditor.this.startsWithField.getText();
                    String template = GeneralizedTemplateEditor.this.getSemPm().getStartsWithParameterTemplate(startsWith);
                    if (template == null) {
                        template = GeneralizedTemplateEditor.this.getSemPm().getParametersTemplate();
                    }
                    GeneralizedTemplateEditor.this.setParseText(template);
                    GeneralizedTemplateEditor.this.updateEquationsDisplay();
                } else if ("Estimation Starting Values".equals(item)) {
                    String startsWith = GeneralizedTemplateEditor.this.startsWithField.getText();
                    String template = GeneralizedTemplateEditor.this.getSemPm().getStartsWithParameterEstimationInitializatonTemplate(startsWith);
                    if (template == null) {
                        template = GeneralizedTemplateEditor.this.getSemPm().getParametersEstimationInitializationTemplate();
                    }
                    GeneralizedTemplateEditor.this.setParseText(template);
                    GeneralizedTemplateEditor.this.updateEquationsDisplay();
                } else {
                    throw new IllegalStateException("Unrecognized Combo Box Item: " + item);
                }
            }
        });
        JButton applyButton = new JButton("APPLY");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralizedTemplateEditor.this.applyChanges();
                GeneralizedTemplateEditor.this.updateEquationsDisplay();
                if ("Variables".equals(GeneralizedTemplateEditor.this.combo.getSelectedItem())) {
                    String template = GeneralizedTemplateEditor.this.expressionTextPane.getText();
                    try {
                        GeneralizedTemplateEditor.this.getSemPm().setVariablesTemplate(template);
                    }
                    catch (ParseException parseException) {}
                } else if ("Errors".equals(GeneralizedTemplateEditor.this.combo.getSelectedItem())) {
                    String template = GeneralizedTemplateEditor.this.expressionTextPane.getText();
                    try {
                        GeneralizedTemplateEditor.this.getSemPm().setErrorsTemplate(template);
                    }
                    catch (ParseException parseException) {}
                } else if ("Parameter Initializations".equals(GeneralizedTemplateEditor.this.combo.getSelectedItem())) {
                    String template = GeneralizedTemplateEditor.this.expressionTextPane.getText();
                    try {
                        GeneralizedTemplateEditor.this.getSemPm().setParametersTemplate(template);
                        String startsWith = GeneralizedTemplateEditor.this.startsWithField.getText();
                        GeneralizedTemplateEditor.this.getSemPm().setStartsWithParametersTemplate(startsWith, template);
                    }
                    catch (ParseException startsWith) {}
                } else if ("Estimation Starting Values".equals(GeneralizedTemplateEditor.this.combo.getSelectedItem())) {
                    String template = GeneralizedTemplateEditor.this.expressionTextPane.getText();
                    try {
                        GeneralizedTemplateEditor.this.getSemPm().setParametersEstimationInitializationTemplate(template);
                        String startsWith = GeneralizedTemplateEditor.this.startsWithField.getText();
                        GeneralizedTemplateEditor.this.getSemPm().setStartsWithParametersEstimationInitializaationTemplate(startsWith, template);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        JButton saveTemplate = new JButton("Save Template");
        saveTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralizedTemplateEditor.this.listen();
            }
        });
        this.startsWithField = new StringTextField("", 6);
        this.startsWithField.setFilter(new StringTextField.Filter(){

            @Override
            public String filter(String value, String oldValue) {
                String item = (String)GeneralizedTemplateEditor.this.combo.getSelectedItem();
                if ("Variables".equals(item)) {
                    String variablesTemplate = GeneralizedTemplateEditor.this.getSemPm().getVariablesTemplate();
                    GeneralizedTemplateEditor.this.setParseText(variablesTemplate);
                } else if ("Errors".equals(item)) {
                    String errorsTemplate = GeneralizedTemplateEditor.this.getSemPm().getErrorsTemplate();
                    GeneralizedTemplateEditor.this.setParseText(errorsTemplate);
                } else if ("Parameter Initializations".equals(item)) {
                    String startsWith = GeneralizedTemplateEditor.this.startsWithField.getText();
                    String template = GeneralizedTemplateEditor.this.getSemPm().getStartsWithParameterTemplate(startsWith);
                    if (template == null) {
                        template = GeneralizedTemplateEditor.this.getSemPm().getParametersTemplate();
                    }
                    GeneralizedTemplateEditor.this.setParseText(template);
                } else if ("Estimation Starting Values".equals(item)) {
                    String startsWith = GeneralizedTemplateEditor.this.startsWithField.getText();
                    String template = GeneralizedTemplateEditor.this.getSemPm().getStartsWithParameterEstimationInitializatonTemplate(startsWith);
                    if (template == null) {
                        template = GeneralizedTemplateEditor.this.getSemPm().getParametersEstimationInitializationTemplate();
                    }
                    GeneralizedTemplateEditor.this.setParseText(template);
                } else {
                    throw new IllegalStateException("Unrecognized Combo Box Item: " + item);
                }
                return value;
            }
        });
        Box b = Box.createVerticalBox();
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Type Template:"));
        b4.add(Box.createHorizontalGlue());
        b4.add(expressionsBox);
        b4.add(Box.createHorizontalStrut(5));
        b4.add(insertButton);
        b.add(b4);
        b.add(Box.createVerticalStrut(5));
        JScrollPane expressionScroll = new JScrollPane(this.expressionTextPane);
        expressionScroll.setPreferredSize(new Dimension(500, 50));
        Box b5 = Box.createHorizontalBox();
        b5.add(expressionScroll);
        b.add(b5);
        b.add(Box.createVerticalStrut(5));
        JPanel applyToPanel = new JPanel();
        applyToPanel.setLayout(new FlowLayout(0));
        Box b7 = Box.createHorizontalBox();
        b7.add(new JLabel("Apply to: "));
        b7.add(this.combo);
        b7.add(Box.createHorizontalGlue());
        b7.add(new JLabel("Starts with: "));
        b7.add(this.startsWithField);
        b.add(b7);
        b.add(Box.createVerticalStrut(5));
        b.add(new JScrollPane(scroll));
        Box b8 = Box.createHorizontalBox();
        b8.add(Box.createHorizontalGlue());
        b8.add(saveTemplate);
        b8.add(applyButton);
        b.add(b8);
        b.add(Box.createVerticalStrut(5));
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
        this.expressionTextDoc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GeneralizedTemplateEditor.this.listen();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GeneralizedTemplateEditor.this.listen();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GeneralizedTemplateEditor.this.listen();
            }
        });
        class ColorThread
        extends Thread {
            private boolean stop;

            ColorThread() {
            }

            @Override
            public void run() {
                StyledDocument document = (StyledDocument)GeneralizedTemplateEditor.this.expressionTextPane.getDocument();
                Style red = GeneralizedTemplateEditor.this.expressionTextPane.addStyle("Red", null);
                StyleConstants.setForeground(red, Color.RED);
                Style black = GeneralizedTemplateEditor.this.expressionTextPane.addStyle("Black", null);
                StyleConstants.setForeground(black, Color.BLACK);
                while (!this.stop) {
                    if (MillisecondTimes.timeMillis() < GeneralizedTemplateEditor.this.recolorTime) continue;
                    if (GeneralizedTemplateEditor.this.color.equals(Color.RED)) {
                        document.setCharacterAttributes(GeneralizedTemplateEditor.this.start, GeneralizedTemplateEditor.this.stringWidth, GeneralizedTemplateEditor.this.expressionTextPane.getStyle("Red"), true);
                    } else if (GeneralizedTemplateEditor.this.color == Color.BLACK) {
                        document.setCharacterAttributes(GeneralizedTemplateEditor.this.start, GeneralizedTemplateEditor.this.stringWidth, GeneralizedTemplateEditor.this.expressionTextPane.getStyle("Black"), true);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void scheduleStop() {
                this.stop = true;
            }
        }
        final ColorThread thread = new ColorThread();
        thread.start();
        this.addAncestorListener(new AncestorListener(){
            {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                thread.scheduleStop();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.expressionTextPane.setCaretPosition(this.expressionTextPane.getText().length());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                GeneralizedTemplateEditor.this.listen();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.setFocusCycleRoot(true);
    }

    private String[] getExpressionTokens(Map<String, String> expressionsMap) {
        String[] expressionTokens = new String[expressionsMap.keySet().size()];
        int i = -1;
        for (String token : expressionsMap.keySet()) {
            expressionTokens[++i] = token;
        }
        return expressionTokens;
    }

    private Map<String, String> getExpressionsMap(GeneralizedSemPm semPm) {
        String[][] templateExpressions = new String[][]{{"NEW", "NEW(b)"}, {"new", "new(b)"}, {"TSUM", "TSUM($)"}, {"tsum", "tsum($)"}, {"TPROD", "TPROD($)"}, {"tprod", "tprod($)"}};
        String[][] expressions = new String[][]{{"+", " + "}, {"-", " - "}, {"*", " * "}, {"/", " / "}, {"^", "^"}, {"pow(a, b)", "pow(%, %)"}, {"sqrt(a)", "sqrt(%)"}, {"sin(a)", "sin(%)"}, {"cos(a)", "cos(%)"}, {"tan(a)", "tan(%)"}, {"asin(a)", "asin(%)"}, {"acos(a)", "acos(%)"}, {"atan(a)", "atan(%)"}, {"sinh(a)", "sinh(%)"}, {"tanh(a)", "tanh(%)"}, {"ln(a)", "ln(%)"}, {"log10(a)", "log10(%)"}, {"round(a)", "round(%)"}, {"ceil(a)", "ceil(%)"}, {"floor(a)", "floor(%)"}, {"signum(a)", "signum(%)"}, {"abs(a)", "abs(%)"}, {"max(a, b, ...)", "max(%, %)"}, {"min(a, b, ...)", "min(%, %)"}, {"AND(a, b)", "AND(%, %)"}, {"OR(a, b)", "OR(%, %)"}, {"XOR(a, b)", "XOR(%, %)"}, {"IF(a, b, c)", "IF(%, %, %)"}, {"<", " < "}, {"<=", " <= "}, {"=", " = "}, {">=", " >= "}, {">", " > "}, {"Beta(alpha, beta)", "Beta(%, %)"}, {"Cauchy(median, scale)", "Cauchy(%, %)"}, {"ChiSquare(df)", "ChiSquare(%)"}, {"ExponentialDist(mean)", "ExponentialDist(%)"}, {"FDist(e1, e2)", "FDist(%, %)"}, {"ExponentialPower(alpha, beta)", "ExponentialPower(%, %)"}, {"Gamma(shape, scale)", "Gamma(%, %)"}, {"Gumbel(mu, beta)", "Gumbel(%, %)"}, {"Indicator(p)", "Indicator(%)"}, {"Laplace(mu, beta)", "Laplace(%, %)"}, {"Levy(mu, c)", "Levy(%, %)"}, {"LogNormal(e1, e2)", "LogNormal(%, %)"}, {"Nakagami(mu, omega)", "Nakagami(%, %)"}, {"Normal(mu, sd)", "Normal(%, %)"}, {"Poisson(lambda)", "Poisson(%)"}, {"StudentT(dof)", "StudentT(%)"}, {"Triangular(a, b, c)", "Triangular(%, %, %)"}, {"Uniform(lower, upper)", "Uniform(%, %)"}, {"Weibull(alpha, beta)", "Weibull(%, %)"}, {"Split(a1, b1, a2, b2, ...)", "Split(%, %, %, %)"}, {"TruncNormal(mean, sd, low, high)", "TruncNormal(%, %, %, %)"}, {"Discrete(a1, a2, a3, a4, ...)", "Discrete(%, %, %, %)"}, {"Mixture(a1, dist1, b1, dist2, ...)", "Mixture(%, Normal(%, %), %, Normal(%, %))"}};
        List<Node> nodes = semPm.getNodes();
        LinkedHashMap<String, String> expressionsMap = new LinkedHashMap<String, String>();
        for (String[] templateExpression : templateExpressions) {
            expressionsMap.put(templateExpression[0], templateExpression[1]);
        }
        for (Node node : nodes) {
            expressionsMap.put(node.getName(), node.getName());
        }
        for (String[] expression : expressions) {
            expressionsMap.put((String)expression[0], (String)expression[1]);
        }
        return expressionsMap;
    }

    private String nextParameterName(String base) {
        Set<String> parameters = this.getSemPm().getParameters();
        parameters.addAll(this.latestParser.getParameters());
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (String parameter : parameters) {
                if (!parameter.equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    public GeneralizedSemPm getSemPm() {
        return this.semPm;
    }

    private void setParseText(String text) {
        try {
            this.expressionTextDoc.remove(0, this.expressionTextPane.getText().length());
            this.expressionTextDoc.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void applyChanges() {
        block21: {
            String startWith;
            ArrayList<String> parameters;
            block23: {
                block22: {
                    ArrayList<Node> nodes;
                    block20: {
                        nodes = new ArrayList<Node>();
                        parameters = new ArrayList<String>();
                        startWith = this.startsWithField.getText();
                        if (!"Variables".equals(this.combo.getSelectedItem())) break block20;
                        for (Node node : this.getSemPm().getVariableNodes()) {
                            if (!this.getSemPm().getGraph().isParameterizable(node)) continue;
                            String formula = "";
                            try {
                                formula = TemplateExpander.getInstance().expandTemplate(this.expressionTextPane.getText(), this.getSemPm(), node);
                            }
                            catch (ParseException e) {
                                continue;
                            }
                            if (!node.getName().startsWith(startWith)) continue;
                            try {
                                this.getSemPm().setNodeExpression(node, formula);
                            }
                            catch (ParseException e) {
                                continue;
                            }
                            nodes.add(node);
                        }
                        break block21;
                    }
                    if (!"Errors".equals(this.combo.getSelectedItem())) break block22;
                    for (Node node : this.getSemPm().getErrorNodes()) {
                        if (!this.getSemPm().getGraph().isParameterizable(node)) continue;
                        String formula = "";
                        try {
                            formula = TemplateExpander.getInstance().expandTemplate(this.expressionTextPane.getText(), this.getSemPm(), node);
                        }
                        catch (ParseException e) {
                            continue;
                        }
                        if (!node.getName().startsWith(startWith)) continue;
                        try {
                            this.getSemPm().setNodeExpression(node, formula);
                        }
                        catch (ParseException e) {
                            continue;
                        }
                        nodes.add(node);
                    }
                    break block21;
                }
                if (!"Parameter Initializations".equals(this.combo.getSelectedItem())) break block23;
                ArrayList<String> _parameters = new ArrayList<String>(this.getSemPm().getParameters());
                Collections.sort(_parameters);
                for (String parameter : _parameters) {
                    String formula = "";
                    try {
                        formula = TemplateExpander.getInstance().expandTemplate(this.expressionTextPane.getText(), this.getSemPm(), null);
                    }
                    catch (ParseException e) {
                        continue;
                    }
                    if (!parameter.startsWith(startWith)) continue;
                    try {
                        this.getSemPm().setParameterExpression(parameter, formula);
                        this.getSemPm().setParameterExpression(startWith, parameter, formula);
                    }
                    catch (ParseException e) {
                        continue;
                    }
                    parameters.add(parameter);
                }
                break block21;
            }
            if (!"Estimation Starting Values".equals(this.combo.getSelectedItem())) break block21;
            ArrayList<String> _parameters = new ArrayList<String>(this.getSemPm().getParameters());
            Collections.sort(_parameters);
            for (String parameter : _parameters) {
                String formula = "";
                try {
                    formula = TemplateExpander.getInstance().expandTemplate(this.expressionTextPane.getText(), this.getSemPm(), null);
                }
                catch (ParseException e) {
                    continue;
                }
                if (!parameter.startsWith(startWith)) continue;
                try {
                    this.getSemPm().setParameterEstimationInitializationExpression(parameter, formula);
                    this.getSemPm().setParameterEstimationInitializationExpression(startWith, parameter, formula);
                }
                catch (ParseException e) {
                    continue;
                }
                parameters.add(parameter);
            }
        }
    }

    private void updateEquationsDisplay() {
        this.equationsBox.removeAll();
        if ("Variables".equals(this.combo.getSelectedItem())) {
            for (Node node : this.getSemPm().getVariableNodes()) {
                if (!this.getSemPm().getGraph().isParameterizable(node)) continue;
                Box c = Box.createHorizontalBox();
                String symbol = node.getNodeType() == NodeType.ERROR ? " ~ " : " = ";
                JLabel label = new JLabel(node + symbol + this.getSemPm().getNodeExpressionString(node));
                c.add(label);
                c.add(Box.createHorizontalGlue());
                this.equationsBox.add(c);
                this.equationsBox.add(Box.createVerticalStrut(5));
            }
        } else if ("Errors".equals(this.combo.getSelectedItem())) {
            for (Node node : this.getSemPm().getErrorNodes()) {
                if (node == null) continue;
                Box c = Box.createHorizontalBox();
                String symbol = node.getNodeType() == NodeType.ERROR ? " ~ " : " = ";
                JLabel label = new JLabel(node + symbol + this.getSemPm().getNodeExpressionString(node));
                c.add(label);
                c.add(Box.createHorizontalGlue());
                this.equationsBox.add(c);
                this.equationsBox.add(Box.createVerticalStrut(5));
            }
        } else if ("Parameter Initializations".equals(this.combo.getSelectedItem())) {
            ArrayList<String> _parameters = new ArrayList<String>(this.getSemPm().getParameters());
            Collections.sort(_parameters);
            for (String parameter : _parameters) {
                Box c = Box.createHorizontalBox();
                JLabel label = new JLabel(parameter + " ~ " + this.getSemPm().getParameterExpressionString(parameter));
                c.add(label);
                c.add(Box.createHorizontalGlue());
                this.equationsBox.add(c);
                this.equationsBox.add(Box.createVerticalStrut(5));
            }
        } else if ("Estimation Starting Values".equals(this.combo.getSelectedItem())) {
            ArrayList<String> _parameters = new ArrayList<String>(this.getSemPm().getParameters());
            Collections.sort(_parameters);
            for (String parameter : _parameters) {
                Box c = Box.createHorizontalBox();
                JLabel label = new JLabel(parameter + " ~ " + this.getSemPm().getParameterEstimationInitializationExpressionString(parameter));
                c.add(label);
                c.add(Box.createHorizontalGlue());
                this.equationsBox.add(c);
                this.equationsBox.add(Box.createVerticalStrut(5));
            }
        }
        this.equationsBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.equationsBox.revalidate();
        this.equationsBox.repaint();
    }

    private void listen() {
        String expressionString = this.expressionTextPane.getText();
        ExpressionParser parser = new ExpressionParser();
        try {
            if (!"".equals(expressionString.trim())) {
                parser.parseExpression(expressionString);
            }
            this.color = Color.BLACK;
            this.start = 0;
            this.stringWidth = expressionString.length();
            this.recolorTime = MillisecondTimes.timeMillis();
            String startsWithText = this.startsWithField.getValue().trim();
            if ("Variables".equals(this.combo.getSelectedItem())) {
                if (!"".equals(expressionString.trim())) {
                    // empty if block
                }
            } else if ("Errors".equals(this.combo.getSelectedItem())) {
                if (!"".equals(expressionString.trim())) {
                    // empty if block
                }
            } else if ("Parameter Initializations".equals(this.combo.getSelectedItem())) {
                if (!"".equals(startsWithText.trim())) {
                    this.getSemPm().setStartsWithParametersTemplate(startsWithText, expressionString);
                }
            } else if ("Estimation Starting Values".equals(this.combo.getSelectedItem()) && !"".equals(startsWithText.trim())) {
                this.getSemPm().setStartsWithParametersEstimationInitializaationTemplate(startsWithText, expressionString);
            }
        }
        catch (ParseException e) {
            this.color = Color.RED;
            this.start = e.getErrorOffset();
            this.stringWidth = parser.getNextOffset() - e.getErrorOffset();
            this.recolorTime = MillisecondTimes.timeMillis();
        }
        this.latestParser = parser;
    }
}

