/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.editor.ScatterPlotEditorPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.apache.commons.math3.util.FastMath;

class GranularityListener
implements FocusListener,
ActionListener {
    private final ScatterPlotEditorPanel sp;
    private final int index;

    public GranularityListener(ScatterPlotEditorPanel sp, int index) {
        this.sp = sp;
        this.index = index;
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.focusLost(null);
    }

    @Override
    public void focusLost(FocusEvent evt) {
        JScrollBar currentBar = (JScrollBar)this.sp.scrollers.get(this.index);
        currentBar.setValue((int)FastMath.floor(currentBar.getMinimum()));
        int newVisibleAmount = (int)Double.parseDouble(((JTextField)this.sp.granularity.get(this.index)).getText());
        if ((double)newVisibleAmount > FastMath.ceil(currentBar.getMaximum()) - FastMath.floor(currentBar.getMinimum())) {
            newVisibleAmount = (int)(FastMath.ceil(currentBar.getMaximum()) - FastMath.floor(currentBar.getMinimum()));
        }
        currentBar.setVisibleAmount(newVisibleAmount);
        ((JLabel)this.sp.slideLabels.get(this.index)).setText("Viewing Range: [" + currentBar.getValue() + ", " + (currentBar.getValue() + currentBar.getVisibleAmount()) + "]");
    }
}

