/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.LoadGraph;
import edu.cmu.tetradapp.editor.LoadGraphJson;
import edu.cmu.tetradapp.editor.LoadGraphPcalg;
import edu.cmu.tetradapp.editor.LoadGraphTxt;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SaveGraph;
import javax.swing.JComponent;
import javax.swing.JMenu;

public final class GraphFileMenu
extends JMenu {
    private static final long serialVersionUID = 8003709852565658589L;

    public GraphFileMenu(GraphEditable editable, JComponent comp, boolean saveOnly) {
        super("File");
        if (!saveOnly) {
            JMenu load = new JMenu("Load...");
            this.add(load);
            load.add(new LoadGraph(editable, "XML..."));
            load.add(new LoadGraphTxt(editable, "Text..."));
            load.add(new LoadGraphJson(editable, "Json..."));
            load.add(new LoadGraphPcalg(editable, "PCALG..."));
        }
        JMenu save = new JMenu("Save...");
        this.add(save);
        save.add(new SaveGraph(editable, "XML...", SaveGraph.Type.xml));
        save.add(new SaveGraph(editable, "Text...", SaveGraph.Type.text));
        save.add(new SaveGraph(editable, "Json...", SaveGraph.Type.json));
        save.add(new SaveGraph(editable, "R...", SaveGraph.Type.r));
        save.add(new SaveGraph(editable, "Dot...", SaveGraph.Type.dot));
        save.add(new SaveGraph(editable, "PCALG...", SaveGraph.Type.pcalg));
        this.addSeparator();
        this.add(new SaveComponentImage(comp, "Save Graph Image..."));
    }
}

