/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.editor.RandomDagScaleFreeEditor;
import edu.cmu.tetradapp.editor.RandomGraphEditor;
import edu.cmu.tetradapp.editor.RandomMimParamsEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class GraphParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params = new Parameters();

    @Override
    public void setParams(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.setup();
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        String type;
        boolean cyclicAllowed = this.params.getBoolean("cyclicAllowed", false);
        RandomGraphEditor randomDagEditor = new RandomGraphEditor(cyclicAllowed, this.params);
        RandomMimParamsEditor randomMimEditor = new RandomMimParamsEditor(this.params);
        RandomDagScaleFreeEditor randomScaleFreeEditor = new RandomDagScaleFreeEditor();
        this.setLayout(new BorderLayout());
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createVerticalBox();
        b2.setBorder(new TitledBorder(""));
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("DAG", randomDagEditor);
        tabs.add("MIM", randomMimEditor);
        tabs.add("Scale Free", randomScaleFreeEditor);
        switch (type = this.params.getString("randomGraphType", "Uniform")) {
            case "Uniform": {
                tabs.setSelectedIndex(0);
                break;
            }
            case "Mim": {
                tabs.setSelectedIndex(1);
                break;
            }
            case "ScaleFree": {
                tabs.setSelectedIndex(2);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized graph type: " + type);
            }
        }
        tabs.addChangeListener(changeEvent -> {
            JTabbedPane pane = (JTabbedPane)changeEvent.getSource();
            if (pane.getSelectedIndex() == 0) {
                this.params.set("randomGraphType", "Uniform");
            } else if (pane.getSelectedIndex() == 1) {
                this.params.set("randomGraphType", "Mim");
            } else if (pane.getSelectedIndex() == 2) {
                this.params.set("randomGraphType", "ScaleFree");
            }
        });
        Box b6 = Box.createHorizontalBox();
        b6.add(tabs);
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }
}

