/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GraphPropertiesAction
extends AbstractAction
implements ClipboardOwner {
    private GraphWorkbench workbench;

    public GraphPropertiesAction(GraphWorkbench workbench) {
        super("Graph Properties");
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int n;
        Box b = Box.createVerticalBox();
        int numLatents = 0;
        for (Node node : this.getGraph().getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            ++numLatents;
        }
        int maxIndegree = 0;
        for (Node node : this.getGraph().getNodes()) {
            int indegree = this.getGraph().getNodesInTo(node, Endpoint.ARROW).size();
            if (indegree <= maxIndegree) continue;
            maxIndegree = indegree;
        }
        boolean bl = false;
        for (Node node : this.getGraph().getNodes()) {
            int outdegree = this.getGraph().getNodesOutTo(node, Endpoint.ARROW).size();
            if (outdegree <= n) continue;
            n = outdegree;
        }
        List<Node> list = this.getGraph().getNodes();
        int numTwoCycles = 0;
        int numDirectedEdges = 0;
        int numBidirectedEdges = 0;
        int numUndirectedEdges = 0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i; j < list.size(); ++j) {
                Node n1 = list.get(i);
                Node n2 = list.get(j);
                if (this.getGraph().getDirectedEdge(n1, n2) != null && this.getGraph().getDirectedEdge(n2, n1) != null) {
                    ++numTwoCycles;
                    continue;
                }
                if (this.getGraph().getEdges(n1, n2).size() != 1) continue;
                if (this.getGraph().getEdge(n1, n2).isDirected()) {
                    ++numDirectedEdges;
                    continue;
                }
                if (Edges.isBidirectedEdge(this.getGraph().getEdge(n1, n2))) {
                    ++numBidirectedEdges;
                    continue;
                }
                if (!Edges.isUndirectedEdge(this.getGraph().getEdge(n1, n2))) continue;
                ++numUndirectedEdges;
            }
        }
        boolean cyclic = this.getGraph().paths().existsDirectedCycle();
        int numAdjacencies = 0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i; j < list.size(); ++j) {
                if (!this.getGraph().isAdjacentTo(list.get(i), list.get(j))) continue;
                ++numAdjacencies;
            }
        }
        int numEdges = 0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i; j < list.size(); ++j) {
                numEdges += this.getGraph().getEdges(list.get(i), list.get(j)).size();
            }
        }
        JTextArea textArea = new JTextArea();
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setPreferredSize(new Dimension(400, 300));
        textArea.append("\nNumber of nodes: " + this.getGraph().getNumNodes());
        textArea.append("\nNumber of latents: " + numLatents);
        textArea.append("\nNumber of edges: " + numEdges);
        textArea.append("\nNumber of adjacencies: " + numAdjacencies);
        textArea.append("\nNumber of two-cycles: " + numTwoCycles);
        textArea.append("\nNumber of directed edges not in two cycles: " + numDirectedEdges);
        textArea.append("\nNumber of bidirected edges: " + numBidirectedEdges);
        textArea.append("\nNumber of undirected edges: " + numUndirectedEdges);
        textArea.append("\nMax degree: " + this.getGraph().getDegree());
        textArea.append("\nMax indegree: " + maxIndegree);
        textArea.append("\nMax outdegree: " + n);
        int numVars = this.getGraph().getNumNodes();
        double avgDegree = (double)(2 * numAdjacencies) / (double)numVars;
        double density = avgDegree / (double)(numVars - 1);
        textArea.append("\nAverage degree: " + NumberFormat.getInstance().format(avgDegree));
        textArea.append("\nDensity: " + NumberFormat.getInstance().format(density));
        textArea.append("\nNumber of latents: " + numLatents);
        textArea.append("\n" + (cyclic ? "Cyclic" : "Acyclic"));
        Box b2 = Box.createHorizontalBox();
        b2.add(scroll);
        textArea.setCaretPosition(0);
        b.add(b2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(b);
        for (Node x : this.getGraph().getNodes()) {
            System.out.println("district(" + x + ") = " + GraphUtils.district(x, this.getGraph()));
        }
        EditorWindow window = new EditorWindow(panel, "Graph Properties", "Close", false, this.workbench);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setGraph(Graph graph, GraphWorkbench workbench) {
        workbench.setGraph(graph);
        this.workbench = workbench;
    }

    public Graph getGraph() {
        return this.workbench.getGraph();
    }
}

