/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.graph.TripleClassifier;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.PathsAction;
import edu.cmu.tetradapp.editor.SaveGraph;
import edu.cmu.tetradapp.editor.UnderliningsAction;
import edu.cmu.tetradapp.model.GraphSelectionWrapper;
import edu.cmu.tetradapp.ui.DualListPanel;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class GraphSelectionEditor
extends JPanel
implements GraphEditable,
TripleClassifier {
    private static final long serialVersionUID = 2754618060275627122L;
    private final GraphEditorOptionsPanel graphEditorOptionsPanel;
    private final JComboBox<GraphSelectionWrapper.Type> graphTypeCombo = new JComboBox();
    private final HelpSet helpSet;
    private final GraphSelectionWrapper wrapper;
    private final JTabbedPane tabbedPane = new JTabbedPane(2);
    private final List<GraphWorkbench> workbenches = new ArrayList<GraphWorkbench>();
    private JPanel workbenchScrollsPanel = new JPanel();
    private GraphPropertiesAction graphAction;
    private Map<String, List<Integer>> layoutGraph;
    private int prevSelected = 0;

    public GraphSelectionEditor(final GraphSelectionWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("The regression wrapper is required.");
        }
        this.wrapper = wrapper;
        if (this.layoutGraph == null) {
            this.layoutGraph = new HashMap<String, List<Integer>>();
        }
        String helpHS = "/resources/javahelp/TetradHelp.hs";
        try {
            URL url = this.getClass().getResource(helpHS);
            this.helpSet = new HelpSet(null, url);
        }
        catch (Exception ee) {
            System.out.println("HelpSet " + ee.getMessage());
            System.out.println("HelpSet " + helpHS + " not found");
            throw new IllegalArgumentException();
        }
        this.setLayout(new BorderLayout());
        this.graphEditorOptionsPanel = new GraphEditorOptionsPanel(wrapper);
        this.setSelectedGraphType(wrapper.getType());
        this.workbenchScrollsPanel = this.workbenchScrollsPanel(wrapper);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(new PaddingPanel(this.graphEditorOptionsPanel));
        splitPane.setRightComponent(new PaddingPanel(this.workbenchScrollsPanel));
        splitPane.setDividerLocation(383);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton executeButton = new JButton("Graph It!");
        executeButton.addActionListener(e -> {
            Window owner = (Window)this.getTopLevelAncestor();
            new WatchedProcess(owner){

                @Override
                public void watch() {
                    GraphWorkbench workbench = GraphSelectionEditor.this.getWorkbench();
                    List<DisplayNode> displayNodes = workbench.getSelectedNodes();
                    ArrayList<Node> newSelected = new ArrayList<Node>();
                    for (DisplayNode node : displayNodes) {
                        newSelected.add(node.getModelNode());
                    }
                    if (!newSelected.isEmpty()) {
                        GraphSelectionEditor.this.graphEditorOptionsPanel.setSelected(newSelected);
                    }
                    GraphSelectionEditor.this.tabbedPaneGraphs(wrapper);
                }
            };
        });
        this.workbenchScrollsPanel.validate();
        buttonPanel.add(executeButton);
        JLabel infoLabel = new JLabel("More information on graph edge types and colorings");
        infoLabel.setFont(new Font("SansSerif", 0, 12));
        JButton infoBtn = new JButton(new ImageIcon(ImageUtils.getImage(this, "info.png")));
        infoBtn.setBorder(new EmptyBorder(0, 0, 0, 0));
        infoBtn.addActionListener(e -> {
            this.helpSet.setHomeID("graph_edge_types");
            HelpBroker broker = this.helpSet.createHelpBroker();
            CSH.DisplayHelpFromSource listener = new CSH.DisplayHelpFromSource(broker);
            listener.actionPerformed(e);
        });
        buttonPanel.add(infoLabel);
        buttonPanel.add(infoBtn);
        this.add((Component)this.createTopMenuBar(), "North");
        this.add((Component)splitPane, "Center");
        this.add((Component)buttonPanel, "South");
        this.graphEditorOptionsPanel.reset();
    }

    private JMenuBar createTopMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu saveMenu = this.createSaveMenu(this);
        menuBar.add(saveMenu);
        JMenu graphMenu = this.createGraphMenu();
        menuBar.add(graphMenu);
        return menuBar;
    }

    private void graphTypeSelection() {
        for (GraphSelectionWrapper.Type type : GraphSelectionWrapper.Type.values()) {
            this.graphTypeCombo.addItem(type);
        }
        this.graphTypeCombo.setSelectedItem((Object)this.wrapper.getType());
        this.graphTypeCombo.addActionListener(e -> {
            GraphSelectionWrapper.Type selectedItem = (GraphSelectionWrapper.Type)((Object)((Object)this.graphTypeCombo.getSelectedItem()));
            assert (selectedItem != null);
            this.wrapper.setType(selectedItem);
            this.setSelectedGraphType(selectedItem);
        });
    }

    private void setSelectedGraphType(GraphSelectionWrapper.Type type) {
        if (type == GraphSelectionWrapper.Type.Subgraph) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Adjacents) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Adjacents_of_Adjacents) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Adjacents_of_Adjacents_of_Adjacents) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Pag_Y_Structures) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Markov_Blankets) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Y_Structures) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Pag_Y_Structures) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
        if (type == GraphSelectionWrapper.Type.Treks) {
            this.graphEditorOptionsPanel.setNLabel("Path Length");
        }
        if (type == GraphSelectionWrapper.Type.Trek_Edges) {
            this.graphEditorOptionsPanel.setNLabel("Path Length");
        }
        if (type == GraphSelectionWrapper.Type.Paths) {
            this.graphEditorOptionsPanel.setNLabel("Path Length");
        }
        if (type == GraphSelectionWrapper.Type.Path_Edges) {
            this.graphEditorOptionsPanel.setNLabel("Path Length");
        }
        if (type == GraphSelectionWrapper.Type.Directed_Paths) {
            this.graphEditorOptionsPanel.setNLabel("Path Length");
        }
        if (type == GraphSelectionWrapper.Type.Directed_Path_Edges) {
            this.graphEditorOptionsPanel.setNLabel("Path Length");
        }
        if (type == GraphSelectionWrapper.Type.Indegree) {
            this.graphEditorOptionsPanel.setNLabel("Indegree");
        }
        if (type == GraphSelectionWrapper.Type.Out_Degree) {
            this.graphEditorOptionsPanel.setNLabel("Outdegree");
        }
        if (type == GraphSelectionWrapper.Type.Degree) {
            this.graphEditorOptionsPanel.setNLabel("");
        }
    }

    private JPanel workbenchScrollsPanel(GraphSelectionWrapper wrapper) {
        int i;
        ArrayList<JScrollPane> workbenchScrolls = new ArrayList<JScrollPane>();
        List<Graph> graphs = wrapper.getGraphs();
        for (i = 0; i < graphs.size(); ++i) {
            GraphWorkbench workbench = new GraphWorkbench();
            this.workbenches.add(workbench);
            workbench.addPropertyChangeListener(evt -> {
                if ("modelChanged".equals(evt.getPropertyName())) {
                    this.firePropertyChange("modelChanged", null, null);
                }
            });
            JScrollPane workbenchScroll = new JScrollPane(workbench);
            workbenchScroll.setPreferredSize(new Dimension(520, 560));
            workbenchScrolls.add(workbenchScroll);
        }
        for (i = 0; i < workbenchScrolls.size(); ++i) {
            this.tabbedPane.add("" + (i + 1), (Component)workbenchScrolls.get(i));
        }
        this.tabbedPane.addChangeListener(e -> {
            if (e.getSource() instanceof JTabbedPane) {
                JTabbedPane panel = (JTabbedPane)e.getSource();
                int selectedIndex = panel.getSelectedIndex();
                selectedIndex = selectedIndex == -1 ? 0 : selectedIndex;
                this.graphAction.setGraph(wrapper.getGraphs().get(selectedIndex), this.getWorkbench());
            }
        });
        this.tabbedPaneGraphs(wrapper);
        this.workbenchScrollsPanel.setLayout(new BorderLayout());
        this.workbenchScrollsPanel.add((Component)this.tabbedPane, "Center");
        this.workbenchScrollsPanel.validate();
        return this.workbenchScrollsPanel;
    }

    private void tabbedPaneGraphs(GraphSelectionWrapper wrapper) {
        wrapper.calculateSelection();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Graph selection = wrapper.getSelectionGraph(i);
            if (!this.layoutGraph.isEmpty()) {
                for (Node node : selection.getNodes()) {
                    List<Integer> center = this.layoutGraph.get(node.getName());
                    if (center == null) continue;
                    node.setCenter(center.get(0), center.get(1));
                }
            }
            GraphWorkbench workbench = this.getWorkbench(i);
            workbench.setGraph(selection);
            List<Node> selected = wrapper.getSelectedVariables();
            for (Node node : selected) {
                if (!wrapper.getHighlightInEditor().contains(node) || !workbench.getGraph().containsNode(node)) continue;
                workbench.selectNode(node);
            }
        }
    }

    private JMenu createSaveMenu(GraphEditable editable) {
        JMenu save = new JMenu("Save As");
        save.add(new SaveGraph(editable, "Graph XML...", SaveGraph.Type.xml));
        save.add(new SaveGraph(editable, "Graph Text...", SaveGraph.Type.text));
        save.add(new SaveGraph(editable, "Graph Json...", SaveGraph.Type.json));
        save.add(new SaveGraph(editable, "R...", SaveGraph.Type.r));
        save.add(new SaveGraph(editable, "Dot...", SaveGraph.Type.dot));
        return save;
    }

    private JMenu createGraphMenu() {
        JMenu graph = new JMenu("Graph");
        this.graphAction = new GraphPropertiesAction(this.getWorkbench());
        graph.add(this.graphAction);
        graph.add(new PathsAction(this.getWorkbench()));
        UnderliningsAction underliningsAction = new UnderliningsAction(this.getWorkbench());
        graph.add(underliningsAction);
        return graph;
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public List getSelectedModelComponents() {
        List<Component> selectedComponents = this.getWorkbench().getSelectedComponents();
        ArrayList<Comparable<Node>> selectedModelComponents = new ArrayList<Comparable<Node>>();
        for (Component comp : selectedComponents) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List<Object> sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (Object o : sessionElements) {
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        return this.getWorkbench(selectedIndex);
    }

    public GraphWorkbench getWorkbench(int selectionIndex) {
        Graph layout = this.workbenches.get(this.prevSelected).getGraph();
        this.setLayoutGraph(layout);
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        Graph graph = this.workbenches.get(selectedIndex).getGraph();
        for (Node node : graph.getNodes()) {
            List<Integer> center = this.layoutGraph.get(node.getName());
            if (center == null) continue;
            node.setCenter(center.get(0), center.get(1));
        }
        this.prevSelected = selectedIndex;
        return this.workbenches.get(selectionIndex);
    }

    @Override
    public Graph getGraph() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        return this.wrapper.getSelectionGraph(selectedIndex);
    }

    @Override
    public void setGraph(Graph graph) {
        this.wrapper.setGraphs(Collections.singletonList(graph));
        this.graphEditorOptionsPanel.reset();
        this.getWorkbench().setGraph(graph);
    }

    public void replace(List<Graph> graphs) {
        for (Graph graph : graphs) {
            for (Node node : graph.getNodes()) {
                List<Integer> center = this.layoutGraph.get(node.getName());
                if (center == null) continue;
                node.setCenter(center.get(0), center.get(1));
            }
        }
        this.wrapper.setGraphs(graphs);
        this.workbenchScrollsPanel(this.wrapper);
        this.tabbedPaneGraphs(this.wrapper);
        this.graphEditorOptionsPanel.reset();
    }

    private void setLayoutGraph(Graph graph) {
        this.layoutGraph.clear();
        for (Node node : graph.getNodes()) {
            ArrayList<Integer> center = new ArrayList<Integer>();
            center.add(node.getCenterX());
            center.add(node.getCenterY());
            this.layoutGraph.put(node.getName(), center);
        }
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Underlines");
        names.add("Dotted Underlines");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getUnderlinedTriplesFromGraph(node, graph));
        triplesList.add(GraphUtils.getDottedUnderlinedTriplesFromGraph(node, graph));
        return triplesList;
    }

    public class GraphEditorOptionsPanel
    extends JPanel {
        private static final long serialVersionUID = -991342933507624509L;
        private final JLabel nLabel;
        private final JRadioButton equals;
        private final JRadioButton atMost;
        private final JRadioButton atLeast;
        private final IntTextField nField;
        private final JList<Node> selectedList;
        private final DualListPanel dualListPanel;
        private final Font _font = new Font("Dialog", 0, 12);
        private final JList<Node> sourceList;

        public GraphEditorOptionsPanel(GraphSelectionWrapper graphSelectionWrapper) {
            if (graphSelectionWrapper == null) {
                throw new NullPointerException("Graph wrapper must not be null");
            }
            this.nLabel = new JLabel("Degree");
            this.equals = new JRadioButton("Equals");
            this.atMost = new JRadioButton("At Most");
            this.atLeast = new JRadioButton("At Least");
            this.nField = new IntTextField(GraphSelectionEditor.this.wrapper.getN(), 2);
            this.dualListPanel = new DualListPanel();
            this.sourceList = this.dualListPanel.getSourceList();
            this.selectedList = this.dualListPanel.getSelectedList();
            this.initList(this.sourceList);
            this.initList(this.selectedList);
            this.dualListPanel.getMoveToSource().addActionListener(e -> {
                for (GraphWorkbench workbench : GraphSelectionEditor.this.workbenches) {
                    workbench.deselectAll();
                }
                VariableListModel selectedModel = (VariableListModel)this.getSelectedList().getModel();
                VariableListModel sourceModel = (VariableListModel)this.getSourceList().getModel();
                List<Node> selected = this.getSelected(this.getSelectedList());
                selectedModel.removeAll(selected);
                sourceModel.addAll(selected);
                GraphSelectionEditor.this.wrapper.setSelectedVariables(this.getSelected());
                this.getSelectedList().setSelectedIndices(new int[0]);
                this.getSourceList().setSelectedIndices(new int[0]);
            });
            this.dualListPanel.getMoveToselector().addActionListener(e -> {
                for (GraphWorkbench workbench : GraphSelectionEditor.this.workbenches) {
                    workbench.deselectAll();
                }
                VariableListModel selectedModel = (VariableListModel)this.getSelectedList().getModel();
                VariableListModel sourceModel = (VariableListModel)this.getSourceList().getModel();
                List<Node> selected = this.getSelected(this.getSourceList());
                sourceModel.removeAll(selected);
                selectedModel.addAll(selected);
                this.getSelectedList().setSelectedIndices(new int[0]);
                this.getSourceList().setSelectedIndices(new int[0]);
                GraphSelectionEditor.this.wrapper.setSelectedVariables(this.getSelected());
            });
            VariableListModel selectedModel = (VariableListModel)this.getSelectedList().getModel();
            VariableListModel variableModel = (VariableListModel)this.getSourceList().getModel();
            List<Node> selectedNodes = GraphSelectionEditor.this.wrapper.getSelectedVariables();
            ArrayList<Node> initVars = new ArrayList<Node>(GraphSelectionEditor.this.wrapper.getVariables());
            initVars.removeAll(selectedNodes);
            variableModel.addAll(initVars);
            selectedModel.addAll(selectedNodes);
            new DropTarget(this.getSourceList(), 2, new TargetListener(), true);
            new DropTarget(this.getSelectedList(), 2, new TargetListener(), true);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this.getSourceList(), 2, new SourceListener());
            dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this.getSelectedList(), 2, new SourceListener());
            ButtonGroup group2 = new ButtonGroup();
            group2.add(this.equals);
            group2.add(this.atMost);
            group2.add(this.atLeast);
            if (GraphSelectionEditor.this.wrapper.getNType().equals(GraphSelectionWrapper.nType.equals.toString())) {
                this.equals.setSelected(true);
            } else if (GraphSelectionEditor.this.wrapper.getNType().equals(GraphSelectionWrapper.nType.atMost.toString())) {
                this.atMost.setSelected(true);
            } else {
                this.atLeast.setSelected(true);
            }
            this.equals.addActionListener(e -> GraphSelectionEditor.this.wrapper.setNType(GraphSelectionWrapper.nType.equals));
            this.atMost.addActionListener(e -> GraphSelectionEditor.this.wrapper.setNType(GraphSelectionWrapper.nType.atMost));
            this.atLeast.addActionListener(e -> GraphSelectionEditor.this.wrapper.setNType(GraphSelectionWrapper.nType.atLeast));
            this.nField.setFilter((value, oldValue) -> {
                try {
                    GraphSelectionEditor.this.wrapper.setN(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            this.initGUI();
        }

        private void initGUI() {
            this.setLayout(new BorderLayout());
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Please select variables:"));
            box.add(Box.createGlue());
            Box northComp = Box.createVerticalBox();
            northComp.add(box);
            northComp.add(Box.createVerticalStrut(10));
            Box varManupBox = Box.createHorizontalBox();
            varManupBox.add(new VariableManipulationPanel(this.createSortButton(), this.createTextButton()));
            varManupBox.add(Box.createGlue());
            Box graphTypeBox = Box.createHorizontalBox();
            GraphSelectionEditor.this.graphTypeSelection();
            graphTypeBox.add(new GraphTypePanel(this.atMost, this.equals, this.nField, this.nLabel, GraphSelectionEditor.this.graphTypeCombo));
            graphTypeBox.add(Box.createGlue());
            Box southComp = Box.createVerticalBox();
            southComp.add(Box.createVerticalStrut(20));
            southComp.add(varManupBox);
            southComp.add(Box.createVerticalStrut(20));
            southComp.add(graphTypeBox);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)northComp, "North");
            mainPanel.add((Component)this.dualListPanel, "Center");
            mainPanel.add((Component)southComp, "South");
            this.add((Component)mainPanel, "Center");
        }

        private JButton createSortButton() {
            JButton sort = new JButton("Sort Variables");
            sort.setFont(sort.getFont().deriveFont(11.0f));
            sort.setMargin(new Insets(3, 3, 3, 3));
            sort.addActionListener(e -> {
                VariableListModel selectedModel = (VariableListModel)this.getSelectedList().getModel();
                VariableListModel sourceModel = (VariableListModel)this.getSourceList().getModel();
                selectedModel.sort();
                sourceModel.sort();
            });
            return sort;
        }

        private JButton createTextButton() {
            GraphSelectionTextInputAction action = new GraphSelectionTextInputAction(this, GraphSelectionEditor.this.wrapper, this.sourceList, this.selectedList);
            JButton sort = new JButton(action);
            sort.setFont(sort.getFont().deriveFont(11.0f));
            sort.setMargin(new Insets(3, 3, 3, 3));
            return sort;
        }

        private void initList(JList<Node> list) {
            list.setModel(new VariableListModel());
            list.setFont(this.getFONT());
            list.setSelectionMode(2);
            list.setVisibleRowCount(8);
        }

        public Font getFONT() {
            return this._font;
        }

        public void setNLabel(String label) {
            if (label.equals("")) {
                this.nLabel.setEnabled(false);
                this.equals.setEnabled(false);
                this.atMost.setEnabled(false);
                this.atLeast.setEnabled(false);
                this.nField.setEnabled(false);
            } else {
                this.nLabel.setEnabled(true);
                this.equals.setEnabled(true);
                this.atMost.setEnabled(true);
                this.atLeast.setEnabled(true);
                this.nField.setEnabled(true);
                this.nLabel.setText(label);
            }
        }

        private List<Node> getSelected() {
            ListModel<Node> model = this.getSelectedList().getModel();
            ArrayList<Node> selected = new ArrayList<Node>(model.getSize());
            for (int i = 0; i < model.getSize(); ++i) {
                Node node = model.getElementAt(i);
                selected.add(node);
            }
            return selected;
        }

        public void setSelected(List<Node> selected) {
            VariableListModel selectedModel = (VariableListModel)this.selectedList.getModel();
            VariableListModel sourceModel = (VariableListModel)this.sourceList.getModel();
            List<Node> oldSelected = GraphSelectionEditor.this.wrapper.getSelectedVariables();
            selectedModel.removeAll(oldSelected);
            sourceModel.addAll(oldSelected);
            selectedModel.addAll(selected);
            sourceModel.removeAll(selected);
            GraphSelectionEditor.this.wrapper.setSelectedVariables(selected);
            this.selectedList.setSelectedIndices(new int[0]);
            this.sourceList.setSelectedIndices(new int[0]);
        }

        private List<Node> getSelected(JList<Node> list) {
            List<Node> selected = list.getSelectedValuesList();
            ArrayList<Node> selectedList = new ArrayList<Node>(selected == null ? 0 : selected.size());
            if (selected != null) {
                selectedList.addAll(selected);
            }
            return selectedList;
        }

        public void reset() {
            VariableListModel selectedModel = (VariableListModel)this.getSelectedList().getModel();
            VariableListModel variableModel = (VariableListModel)this.getSourceList().getModel();
            List<Node> variableNames = GraphSelectionEditor.this.wrapper.getVariables();
            selectedModel.removeAll();
            variableModel.removeAll();
            variableModel.addAll(variableNames);
            variableModel.removeAll(GraphSelectionEditor.this.wrapper.getSelectedVariables());
            selectedModel.addAll(GraphSelectionEditor.this.wrapper.getSelectedVariables());
            this.getSelectedList().setSelectedIndices(new int[0]);
            this.getSourceList().setSelectedIndices(new int[0]);
        }

        private JList<Node> getSourceList() {
            return this.sourceList;
        }

        private JList<Node> getSelectedList() {
            return this.selectedList;
        }

        private DataFlavor getListDataFlavor() {
            try {
                return new DataFlavor("application/x-java-jvm-local-objectref; class=java.lang.Object", "Local Variable List");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                return null;
            }
        }

        public class VariableListModel
        extends AbstractListModel {
            private static final long serialVersionUID = 8014422476634156667L;
            private final List<Node> delegate = new ArrayList<Node>();

            @Override
            public int getSize() {
                return this.delegate.size();
            }

            @Override
            public Object getElementAt(int index) {
                return this.delegate.get(index);
            }

            public void remove(Node element) {
                int index = this.delegate.indexOf(element);
                if (0 <= index) {
                    this.delegate.remove(index);
                    this.fireIntervalRemoved(this, index, index);
                }
            }

            public void add(Node element) {
                this.delegate.add(element);
                this.fireIntervalAdded(this, this.delegate.size(), this.delegate.size());
            }

            public void removeFirst(Node element) {
                this.delegate.remove(element);
                this.fireContentsChanged(this, 0, this.delegate.size());
            }

            public void removeAll(List<? extends Node> elements) {
                this.delegate.removeAll(elements);
                this.fireContentsChanged(this, 0, this.delegate.size());
            }

            public void addAll(List<? extends Node> elements) {
                this.delegate.addAll(elements);
                this.fireContentsChanged(this, 0, this.delegate.size());
            }

            public void removeAll() {
                this.delegate.clear();
                this.fireContentsChanged(this, 0, 0);
            }

            public void sort() {
                Collections.sort(this.delegate);
                this.fireContentsChanged(this, 0, this.delegate.size());
            }
        }

        private class TargetListener
        extends DropTargetAdapter {
            private TargetListener() {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                Transferable t = dtde.getTransferable();
                Component comp = dtde.getDropTargetContext().getComponent();
                if (comp instanceof JList || comp instanceof JTextField) {
                    try {
                        for (GraphWorkbench workbench : GraphSelectionEditor.this.workbenches) {
                            workbench.deselectAll();
                        }
                        JList list = (JList)comp;
                        VariableListModel model = (VariableListModel)list.getModel();
                        ListTransferable listTransferable = new ListTransferable(new ArrayList<Node>());
                        List transferData = (List)t.getTransferData(listTransferable.getDataFlavor());
                        ArrayList<Node> elements = new ArrayList<Node>();
                        for (int i = 0; i < model.getSize(); ++i) {
                            elements.add((Node)model.getElementAt(i));
                        }
                        elements.retainAll(transferData);
                        if (!elements.isEmpty()) {
                            dtde.getDropTargetContext().dropComplete(false);
                            return;
                        }
                        for (Node c : transferData) {
                            model.removeFirst(c);
                        }
                        model.addAll(transferData);
                        GraphSelectionEditor.this.wrapper.setSelectedVariables(GraphEditorOptionsPanel.this.getSelected());
                        dtde.getDropTargetContext().dropComplete(true);
                    }
                    catch (Exception exception) {
                        dtde.rejectDrop();
                        exception.printStackTrace(System.err);
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
        }

        private class SourceListener
        extends DragSourceAdapter
        implements DragGestureListener {
            private SourceListener() {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent evt) {
                if (evt.getDropSuccess()) {
                    Component comp = evt.getDragSourceContext().getComponent();
                    Transferable t = evt.getDragSourceContext().getTransferable();
                    if (t instanceof ListTransferable) {
                        try {
                            List o = (List)t.getTransferData(new ListTransferable(new ArrayList<Node>()).getDataFlavor());
                            if (comp instanceof JList) {
                                JList list = (JList)comp;
                                VariableListModel model = (VariableListModel)list.getModel();
                                for (Node c : o) {
                                    model.removeFirst(c);
                                }
                            } else {
                                JTextField pane = (JTextField)comp;
                                pane.setText(null);
                            }
                            GraphSelectionEditor.this.wrapper.setSelectedVariables(GraphEditorOptionsPanel.this.getSelected());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                }
            }

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                Component comp = dge.getComponent();
                List selected = null;
                if (comp instanceof JList) {
                    JList list = (JList)comp;
                    selected = list.getSelectedValuesList();
                }
                if (selected != null) {
                    ArrayList<Node> nodes = new ArrayList<Node>(selected);
                    ListTransferable t = new ListTransferable(nodes);
                    dge.startDrag(DragSource.DefaultMoveDrop, t, this);
                }
            }
        }

        private class VariableManipulationPanel
        extends JPanel {
            private static final long serialVersionUID = 4538277448583296121L;
            private final JButton sortBnt;
            private final JButton textInputBnt;

            public VariableManipulationPanel(JButton sortBnt, JButton textInputBnt) {
                this.sortBnt = sortBnt;
                this.textInputBnt = textInputBnt;
                this.initComponents();
            }

            private void initComponents() {
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sortBnt).addGap(30, 30, 30).addComponent(this.textInputBnt)));
                layout.linkSize(0, this.sortBnt, this.textInputBnt);
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sortBnt).addComponent(this.textInputBnt)));
            }
        }

        private class GraphTypePanel
        extends JPanel {
            private static final long serialVersionUID = -1341212423361787517L;
            private final JRadioButton atMost;
            private final JRadioButton equals;
            private final IntTextField nField;
            private final JLabel nLabel;
            private final ButtonGroup pathLengthBtnGrp;
            private final JLabel selectGraphTypeLbl;
            private final JComboBox<GraphSelectionWrapper.Type> graphTypeCombo;

            public GraphTypePanel(JRadioButton atMost, JRadioButton equals, IntTextField nField, JLabel nLabel, JComboBox<GraphSelectionWrapper.Type> graphTypeCombo) {
                this.atMost = atMost;
                this.equals = equals;
                this.nField = nField;
                this.nLabel = nLabel;
                this.pathLengthBtnGrp = new ButtonGroup();
                this.selectGraphTypeLbl = new JLabel("Please select a graph type:");
                this.graphTypeCombo = graphTypeCombo;
                this.initComponents();
            }

            private void initComponents() {
                this.pathLengthBtnGrp.add(this.equals);
                this.pathLengthBtnGrp.add(this.atMost);
                this.pathLengthBtnGrp.add(GraphEditorOptionsPanel.this.atLeast);
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectGraphTypeLbl).addComponent(this.graphTypeCombo, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.nLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.equals).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.atMost).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(GraphEditorOptionsPanel.this.atLeast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nField, -2, -1, -2)));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.selectGraphTypeLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphTypeCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nLabel).addComponent(this.equals).addComponent(this.atMost).addComponent(GraphEditorOptionsPanel.this.atLeast).addComponent(this.nField, -2, -1, -2))));
            }
        }

        private class ListTransferable
        implements Transferable {
            private final DataFlavor FLAVOR;
            private final List<Node> nodes;

            public ListTransferable(List<Node> nodes) {
                this.FLAVOR = GraphEditorOptionsPanel.this.getListDataFlavor();
                if (nodes == null) {
                    throw new NullPointerException();
                }
                this.nodes = nodes;
            }

            public DataFlavor getDataFlavor() {
                return this.FLAVOR;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.FLAVOR};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor == this.FLAVOR;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.nodes;
            }
        }
    }

    public static class GraphSelectionTextInputAction
    extends AbstractAction
    implements ClipboardOwner {
        private static final long serialVersionUID = 8126264917739434042L;
        private final GraphSelectionWrapper wrapper;
        private final JList<Node> sourceList;
        private final JList<Node> selectedList;
        private final JComponent component;
        private JTextArea textArea;

        public GraphSelectionTextInputAction(JComponent component, GraphSelectionWrapper wrapper, JList<Node> sourceList, JList<Node> selectedList) {
            super("Text Input...");
            this.component = component;
            this.wrapper = wrapper;
            this.sourceList = sourceList;
            this.selectedList = selectedList;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Box b = Box.createVerticalBox();
            this.textArea = new JTextArea();
            this.textArea.setText(this.wrapper.getDialogText());
            JScrollPane scroll = new JScrollPane(this.textArea);
            scroll.setPreferredSize(new Dimension(150, 300));
            scroll.setBorder(new CompoundBorder(new LineBorder(Color.GRAY, 1), new EmptyBorder(5, 5, 5, 5)));
            Box b2 = Box.createVerticalBox();
            b2.add(Box.createVerticalStrut(10));
            b2.add(new JLabel("Please enter a list of variable names you'd like to have"));
            b2.add(new JLabel("selected, one per line. Those that exist in the graph will"));
            b2.add(new JLabel("be selected; the rest will be disgarded. You can paste a"));
            b2.add(new JLabel("list in from the clipboard or type it. This list will be"));
            b2.add(new JLabel("saved."));
            b2.add(Box.createVerticalStrut(10));
            b2.add(scroll);
            this.textArea.setCaretPosition(0);
            b.add(b2);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(b);
            EditorWindow window = new EditorWindow(panel, "Input Variable Names as Text", "Select", false, this.component);
            DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
            window.setVisible(true);
            window.addActionListener(e -> {
                this.wrapper.setDialogText(this.textArea.getText());
                GraphEditorOptionsPanel.VariableListModel selectedModel = (GraphEditorOptionsPanel.VariableListModel)this.selectedList.getModel();
                GraphEditorOptionsPanel.VariableListModel sourceModel = (GraphEditorOptionsPanel.VariableListModel)this.sourceList.getModel();
                List<Node> oldSelected = this.wrapper.getSelectedVariables();
                selectedModel.removeAll(oldSelected);
                sourceModel.addAll(oldSelected);
                List<Node> newSelected = this.selectedVars();
                selectedModel.addAll(newSelected);
                sourceModel.removeAll(newSelected);
                this.wrapper.setSelectedVariables(newSelected);
                this.selectedList.setSelectedIndices(new int[0]);
                this.sourceList.setSelectedIndices(new int[0]);
            });
        }

        public List<Node> selectedVars() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            try {
                String line;
                String text = this.textArea.getText();
                BufferedReader r = new BufferedReader(new CharArrayReader(text.toCharArray()));
                while ((line = r.readLine()) != null) {
                    Node node = this.wrapper.getOriginalGraph().getNode(line);
                    if (node == null) continue;
                    nodes.add(node);
                }
                return nodes;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

