/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

public class GraphToolbar
extends JPanel
implements PropertyChangeListener {
    private final ButtonGroup group;
    private final Box buttonsPanel = Box.createVerticalBox();
    private final JToggleButton move;
    private final JToggleButton addObserved;
    private final JToggleButton addLatent;
    private final JToggleButton addDirectedEdge;
    private final JToggleButton addNondirectedEdge;
    private final JToggleButton addUndirectedEdge;
    private final JToggleButton addPartiallyOrientedEdge;
    private final JToggleButton addBidirectedEdge;
    private final GraphWorkbench workbench;

    public GraphToolbar(GraphWorkbench workbench) {
        if (workbench == null) {
            throw new NullPointerException();
        }
        this.workbench = workbench;
        this.group = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 0));
        this.buttonsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add(this.buttonsPanel);
        this.move = new JToggleButton();
        this.addObserved = new JToggleButton();
        this.addLatent = new JToggleButton();
        this.addNondirectedEdge = new JToggleButton();
        this.addDirectedEdge = new JToggleButton();
        this.addUndirectedEdge = new JToggleButton();
        this.addPartiallyOrientedEdge = new JToggleButton();
        this.addBidirectedEdge = new JToggleButton();
        this.move.addActionListener(e -> {
            this.move.getModel().setSelected(true);
            this.setWorkbenchMode(0);
        });
        this.addObserved.addActionListener(e -> {
            this.addObserved.getModel().setSelected(true);
            this.setWorkbenchMode(1);
            this.setNodeMode(0);
        });
        this.addLatent.addActionListener(e -> {
            this.addLatent.getModel().setSelected(true);
            this.setWorkbenchMode(1);
            this.setNodeMode(1);
        });
        this.addDirectedEdge.addActionListener(e -> {
            this.addDirectedEdge.getModel().setSelected(true);
            this.setWorkbenchMode(2);
            this.setEdgeMode(0);
        });
        this.addNondirectedEdge.addActionListener(e -> {
            this.addNondirectedEdge.getModel().setSelected(true);
            this.setWorkbenchMode(2);
            this.setEdgeMode(2);
        });
        this.addUndirectedEdge.addActionListener(e -> {
            this.addUndirectedEdge.getModel().setSelected(true);
            this.setWorkbenchMode(2);
            this.setEdgeMode(5);
        });
        this.addPartiallyOrientedEdge.addActionListener(e -> {
            this.addPartiallyOrientedEdge.getModel().setSelected(true);
            this.setWorkbenchMode(2);
            this.setEdgeMode(3);
        });
        this.addBidirectedEdge.addActionListener(e -> {
            this.addBidirectedEdge.getModel().setSelected(true);
            this.setWorkbenchMode(2);
            this.setEdgeMode(4);
        });
        this.addButton(this.move, "move");
        this.addButton(this.addObserved, "variable");
        this.addButton(this.addLatent, "latent");
        this.addButton(this.addDirectedEdge, "directed");
        this.addButton(this.addNondirectedEdge, "nondirected");
        this.addButton(this.addUndirectedEdge, "undirected");
        this.addButton(this.addPartiallyOrientedEdge, "partiallyoriented");
        this.addButton(this.addBidirectedEdge, "bidirected");
        workbench.addPropertyChangeListener(this);
        this.selectArrowTools();
        this.buttonsPanel.add(Box.createGlue());
        this.move.setSelected(true);
    }

    private void setWorkbenchMode(int mode) {
        this.workbench.setWorkbenchMode(mode);
        this.setCursor(this.workbench.getCursor());
    }

    private void setEdgeMode(int mode) {
        this.workbench.setEdgeMode(mode);
    }

    private void setNodeMode(int mode) {
        this.workbench.setNodeType(mode);
    }

    private void addButton(JToggleButton button, String name) {
        button.setIcon(new ImageIcon(ImageUtils.getImage(this, name + "3.gif")));
        button.setMaximumSize(new Dimension(80, 40));
        button.setPreferredSize(new Dimension(80, 40));
        this.buttonsPanel.add(button);
        this.buttonsPanel.add(Box.createVerticalStrut(5));
        this.group.add(button);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("graph".equals(e.getPropertyName())) {
            this.selectArrowTools();
        }
    }

    private void selectArrowTools() {
        this.addDirectedEdge.setEnabled(true);
        this.addNondirectedEdge.setEnabled(true);
        this.addPartiallyOrientedEdge.setEnabled(true);
        this.addBidirectedEdge.setEnabled(true);
        this.addUndirectedEdge.setEnabled(true);
    }
}

