/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.AbstractVariable;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Histogram;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntSpinner;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import org.apache.commons.math3.util.FastMath;

public class HistogramView
extends JPanel {
    private final HistogramPanel histogramPanel;
    private static final String[] tiles = new String[]{"1-tile", "2-tile", "tertile", "quartile", "quintile", "sextile", "septile", "octile", "nontile", "decile"};

    public HistogramView(Histogram histogram) {
        this.histogramPanel = new HistogramPanel(histogram);
        HistogramController controller = new HistogramController(this.histogramPanel);
        controller.addPropertyChangeListener(evt -> this.histogramPanel.updateView());
        Box box = Box.createHorizontalBox();
        box.add(this.histogramPanel);
        box.add(Box.createHorizontalStrut(3));
        box.add(controller);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        this.setLayout(new BorderLayout());
        this.add((Component)vBox, "Center");
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem(new SaveComponentImage(this.histogramPanel, "Save Histogram")));
        bar.add(menu);
        this.add((Component)bar, "North");
    }

    public static class HistogramPanel
    extends JPanel {
        private static final Color LINE_COLOR = Color.GRAY.darker();
        private static final Color[] BAR_COLORS = new Color[]{new Color(153, 102, 102), new Color(102, 102, 153), new Color(102, 153, 102), new Color(153, 102, 153), new Color(153, 153, 102), new Color(102, 153, 153), new Color(204, 153, 153), new Color(153, 153, 204), new Color(153, 204, 153), new Color(204, 153, 204), new Color(204, 204, 153), new Color(153, 204, 204), new Color(255, 204, 204), new Color(204, 204, 255), new Color(204, 255, 204)};
        private static final int PADDINGX = 40;
        private static final int PADDINGY = 15;
        private static final int HEIGHT = 265;
        private static final int DISPLAYED_HEIGHT = 223;
        private static final int WIDTH = 330;
        private static final int SPACE = 2;
        private static final int DASH = 10;
        private final Histogram histogram;
        private final Dimension size = new Dimension(334, 265);
        private final NumberFormat format = new DecimalFormat("0.#");
        private final Map<Rectangle, Integer> rectMap = new LinkedHashMap<Rectangle, Integer>();

        public HistogramPanel(Histogram histogram) {
            if (histogram == null) {
                throw new NullPointerException("Given histogram must be null");
            }
            this.histogram = histogram;
            this.setToolTipText(" ");
        }

        public synchronized void updateView() {
            if (this.getHistogram() == null) {
                throw new NullPointerException("The given histogram must not be null");
            }
            this.repaint();
        }

        @Override
        public String getToolTipText(MouseEvent evt) {
            Point point = evt.getPoint();
            for (Rectangle rect : this.rectMap.keySet()) {
                if (!rect.contains(point)) continue;
                Integer i = this.rectMap.get(rect);
                if (i == null) break;
                return i.toString();
            }
            return null;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            this.rectMap.clear();
            Graphics2D g2d = (Graphics2D)graphics;
            Histogram histogram = this.getHistogram();
            int[] freqs = histogram.getFrequencies();
            int categories = freqs.length;
            int barWidth = FastMath.max(290 / categories, 2) - 2;
            int height = 250;
            int topFreq = HistogramPanel.getMax(freqs);
            double scale = 223.0 / (double)topFreq;
            FontMetrics fontMetrics = g2d.getFontMetrics();
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, 334, 265);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(40, 0, 292, 250);
            for (int i = 0; i < categories; ++i) {
                int freq = freqs[i];
                int y = (int)FastMath.ceil(scale * (double)freq);
                int x = 2 * (i + 1) + barWidth * i + 40;
                g2d.setColor(HistogramPanel.getBarColor(i));
                Rectangle rect = new Rectangle(x, 250 - y, barWidth, y);
                g2d.fill(rect);
                this.rectMap.put(rect, freq);
            }
            g2d.setColor(LINE_COLOR);
            g2d.drawRect(40, 0, 292, 250);
            g2d.setColor(LINE_COLOR);
            Node target = histogram.getTargetNode();
            if (target instanceof ContinuousVariable) {
                Map<Integer, Double> pointsAndValues = this.pickGoodPointsAndValues(histogram.getMin(), histogram.getMax());
                for (int point : pointsAndValues.keySet()) {
                    double value = pointsAndValues.get(point);
                    if (point < 322) {
                        g2d.drawString(this.format.format(value), point + 2, 265);
                    }
                    g2d.drawLine(point, 260, point, 250);
                }
            } else if (target instanceof DiscreteVariable) {
                DiscreteVariable var = (DiscreteVariable)target;
                List<String> _categories = var.getCategories();
                int i = -1;
                for (Rectangle rect : this.rectMap.keySet()) {
                    int x = (int)rect.getX();
                    g2d.drawString(_categories.get(++i), x, 265);
                }
            }
            g2d.setColor(LINE_COLOR);
            int topY = 250 - (int)FastMath.ceil(scale * (double)topFreq);
            String top = String.valueOf(topFreq);
            g2d.drawString(top, 40 - fontMetrics.stringWidth(top), topY - 2);
            g2d.drawLine(30, topY, 40, topY);
            g2d.drawString("0", 40 - fontMetrics.stringWidth("0"), 248);
            g2d.drawLine(30, 250, 40, 250);
            int hSize = (250 - topY) / 4;
            for (int i = 1; i < 4; ++i) {
                int topHeight = 250 - hSize * i;
                g2d.drawLine(30, topHeight, 40, topHeight);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.size;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.size;
        }

        private Map<Integer, Double> pickGoodPointsAndValues(double minValue, double maxValue) {
            double range = maxValue - minValue;
            int powerOfTen = (int)FastMath.floor(FastMath.log(range) / FastMath.log(10.0));
            HashMap<Integer, Double> points = new HashMap<Integer, Double>();
            int low = (int)FastMath.floor(minValue / FastMath.pow(10.0, powerOfTen));
            int high = (int)FastMath.ceil(maxValue / FastMath.pow(10.0, powerOfTen));
            for (int i = low; i < high; ++i) {
                double realValue = (double)i * FastMath.pow(10.0, powerOfTen);
                Integer intValue = this.translateToInt(minValue, maxValue, realValue);
                if (intValue == null) continue;
                points.put(intValue, realValue);
            }
            return points;
        }

        private Integer translateToInt(double minValue, double maxValue, double value) {
            if (minValue >= maxValue) {
                throw new IllegalArgumentException();
            }
            double ratio = (value - minValue) / (maxValue - minValue);
            int intValue = (int)FastMath.round(40.0 + ratio * 292.0);
            if (intValue < 40 || intValue > 332) {
                return null;
            }
            return intValue;
        }

        private static Color getBarColor(int i) {
            return BAR_COLORS[i % BAR_COLORS.length];
        }

        private static int getMax(int[] freqs) {
            int max = freqs[0];
            for (int i = 1; i < freqs.length; ++i) {
                int current = freqs[i];
                if (current <= max) continue;
                max = current;
            }
            return max;
        }

        public Histogram getHistogram() {
            return this.histogram;
        }
    }

    public static class HistogramController
    extends JPanel {
        private final Histogram histogram;
        private final JComboBox targetSelector;
        private IntSpinner numBarsSelector;
        private final JComboBox newConditioningVariableSelector;
        private final JButton newConditioningVariableButton;
        private final JButton removeConditioningVariableButton;
        private final List<ConditioningPanel> conditioningPanels = new ArrayList<ConditioningPanel>();
        private final Map<Node, ConditioningPanel> conditioningPanelMap = new HashMap<Node, ConditioningPanel>();

        public HistogramController(HistogramPanel histogramPanel) {
            this.setLayout(new BorderLayout());
            this.histogram = histogramPanel.getHistogram();
            Node target = this.histogram.getTargetNode();
            this.targetSelector = new JComboBox();
            VariableBoxRenderer renderer = new VariableBoxRenderer();
            this.targetSelector.setRenderer(renderer);
            List<Node> variables = this.histogram.getDataSet().getVariables();
            Collections.sort(variables);
            for (Node node : variables) {
                this.targetSelector.addItem(node);
                if (node != target) continue;
                this.targetSelector.setSelectedItem(node);
            }
            this.targetSelector.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    Node node = (Node)e.getItem();
                    this.getHistogram().setTarget(node.getName());
                    int maxBins = HistogramController.getMaxCategoryValue(this.getHistogram());
                    int numBins = this.getHistogram().getNumBins();
                    this.numBarsSelector = new IntSpinner(numBins, 1, 3);
                    this.numBarsSelector.setMin(2);
                    this.numBarsSelector.setMax(maxBins);
                    this.numBarsSelector.addChangeListener(e1 -> {
                        JSpinner s = (JSpinner)e1.getSource();
                        if (this.getHistogram().getTargetNode() instanceof ContinuousVariable) {
                            int value = (Integer)s.getValue();
                            this.getHistogram().setNumBins(value);
                            this.changeHistogram();
                        }
                    });
                    for (ConditioningPanel panel : new ArrayList<ConditioningPanel>(this.conditioningPanels)) {
                        this.conditioningPanels.remove(panel);
                    }
                    this.buildEditArea();
                    this.resetConditioning();
                    this.changeHistogram();
                }
            });
            this.numBarsSelector = new IntSpinner(this.histogram.getNumBins(), 1, 3);
            this.numBarsSelector.setMin(2);
            this.numBarsSelector.setMax(HistogramController.getMaxCategoryValue(this.histogram));
            this.numBarsSelector.addChangeListener(e -> {
                JSpinner s = (JSpinner)e.getSource();
                if (this.getHistogram().getTargetNode() instanceof ContinuousVariable) {
                    int value = (Integer)s.getValue();
                    this.getHistogram().setNumBins(value);
                    this.changeHistogram();
                }
            });
            this.newConditioningVariableSelector = new JComboBox();
            for (Node node : variables) {
                this.newConditioningVariableSelector.addItem(node);
            }
            this.newConditioningVariableSelector.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    System.out.println("New conditioning varible " + e.getItem());
                }
            });
            this.newConditioningVariableButton = new JButton("Add");
            this.newConditioningVariableButton.addActionListener(e -> {
                ConditioningPanel panel1;
                AbstractVariable _var;
                Node selected = (Node)this.newConditioningVariableSelector.getSelectedItem();
                if (selected == this.targetSelector.getSelectedItem()) {
                    JOptionPane.showMessageDialog(this, "The target variable cannot be conditioned on.");
                    return;
                }
                for (ConditioningPanel panel : this.conditioningPanels) {
                    if (selected != panel.getVariable()) continue;
                    JOptionPane.showMessageDialog(this, "There is already a conditioning variable called " + selected + ".");
                    return;
                }
                if (selected instanceof ContinuousVariable) {
                    _var = (ContinuousVariable)selected;
                    panel1 = (ContinuousConditioningPanel)this.conditioningPanelMap.get(_var);
                    if (panel1 == null) {
                        panel1 = ContinuousConditioningPanel.getDefault((ContinuousVariable)_var, this.histogram);
                    }
                    ContinuousInquiryPanel panel2 = new ContinuousInquiryPanel((ContinuousVariable)_var, this.histogram, (ContinuousConditioningPanel)panel1);
                    JOptionPane.showOptionDialog(this, panel2, null, -1, -1, null, null, null);
                    ContinuousConditioningPanel.Type type = panel2.getType();
                    double low = panel2.getLow();
                    double high = panel2.getHigh();
                    int ntile = panel2.getNtile();
                    int ntileIndex = panel2.getNtileIndex();
                    ContinuousConditioningPanel panel3 = new ContinuousConditioningPanel((ContinuousVariable)_var, low, high, ntile, ntileIndex, type);
                    this.conditioningPanels.add(panel3);
                    this.conditioningPanelMap.put(_var, panel3);
                } else if (selected instanceof DiscreteVariable) {
                    _var = (DiscreteVariable)selected;
                    panel1 = (DiscreteConditioningPanel)this.conditioningPanelMap.get(_var);
                    if (panel1 == null) {
                        panel1 = DiscreteConditioningPanel.getDefault((DiscreteVariable)_var);
                        this.conditioningPanelMap.put(_var, panel1);
                    }
                    DiscreteInquiryPanel panel2 = new DiscreteInquiryPanel((DiscreteVariable)_var, (DiscreteConditioningPanel)panel1);
                    JOptionPane.showOptionDialog(this, panel2, null, -1, -1, null, null, null);
                    String category = (String)panel2.getValuesDropdown().getSelectedItem();
                    int index = ((DiscreteVariable)_var).getIndex(category);
                    DiscreteConditioningPanel panel3 = new DiscreteConditioningPanel((DiscreteVariable)_var, index);
                    this.conditioningPanels.add(panel3);
                    this.conditioningPanelMap.put(_var, panel3);
                } else {
                    throw new IllegalStateException();
                }
                this.buildEditArea();
                this.resetConditioning();
                this.changeHistogram();
            });
            this.removeConditioningVariableButton = new JButton("Remove Checked");
            this.removeConditioningVariableButton.addActionListener(e -> {
                for (ConditioningPanel panel : new ArrayList<ConditioningPanel>(this.conditioningPanels)) {
                    if (!panel.isSelected()) continue;
                    panel.setSelected(false);
                    this.conditioningPanels.remove(panel);
                }
                this.buildEditArea();
                this.resetConditioning();
                this.changeHistogram();
            });
            HistogramController.restrictSize(this.targetSelector);
            HistogramController.restrictSize(this.numBarsSelector);
            HistogramController.restrictSize(this.newConditioningVariableSelector);
            HistogramController.restrictSize(this.newConditioningVariableButton);
            HistogramController.restrictSize(this.removeConditioningVariableButton);
            this.buildEditArea();
        }

        private void resetConditioning() {
            this.histogram.removeConditioningVariables();
            for (ConditioningPanel panel : this.conditioningPanels) {
                Node node;
                if (panel instanceof ContinuousConditioningPanel) {
                    node = panel.getVariable();
                    double low = ((ContinuousConditioningPanel)panel).getLow();
                    double high = ((ContinuousConditioningPanel)panel).getHigh();
                    this.histogram.addConditioningVariable(node.getName(), low, high);
                    continue;
                }
                if (!(panel instanceof DiscreteConditioningPanel)) continue;
                node = panel.getVariable();
                int index = ((DiscreteConditioningPanel)panel).getIndex();
                this.histogram.addConditioningVariable(node.getName(), index);
            }
        }

        private void buildEditArea() {
            Box main = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Histogram for: "));
            b1.add(this.targetSelector);
            b1.add(new JLabel("# Bars: "));
            b1.add(this.numBarsSelector);
            b1.add(Box.createHorizontalGlue());
            main.add(b1);
            main.add(Box.createVerticalStrut(20));
            Box b3 = Box.createHorizontalBox();
            JLabel l1 = new JLabel("Conditioning on: ");
            l1.setFont(l1.getFont().deriveFont(2));
            b3.add(l1);
            b3.add(Box.createHorizontalGlue());
            main.add(b3);
            main.add(Box.createVerticalStrut(20));
            for (ConditioningPanel conditioningPanel : this.conditioningPanels) {
                main.add(conditioningPanel.getBox());
                main.add(Box.createVerticalStrut(10));
            }
            main.add(Box.createVerticalStrut(10));
            main.add(Box.createVerticalGlue());
            for (int i = this.newConditioningVariableSelector.getItemCount() - 1; i >= 0; --i) {
                this.newConditioningVariableSelector.removeItemAt(i);
            }
            List<Node> variables = this.histogram.getDataSet().getVariables();
            Collections.sort(variables);
            block2: for (Node node : variables) {
                if (node == this.targetSelector.getSelectedItem()) continue;
                for (ConditioningPanel panel : this.conditioningPanels) {
                    if (node != panel.getVariable()) continue;
                    continue block2;
                }
                this.newConditioningVariableSelector.addItem(node);
            }
            Box box = Box.createHorizontalBox();
            box.add(this.newConditioningVariableSelector);
            box.add(this.newConditioningVariableButton);
            box.add(Box.createHorizontalGlue());
            main.add(box);
            Box b7 = Box.createHorizontalBox();
            b7.add(this.removeConditioningVariableButton);
            b7.add(Box.createHorizontalGlue());
            main.add(b7);
            this.removeAll();
            this.add((Component)main, "Center");
            this.revalidate();
            this.repaint();
        }

        private static int getMaxCategoryValue(Histogram histogram) {
            Node node = histogram.getTargetNode();
            if (node instanceof DiscreteVariable) {
                DiscreteVariable var = (DiscreteVariable)node;
                return var.getNumCategories();
            }
            return 40;
        }

        private Histogram getHistogram() {
            return this.histogram;
        }

        private void changeHistogram() {
            this.firePropertyChange("histogramChanged", null, this.histogram);
        }

        private static void restrictSize(JComponent component) {
            component.setMaximumSize(component.getPreferredSize());
        }

        private static class VariableBoxRenderer
        extends DefaultListCellRenderer {
            private VariableBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Node node = (Node)value;
                if (node == null) {
                    this.setText("");
                } else {
                    this.setText(node.getName());
                }
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                return this;
            }
        }

        private static interface ConditioningPanel {
            public Box getBox();

            public boolean isSelected();

            public Node getVariable();

            public void setSelected(boolean var1);
        }

        public static class ContinuousConditioningPanel
        implements ConditioningPanel {
            private final ContinuousVariable variable;
            private final Box box;
            private final Type type;
            private final double low;
            private final double high;
            private final int ntile;
            private final int ntileIndex;
            private final JCheckBox checkBox;

            public int getNtile() {
                return this.ntile;
            }

            public int getNtileIndex() {
                return this.ntileIndex;
            }

            public ContinuousConditioningPanel(ContinuousVariable variable, double low, double high, int ntile, int ntileIndex, Type type) {
                if (variable == null) {
                    throw new NullPointerException();
                }
                if (low >= high) {
                    throw new IllegalArgumentException("Low >= high.");
                }
                if (ntile < 2 || ntile > 10) {
                    throw new IllegalArgumentException("Ntile should be in range 2 to 10: " + ntile);
                }
                this.variable = variable;
                DecimalFormat nf = new DecimalFormat("0.0000");
                this.type = type;
                this.low = low;
                this.high = high;
                this.ntile = ntile;
                this.ntileIndex = ntileIndex;
                Box b4 = Box.createHorizontalBox();
                b4.add(Box.createRigidArea(new Dimension(10, 0)));
                if (type == Type.Range) {
                    b4.add(new JLabel(variable + " = (" + nf.format(low) + ", " + nf.format(high) + ")"));
                } else if (type == Type.AboveAverage) {
                    b4.add(new JLabel(variable + " = Above Average"));
                } else if (type == Type.BelowAverage) {
                    b4.add(new JLabel(variable + " = Below Average"));
                } else if (type == Type.Ntile) {
                    b4.add(new JLabel(variable + " = " + tiles[ntile - 1] + " " + ntileIndex));
                }
                b4.add(Box.createHorizontalGlue());
                this.checkBox = new JCheckBox();
                HistogramController.restrictSize(this.checkBox);
                b4.add(this.checkBox);
                this.box = b4;
            }

            public static ContinuousConditioningPanel getDefault(ContinuousVariable variable, Histogram histogram) {
                double[] data = histogram.getContinuousData(variable.getName());
                double max = StatUtils.max(data);
                double avg = StatUtils.mean(data);
                return new ContinuousConditioningPanel(variable, avg, max, 2, 1, Type.AboveAverage);
            }

            @Override
            public ContinuousVariable getVariable() {
                return this.variable;
            }

            public Type getType() {
                return this.type;
            }

            @Override
            public Box getBox() {
                return this.box;
            }

            @Override
            public boolean isSelected() {
                return this.checkBox.isSelected();
            }

            @Override
            public void setSelected(boolean b) {
                this.checkBox.setSelected(false);
            }

            public double getLow() {
                return this.low;
            }

            public double getHigh() {
                return this.high;
            }

            public static enum Type {
                Range,
                Ntile,
                AboveAverage,
                BelowAverage;

            }
        }

        public static class DiscreteConditioningPanel
        implements ConditioningPanel {
            private final DiscreteVariable variable;
            private final String value;
            private final Box box;
            private final JCheckBox checkBox;
            private final int index;

            public DiscreteConditioningPanel(DiscreteVariable variable, int valueIndex) {
                if (variable == null) {
                    throw new NullPointerException();
                }
                if (valueIndex < 0 || valueIndex >= variable.getNumCategories()) {
                    throw new IllegalArgumentException("Not a category for this varible.");
                }
                this.variable = variable;
                this.value = variable.getCategory(valueIndex);
                this.index = valueIndex;
                Box b4 = Box.createHorizontalBox();
                b4.add(Box.createRigidArea(new Dimension(10, 0)));
                b4.add(new JLabel(variable + " = " + variable.getCategory(valueIndex)));
                b4.add(Box.createHorizontalGlue());
                this.checkBox = new JCheckBox();
                HistogramController.restrictSize(this.checkBox);
                b4.add(this.checkBox);
                this.box = b4;
            }

            public static DiscreteConditioningPanel getDefault(DiscreteVariable var) {
                return new DiscreteConditioningPanel(var, 0);
            }

            @Override
            public DiscreteVariable getVariable() {
                return this.variable;
            }

            public String getValue() {
                return this.value;
            }

            public int getIndex() {
                return this.index;
            }

            @Override
            public Box getBox() {
                return this.box;
            }

            @Override
            public boolean isSelected() {
                return this.checkBox.isSelected();
            }

            @Override
            public void setSelected(boolean b) {
                this.checkBox.setSelected(false);
            }
        }
    }

    private static class DiscreteInquiryPanel
    extends JPanel {
        private final JComboBox valuesDropdown = new JComboBox();

        public DiscreteInquiryPanel(DiscreteVariable var, HistogramController.DiscreteConditioningPanel panel) {
            for (String category : var.getCategories()) {
                this.getValuesDropdown().addItem(category);
            }
            this.valuesDropdown.setSelectedItem(panel.getValue());
            Box main = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Condition on:"));
            b1.add(Box.createHorizontalGlue());
            main.add(b1);
            main.add(Box.createVerticalStrut(10));
            Box b2 = Box.createHorizontalBox();
            b2.add(Box.createHorizontalStrut(10));
            b2.add(new JLabel(var.getName() + " = "));
            b2.add(this.getValuesDropdown());
            main.add(b2);
            this.add((Component)main, "Center");
        }

        public JComboBox getValuesDropdown() {
            return this.valuesDropdown;
        }
    }

    private static class ContinuousInquiryPanel
    extends JPanel {
        private final JComboBox ntileCombo;
        private final JComboBox ntileIndexCombo;
        private final DoubleTextField field1;
        private final DoubleTextField field2;
        private HistogramController.ContinuousConditioningPanel.Type type;
        private final Map<String, Integer> ntileMap = new HashMap<String, Integer>();
        private final double[] data;

        public ContinuousInquiryPanel(ContinuousVariable variable, Histogram histogram, HistogramController.ContinuousConditioningPanel conditioningPanel) {
            int n;
            this.data = histogram.getContinuousData(variable.getName());
            if (conditioningPanel == null) {
                throw new NullPointerException();
            }
            if (variable != conditioningPanel.getVariable()) {
                throw new IllegalArgumentException("Wrong variable for conditioning panel.");
            }
            DecimalFormat nf = new DecimalFormat("0.00");
            this.field1 = new DoubleTextField(conditioningPanel.getLow(), 4, nf);
            this.field2 = new DoubleTextField(conditioningPanel.getHigh(), 4, nf);
            JRadioButton radio1 = new JRadioButton();
            JRadioButton radio2 = new JRadioButton();
            JRadioButton radio3 = new JRadioButton();
            JRadioButton radio4 = new JRadioButton();
            radio1.addActionListener(e -> {
                this.type = HistogramController.ContinuousConditioningPanel.Type.AboveAverage;
                this.field1.setValue(StatUtils.mean(this.data));
                this.field2.setValue(StatUtils.max(this.data));
            });
            radio2.addActionListener(e -> {
                this.type = HistogramController.ContinuousConditioningPanel.Type.BelowAverage;
                this.field1.setValue(StatUtils.min(this.data));
                this.field2.setValue(StatUtils.mean(this.data));
            });
            radio3.addActionListener(e -> {
                this.type = HistogramController.ContinuousConditioningPanel.Type.Ntile;
                double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(this.data, this.getNtile());
                double breakpoint1 = breakpoints[this.getNtileIndex() - 1];
                double breakpoint2 = breakpoints[this.getNtileIndex()];
                this.field1.setValue(breakpoint1);
                this.field2.setValue(breakpoint2);
            });
            radio4.addActionListener(e -> {
                this.type = HistogramController.ContinuousConditioningPanel.Type.Range;
            });
            ButtonGroup group = new ButtonGroup();
            group.add(radio1);
            group.add(radio2);
            group.add(radio3);
            group.add(radio4);
            this.type = conditioningPanel.getType();
            this.ntileCombo = new JComboBox();
            this.ntileIndexCombo = new JComboBox();
            int ntile = conditioningPanel.getNtile();
            int ntileIndex = conditioningPanel.getNtileIndex();
            for (n = 2; n <= 10; ++n) {
                this.ntileCombo.addItem(tiles[n - 1]);
                this.ntileMap.put(tiles[n - 1], n);
            }
            for (n = 1; n <= ntile; ++n) {
                this.ntileIndexCombo.addItem(n);
            }
            this.ntileCombo.setSelectedItem(tiles[ntile - 1]);
            this.ntileIndexCombo.setSelectedItem(ntileIndex);
            this.ntileCombo.addItemListener(e -> {
                String item = (String)e.getItem();
                int ntileIndex1 = this.ntileMap.get(item);
                for (int i = this.ntileIndexCombo.getItemCount() - 1; i >= 0; --i) {
                    this.ntileIndexCombo.removeItemAt(i);
                }
                for (int n = 1; n <= ntileIndex1; ++n) {
                    this.ntileIndexCombo.addItem(n);
                }
                double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(this.data, this.getNtile());
                double breakpoint1 = breakpoints[this.getNtileIndex() - 1];
                double breakpoint2 = breakpoints[this.getNtileIndex()];
                this.field1.setValue(breakpoint1);
                this.field2.setValue(breakpoint2);
            });
            this.ntileIndexCombo.addItemListener(e -> {
                int ntile1 = this.getNtile();
                int ntileIndex12 = this.getNtileIndex();
                double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(this.data, ntile1);
                double breakpoint1 = breakpoints[ntileIndex12 - 1];
                double breakpoint2 = breakpoints[ntileIndex12];
                this.field1.setValue(breakpoint1);
                this.field2.setValue(breakpoint2);
            });
            if (this.type == HistogramController.ContinuousConditioningPanel.Type.AboveAverage) {
                radio1.setSelected(true);
                this.field1.setValue(StatUtils.mean(this.data));
                this.field2.setValue(StatUtils.max(this.data));
            } else if (this.type == HistogramController.ContinuousConditioningPanel.Type.BelowAverage) {
                radio2.setSelected(true);
                this.field1.setValue(StatUtils.min(this.data));
                this.field2.setValue(StatUtils.mean(this.data));
            } else if (this.type == HistogramController.ContinuousConditioningPanel.Type.Ntile) {
                radio3.setSelected(true);
                double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(this.data, this.getNtile());
                double breakpoint1 = breakpoints[this.getNtileIndex() - 1];
                double breakpoint2 = breakpoints[this.getNtileIndex()];
                this.field1.setValue(breakpoint1);
                this.field2.setValue(breakpoint2);
            } else if (this.type == HistogramController.ContinuousConditioningPanel.Type.Range) {
                radio4.setSelected(true);
            }
            Box main = Box.createVerticalBox();
            Box b0 = Box.createHorizontalBox();
            b0.add(new JLabel("Condition on " + variable.getName() + " as:"));
            b0.add(Box.createHorizontalGlue());
            main.add(b0);
            main.add(Box.createVerticalStrut(10));
            Box b1 = Box.createHorizontalBox();
            b1.add(radio1);
            b1.add(new JLabel("Above average"));
            b1.add(Box.createHorizontalGlue());
            main.add(b1);
            Box b2 = Box.createHorizontalBox();
            b2.add(radio2);
            b2.add(new JLabel("Below average"));
            b2.add(Box.createHorizontalGlue());
            main.add(b2);
            Box b3 = Box.createHorizontalBox();
            b3.add(radio3);
            b3.add(new JLabel("In "));
            b3.add(this.ntileCombo);
            b3.add(this.ntileIndexCombo);
            b3.add(Box.createHorizontalGlue());
            main.add(b3);
            Box b4 = Box.createHorizontalBox();
            b4.add(radio4);
            b4.add(new JLabel("In ("));
            b4.add(this.field1);
            b4.add(new JLabel(", "));
            b4.add(this.field2);
            b4.add(new JLabel(")"));
            b4.add(Box.createHorizontalGlue());
            main.add(b4);
            this.add((Component)main, "Center");
        }

        public HistogramController.ContinuousConditioningPanel.Type getType() {
            return this.type;
        }

        public double getLow() {
            return this.field1.getValue();
        }

        public double getHigh() {
            return this.field2.getValue();
        }

        public int getNtile() {
            String selectedItem = (String)this.ntileCombo.getSelectedItem();
            return this.ntileMap.get(selectedItem);
        }

        public int getNtileIndex() {
            Object selectedItem = this.ntileIndexCombo.getSelectedItem();
            return selectedItem == null ? 1 : (Integer)selectedItem;
        }

        public static double[] getNtileBreakpoints(double[] data, int ntiles) {
            double[] _data = new double[data.length];
            System.arraycopy(data, 0, _data, 0, _data.length);
            Arrays.sort(_data);
            ArrayList<Chunk> chunks = new ArrayList<Chunk>(_data.length);
            int startChunkCount = 0;
            double lastValue = _data[0];
            for (int i = 0; i < _data.length; ++i) {
                double value = _data[i];
                if (value != lastValue) {
                    chunks.add(new Chunk(startChunkCount, i, value));
                    startChunkCount = i;
                }
                lastValue = value;
            }
            chunks.add(new Chunk(startChunkCount, _data.length, _data[_data.length - 1]));
            double interval = (double)_data.length / (double)ntiles;
            double[] breakpoints = new double[ntiles + 1];
            breakpoints[0] = StatUtils.min(_data);
            int current = 1;
            int freq = 0;
            for (Chunk chunk : chunks) {
                int valuesInChunk = chunk.getNumberOfValuesInChunk();
                int halfChunk = (int)((double)valuesInChunk * 0.5);
                freq = (double)(freq + halfChunk) <= interval ? (freq += valuesInChunk) : valuesInChunk;
                if (!(interval <= (double)freq)) continue;
                freq = 0;
                if (current >= ntiles + 1) continue;
                breakpoints[current++] = chunk.value;
            }
            for (int i = current; i < breakpoints.length; ++i) {
                breakpoints[i] = StatUtils.max(_data);
            }
            return breakpoints;
        }

        private static class Chunk {
            private final int valuesInChunk;
            private final double value;

            public Chunk(int low, int high, double value) {
                this.valuesInChunk = high - low;
                this.value = value;
            }

            public int getNumberOfValuesInChunk() {
                return this.valuesInChunk;
            }
        }
    }
}

