/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetradapp.model.IndTestModel;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.IndependenceResultIndFacts;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class IndependenceFactsEditor
extends JPanel {
    private IndTestModel model;
    private LinkedList<String> vars;
    private JTextField textField;
    private List<IndTestProducer> indTestProducers;
    private List<List<IndependenceResultIndFacts>> results = new ArrayList<List<IndependenceResultIndFacts>>();
    private AbstractTableModel tableModel;
    private int sortDir;
    private int lastSortCol;
    private final NumberFormat nf = new DecimalFormat("0.0000");
    private boolean showPs;

    public IndependenceFactsEditor(IndTestModel model) {
        this.indTestProducers = model.getIndTestProducers();
        this.model = model;
        this.vars = new LinkedList();
        this.textField = new JTextField(40);
        this.textField.setEditable(false);
        this.textField.setFont(new Font("Serif", 1, 14));
        this.textField.setBackground(new Color(250, 250, 250));
        this.vars = model.getVars();
        this.results = model.getResults();
        if (this.results == null) {
            this.results = new ArrayList<List<IndependenceResultIndFacts>>();
        }
        this.resetText();
        if (this.indTestProducers.isEmpty()) {
            throw new IllegalArgumentException("At least one source must be specified");
        }
        List<String> names = this.indTestProducers.get(0).getIndependenceTest().getVariableNames();
        for (int i = 1; i < this.indTestProducers.size(); ++i) {
            List<String> _names = this.indTestProducers.get(i).getIndependenceTest().getVariableNames();
            if (new HashSet<String>(names).equals(new HashSet<String>(_names))) continue;
            throw new IllegalArgumentException("All sources must have the same variable names.");
        }
        this.buildGui();
    }

    private void buildGui() {
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("VAR");
        varNames.addAll(this.getDataVars());
        varNames.add("?");
        varNames.add("+");
        final JComboBox<String> variableBox = new JComboBox<String>();
        DefaultComboBoxModel<String> aModel1 = new DefaultComboBoxModel<String>(varNames.toArray(new String[0]));
        aModel1.setSelectedItem("VAR");
        variableBox.setModel(aModel1);
        variableBox.addActionListener(e -> {
            JComboBox box = (JComboBox)e.getSource();
            String var = (String)box.getSelectedItem();
            LinkedList<String> vars = this.getVars();
            int size = vars.size();
            if ("VAR".equals(var)) {
                return;
            }
            if ("?".equals(var)) {
                if (!vars.contains("+")) {
                    vars.addLast(var);
                }
            } else if ("+".equals(var)) {
                if (size >= 2) {
                    vars.addLast(var);
                }
            } else if (vars.indexOf("?") < 2 && !vars.contains("+") && !vars.contains(var)) {
                vars.add(var);
            }
            this.resetText();
            DefaultComboBoxModel<String> aModel = new DefaultComboBoxModel<String>(varNames.toArray(new String[0]));
            aModel.setSelectedItem("VAR");
            variableBox.setModel(aModel);
        });
        JButton delete = new JButton("Delete");
        delete.addActionListener(e -> {
            if (!this.getVars().isEmpty()) {
                this.getVars().removeLast();
                this.resetText();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ('?' == e.getKeyChar()) {
                    variableBox.setSelectedItem("?");
                } else if ('+' == e.getKeyChar()) {
                    variableBox.setSelectedItem("+");
                } else if ('\b' == e.getKeyChar()) {
                    IndependenceFactsEditor.this.vars.removeLast();
                    IndependenceFactsEditor.this.resetText();
                }
                e.consume();
            }
        });
        delete.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ('?' == e.getKeyChar()) {
                    variableBox.setSelectedItem("?");
                } else if ('+' == e.getKeyChar()) {
                    variableBox.setSelectedItem("+");
                } else if ('\b' == e.getKeyChar()) {
                    IndependenceFactsEditor.this.vars.removeLast();
                    IndependenceFactsEditor.this.resetText();
                }
            }
        });
        variableBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                if ('\b' == e.getKeyChar()) {
                    IndependenceFactsEditor.this.vars.removeLast();
                    IndependenceFactsEditor.this.resetText();
                }
            }
        });
        JButton list = new JButton("LIST");
        list.setFont(new Font("Dialog", 1, 14));
        list.addActionListener(e -> this.generateResults());
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Compares conditional independence tests from the given sources: "));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        for (int i = 0; i < this.indTestProducers.size(); ++i) {
            Box b2a = Box.createHorizontalBox();
            b2a.add(new JLabel(this.indTestProducers.get(i).getName() + ": " + this.getIndependenceTest(i).toString()));
            b2a.add(Box.createHorizontalGlue());
            b1.add(b2a);
        }
        b1.add(Box.createVerticalStrut(5));
        Box b3 = Box.createHorizontalBox();
        b3.add(this.getTextField());
        b3.add(variableBox);
        b3.add(delete);
        b1.add(b3);
        b1.add(Box.createVerticalStrut(10));
        this.tableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Index";
                }
                if (column == 1) {
                    return "Fact";
                }
                if (column >= 2) {
                    return ((IndTestProducer)IndependenceFactsEditor.this.indTestProducers.get(column - 2)).getName();
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 2 + IndependenceFactsEditor.this.indTestProducers.size();
            }

            @Override
            public int getRowCount() {
                return IndependenceFactsEditor.this.results.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex > IndependenceFactsEditor.this.results.size()) {
                    return null;
                }
                if (columnIndex == 0) {
                    return ((IndependenceResultIndFacts)((List)IndependenceFactsEditor.this.results.get(rowIndex)).get(0)).getIndex();
                }
                if (columnIndex == 1) {
                    return ((IndependenceResultIndFacts)((List)IndependenceFactsEditor.this.results.get(rowIndex)).get(0)).getFact();
                }
                IndependenceResultIndFacts independenceResult = (IndependenceResultIndFacts)((List)IndependenceFactsEditor.this.results.get(rowIndex)).get(columnIndex - 2);
                for (int i = 0; i < IndependenceFactsEditor.this.indTestProducers.size(); ++i) {
                    if (columnIndex != i + 2) continue;
                    if (IndependenceFactsEditor.this.getIndependenceTest(i) instanceof IndTestDSep) {
                        if (independenceResult.getType() == IndependenceResultIndFacts.Type.INDEPENDENT) {
                            return "D-SEPARATED";
                        }
                        if (independenceResult.getType() == IndependenceResultIndFacts.Type.DEPENDENT) {
                            return "d-connected";
                        }
                        if (independenceResult.getType() != IndependenceResultIndFacts.Type.UNDETERMINED) continue;
                        return "*";
                    }
                    if (IndependenceFactsEditor.this.isShowPs()) {
                        return IndependenceFactsEditor.this.nf.format(independenceResult.getpValue());
                    }
                    if (independenceResult.getType() == IndependenceResultIndFacts.Type.INDEPENDENT) {
                        return "INDEPENDENT";
                    }
                    if (independenceResult.getType() == IndependenceResultIndFacts.Type.DEPENDENT) {
                        return "dependent";
                    }
                    if (independenceResult.getType() != IndependenceResultIndFacts.Type.UNDETERMINED) continue;
                    return "*";
                }
                return null;
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Number.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                if (columnIndex == 2) {
                    return Number.class;
                }
                return Number.class;
            }
        };
        JTable table = new JTable(this.tableModel);
        table.getColumnModel().getColumn(0).setMinWidth(40);
        table.getColumnModel().getColumn(0).setMaxWidth(40);
        table.getColumnModel().getColumn(1).setMinWidth(200);
        table.getColumnModel().getColumn(1).setCellRenderer(new Renderer(this));
        for (int i = 2; i < table.getColumnModel().getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).setMinWidth(100);
            table.getColumnModel().getColumn(i).setMaxWidth(100);
            table.getColumnModel().getColumn(i).setCellRenderer(new Renderer(this));
        }
        JTableHeader header = table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTableHeader header = (JTableHeader)e.getSource();
                Point point = e.getPoint();
                int col = header.columnAtPoint(point);
                int sortCol = header.getTable().convertColumnIndexToModel(col);
                IndependenceFactsEditor.this.sortByColumn(sortCol);
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(400, 400));
        b1.add(scroll);
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Limit list to "));
        IntTextField field = new IntTextField(this.getListLimit(), 7);
        field.setFilter((value, oldValue) -> {
            try {
                this.setListLimit(value);
                return value;
            }
            catch (Exception e) {
                return oldValue;
            }
        });
        b4.add(field);
        b4.add(new JLabel(" items."));
        b4.add(Box.createHorizontalStrut(10));
        final JButton showPValues = new JButton("Show P Values");
        showPValues.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IndependenceFactsEditor.this.toggleShowPs();
                if (IndependenceFactsEditor.this.showPs) {
                    showPValues.setText("Show Independencies");
                } else {
                    showPValues.setText("Show P Values or Scores");
                }
            }
        });
        b4.add(showPValues);
        b4.add(Box.createHorizontalGlue());
        b4.add(list);
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        IndependenceFactsEditor panel = this;
        panel.setLayout(new BorderLayout());
        panel.add((Component)b1, "Center");
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    private void sortByColumn(int sortCol) {
        if (sortCol == this.getLastSortCol()) {
            this.setSortDir(-1 * this.getSortDir());
        } else {
            this.setSortDir(1);
        }
        this.setLastSortCol(sortCol);
        this.results.sort((r1, r2) -> {
            switch (sortCol) {
                case 0: 
                case 1: {
                    return this.getSortDir() * (((IndependenceResultIndFacts)r1.get(0)).getIndex() - ((IndependenceResultIndFacts)r2.get(0)).getIndex());
                }
            }
            int col = sortCol - 2;
            int ind1 = ((IndependenceResultIndFacts)r1.get(col)).getType() == IndependenceResultIndFacts.Type.UNDETERMINED ? 0 : (((IndependenceResultIndFacts)r1.get(col)).getType() == IndependenceResultIndFacts.Type.DEPENDENT ? 1 : 2);
            int ind2 = ((IndependenceResultIndFacts)r2.get(col)).getType() == IndependenceResultIndFacts.Type.UNDETERMINED ? 0 : (((IndependenceResultIndFacts)r2.get(col)).getType() == IndependenceResultIndFacts.Type.DEPENDENT ? 1 : 2);
            return this.getSortDir() * (ind1 - ind2);
        });
        this.tableModel.fireTableDataChanged();
    }

    private boolean isShowPs() {
        return this.showPs;
    }

    private void toggleShowPs() {
        this.showPs = !this.showPs;
        this.tableModel.fireTableDataChanged();
    }

    private List<String> getDataVars() {
        return this.getIndependenceTest(0).getVariableNames();
    }

    private void resetText() {
        StringBuilder buf = new StringBuilder();
        if (this.getVars().size() == 0) {
            buf.append("Choose variables and wildcards from dropdown-->");
        }
        if (this.getVars().size() > 0) {
            buf.append(" ").append(this.getVars().get(0));
            buf.append(" _||_ ");
        }
        if (this.getVars().size() > 1) {
            buf.append(this.getVars().get(1));
        }
        if (this.getVars().size() > 2) {
            buf.append(" | ");
        }
        for (int i = 2; i < this.getVars().size() - 1; ++i) {
            buf.append(this.getVars().get(i));
            buf.append(", ");
        }
        if (this.getVars().size() > 2) {
            buf.append(this.getVars().get(this.getVars().size() - 1));
        }
        this.model.setVars(this.getVars());
        this.textField.setText(buf.toString());
    }

    private void generateResults() {
        int[] choice1;
        this.results = new ArrayList<List<IndependenceResultIndFacts>>();
        List<String> dataVars = this.getDataVars();
        if (this.getVars().size() < 2) {
            this.tableModel.fireTableDataChanged();
            return;
        }
        int numQuestionMarksFirstTwo = 0;
        int numQuestionMarksRest = 0;
        int numPluses = 0;
        int numFixed = 0;
        for (int i = 0; i < this.vars.size(); ++i) {
            String var = this.vars.get(i);
            if ("?".equals(var) && i < 2) {
                ++numQuestionMarksFirstTwo;
                continue;
            }
            if ("?".equals(var)) {
                ++numQuestionMarksRest;
                continue;
            }
            if ("+".equals(var)) {
                ++numPluses;
                continue;
            }
            ++numFixed;
        }
        int[] questionMarkFirstTwoIndices = new int[numQuestionMarksFirstTwo];
        int[] questionMarkRestIndices = new int[numQuestionMarksRest];
        int[] plusIndices = new int[numPluses];
        int[] fixedIndices = new int[numFixed];
        String[] fixedVars = new String[numFixed];
        int _i = -1;
        int _j = -1;
        int _k = -1;
        int _l = -1;
        for (int i = 0; i < this.vars.size(); ++i) {
            if ("?".equals(this.vars.get(i)) && i < 2) {
                questionMarkFirstTwoIndices[++_i] = i;
                continue;
            }
            if ("?".equals(this.vars.get(i))) {
                questionMarkRestIndices[++_j] = i;
                continue;
            }
            if ("+".equals(this.vars.get(i))) {
                plusIndices[++_k] = i;
                continue;
            }
            fixedIndices[++_l] = i;
            fixedVars[_l] = this.vars.get(i);
        }
        ArrayList<String> vars1 = new ArrayList<String>(dataVars);
        vars1.removeAll(this.vars);
        ChoiceGenerator gen1 = new ChoiceGenerator(vars1.size(), questionMarkFirstTwoIndices.length);
        block4: while ((choice1 = gen1.next()) != null) {
            int[] choice2;
            List<String> s2 = IndependenceFactsEditor.asList(choice1, vars1);
            ArrayList<String> vars2 = new ArrayList<String>(vars1);
            vars2.removeAll(s2);
            ChoiceGenerator gen2 = new ChoiceGenerator(vars2.size(), questionMarkRestIndices.length);
            while ((choice2 = gen2.next()) != null) {
                int[] choice3;
                List<String> s3 = IndependenceFactsEditor.asList(choice2, vars2);
                ArrayList<String> vars3 = new ArrayList<String>(vars2);
                vars3.removeAll(s3);
                SublistGenerator gen3 = new SublistGenerator(vars3.size(), plusIndices.length);
                while ((choice3 = gen3.next()) != null) {
                    this.results.add(new ArrayList());
                    for (int prod = 0; prod < this.indTestProducers.size(); ++prod) {
                        double pValue;
                        IndependenceResultIndFacts.Type indep;
                        int i;
                        String[] vars4 = new String[fixedIndices.length + questionMarkFirstTwoIndices.length + questionMarkRestIndices.length + choice3.length];
                        for (i = 0; i < fixedIndices.length; ++i) {
                            vars4[fixedIndices[i]] = fixedVars[i];
                        }
                        for (i = 0; i < choice1.length; ++i) {
                            vars4[questionMarkFirstTwoIndices[i]] = (String)vars1.get(choice1[i]);
                        }
                        for (i = 0; i < choice2.length; ++i) {
                            vars4[questionMarkRestIndices[i]] = (String)vars2.get(choice2[i]);
                        }
                        for (i = 0; i < choice3.length; ++i) {
                            vars4[plusIndices[i]] = (String)vars3.get(choice3[i]);
                        }
                        IndependenceTest independenceTest = this.getIndependenceTest(prod);
                        Node x = independenceTest.getVariable(vars4[0]);
                        Node y = independenceTest.getVariable(vars4[1]);
                        ArrayList<Node> z = new ArrayList<Node>();
                        for (int i2 = 2; i2 < vars4.length; ++i2) {
                            z.add(independenceTest.getVariable(vars4[i2]));
                        }
                        try {
                            IndependenceResult result = independenceTest.checkIndependence(x, y, z);
                            indep = result.independent() ? IndependenceResultIndFacts.Type.INDEPENDENT : IndependenceResultIndFacts.Type.DEPENDENT;
                            pValue = result.getPValue();
                        }
                        catch (Exception e) {
                            indep = IndependenceResultIndFacts.Type.UNDETERMINED;
                            pValue = Double.NaN;
                        }
                        this.results.get(this.results.size() - 1).add(new IndependenceResultIndFacts(this.results.size(), IndependenceFactsEditor.factString(x, y, z), indep, pValue));
                    }
                    if (this.results.size() <= this.getListLimit()) continue;
                    break block4;
                }
            }
        }
        this.model.setResults(this.results);
        this.tableModel.fireTableDataChanged();
    }

    private static List<String> asList(int[] indices, List<String> nodes) {
        LinkedList<String> list = new LinkedList<String>();
        for (int i : indices) {
            list.add(nodes.get(i));
        }
        return list;
    }

    private LinkedList<String> getVars() {
        return this.vars;
    }

    private JTextField getTextField() {
        return this.textField;
    }

    public IndependenceFactsEditor(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    private static String factString(Node x, Node y, List<Node> condSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(x.getName());
        sb.append(" _||_ ");
        sb.append(y.getName());
        Iterator<Node> it = condSet.iterator();
        if (it.hasNext()) {
            sb.append(" | ");
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(", ");
            sb.append(it.next());
        }
        return sb.toString();
    }

    private IndependenceTest getIndependenceTest(int i) {
        return this.indTestProducers.get(i).getIndependenceTest();
    }

    private int getLastSortCol() {
        return this.lastSortCol;
    }

    private void setLastSortCol(int lastSortCol) {
        if (lastSortCol < 0 || lastSortCol > 4) {
            throw new IllegalArgumentException();
        }
        this.lastSortCol = lastSortCol;
    }

    private int getSortDir() {
        return this.sortDir;
    }

    private void setSortDir(int sortDir) {
        if (sortDir != 1 && sortDir != -1) {
            throw new IllegalArgumentException();
        }
        this.sortDir = sortDir;
    }

    private int getListLimit() {
        return Preferences.userRoot().getInt("indFactsListLimit", 10000);
    }

    private void setListLimit(int listLimit) {
        if (listLimit < 1) {
            throw new IllegalArgumentException();
        }
        Preferences.userRoot().putInt("indFactsListLimit", listLimit);
    }

    static class Renderer
    extends DefaultTableCellRenderer {
        private final IndependenceFactsEditor editor;
        private JTable table;
        private int row;
        private boolean selected;

        public Renderer(IndependenceFactsEditor editor) {
            this.editor = editor;
        }

        @Override
        public void setValue(Object value) {
            int indep = 0;
            int numCols = this.table.getModel().getColumnCount();
            if (this.selected) {
                this.setForeground(this.table.getSelectionForeground());
                this.setBackground(this.table.getSelectionBackground());
            } else {
                for (int i = 2; i < numCols; ++i) {
                    Object _value = this.table.getModel().getValueAt(this.row, i);
                    if (!"INDEPENDENT".equals(_value) && !"D-SEPARATED".equals(_value)) continue;
                    ++indep;
                }
                this.setForeground(this.table.getForeground());
                if (!this.editor.isShowPs()) {
                    if (indep != 0 && indep != numCols - 2) {
                        this.setBackground(Color.YELLOW);
                    } else {
                        this.setBackground(this.table.getBackground());
                    }
                } else {
                    this.setBackground(this.table.getBackground());
                }
            }
            this.setText((String)value);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.table = table;
            this.row = row;
            this.selected = isSelected;
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

