/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesXmlParser;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.BayesImEditor;
import edu.cmu.tetradapp.model.BayesImWrapper;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.Serializer;

class LoadBayesImXmlAction
extends AbstractAction {
    private final BayesImWrapper bayesImWrapper;
    private final BayesImEditor bayesImEditor;

    public LoadBayesImXmlAction(BayesImWrapper wrapper, BayesImEditor bayesImEditor) {
        super("Load Bayes IM as XML");
        if (bayesImEditor == null) {
            throw new NullPointerException("BayesImEditorWizard must not be null.");
        }
        this.bayesImWrapper = wrapper;
        this.bayesImEditor = bayesImEditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.bayesImWrapper == null) {
            throw new RuntimeException("Not a Bayes IM.");
        }
        JFileChooser chooser = LoadBayesImXmlAction.getJFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.showOpenDialog(null);
        File file = chooser.getSelectedFile();
        if (file != null) {
            Preferences.userRoot().put("fileSaveLocation", file.getParent());
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(file);
            LoadBayesImXmlAction.printDocument(document);
            BayesXmlParser parser = new BayesXmlParser();
            BayesIm bayesIm = parser.getBayesIm(document.getRootElement());
            System.out.println(bayesIm);
            boolean allSpecified = true;
            for (Node node : bayesIm.getBayesPm().getDag().getNodes()) {
                if (node.getCenterX() != -1 && node.getCenterY() != -1) continue;
                allSpecified = false;
            }
            if (!allSpecified) {
                LayoutUtil.circleLayout(bayesIm.getBayesPm().getDag(), 200, 200, 150);
            }
            this.bayesImWrapper.setBayesIm(bayesIm);
            this.bayesImEditor.getBayesIm();
        }
        catch (ParsingException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Had trouble parsing that...");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Had trouble reading the file...");
        }
    }

    private static JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", Preferences.userRoot().absolutePath());
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }

    private static void printDocument(Document document) {
        Serializer serializer = new Serializer(System.out);
        serializer.setLineSeparator("\n");
        serializer.setIndent(2);
        try {
            serializer.write(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

