/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.LoadDataDialog;
import edu.cmu.tetradapp.model.DataWrapper;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

final class LoadDataAction
extends AbstractAction {
    private static final long serialVersionUID = 929333197876935694L;
    private final DataEditor dataEditor;

    public LoadDataAction(DataEditor editor) {
        super("Load Data...");
        if (editor == null) {
            throw new NullPointerException("Data Editor must not be null.");
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModelList _dataModelList;
        JFileChooser chooser = LoadDataAction.getJFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle("Choose data files (choose multiple files with Ctrl or Shift key)");
        int _ret = chooser.showDialog(this.dataEditor, "Choose");
        if (_ret == 1) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        Preferences.userRoot().put("fileSaveLocation", files[0].getParent());
        LoadDataDialog loadData = new LoadDataDialog(files);
        try {
            loadData.showDataLoaderDialog();
        }
        catch (IOException ex) {
            Logger.getLogger(LoadDataAction.class.getName()).log(Level.SEVERE, null, ex);
        }
        boolean keepData = false;
        if (!this.isDataEmpty()) {
            String message = "Would you like to replace the model data?";
            int option = JOptionPane.showOptionDialog(this.dataEditor, "Would you like to replace the model data?", "Data Replacement", 0, 3, null, new String[]{"Replace", "Keep"}, "Replace");
            boolean bl = keepData = option == 1;
        }
        if ((_dataModelList = loadData.getDataModels()).isEmpty()) {
            return;
        }
        DataModelList dataModelList = keepData ? this.dataEditor.getDataModelList() : new DataModelList();
        dataModelList.addAll(_dataModelList);
        this.dataEditor.replace(dataModelList);
        this.dataEditor.selectFirstTab();
        this.firePropertyChange("modelChanged", null, null);
    }

    private boolean isDataEmpty() {
        DataWrapper wrapper = this.dataEditor.getDataWrapper();
        DataModelList dataModels = wrapper.getDataModelList();
        Iterator iterator = dataModels.iterator();
        if (iterator.hasNext()) {
            DataModel model = (DataModel)iterator.next();
            if (model instanceof DataSet) {
                return ((DataSet)model).getNumRows() == 0;
            }
            return false;
        }
        return true;
    }

    private static JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }
}

