/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.LoadDataSettings;
import edu.pitt.dbmi.data.reader.preview.BasicDataPreviewer;
import edu.pitt.dbmi.data.reader.validation.ValidationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringEscapeUtils;

public final class LoadDataDialog
extends JPanel {
    private static final long serialVersionUID = 2299304318793152418L;
    private final List<File> loadedFiles;
    private final List<String> validationResults;
    private final List<String> failedFiles;
    private LoadDataSettings loadDataSettings;
    private final DataModelList dataModelList;
    private final JTextPane validationResultTextPane;
    private final JTextArea filePreviewTextArea;
    private final int previewFromLine;
    private final int previewToLine;
    private final int previewNumOfCharactersPerLine;
    private JList fileList;
    private JList validationFileList;
    private JDialog loadingIndicatorDialog;
    private final DefaultListModel fileListModel;
    private final DefaultListModel validatedFileListModel;
    private Box filePreviewBox;
    private String previewBoxBorderTitle;
    private final String defaulyPreviewBoxBorderTitle;
    private Box container;
    private Box previewContainer;
    private Box fileListBox;
    private Box basicSettingsBox;
    private Box advancedSettingsBox;
    private Box validationResultsContainer;
    private JButton settingsButton;
    private JButton validateButton;
    private JButton loadButton;

    public LoadDataDialog(File ... files) {
        this.loadedFiles = new LinkedList<File>(Arrays.asList(files));
        this.validationResults = new ArrayList<String>();
        this.failedFiles = new ArrayList<String>();
        this.filePreviewTextArea = new JTextArea();
        this.previewFromLine = 1;
        this.previewToLine = 20;
        this.previewNumOfCharactersPerLine = 100;
        this.fileListModel = new DefaultListModel();
        this.validatedFileListModel = new DefaultListModel();
        this.defaulyPreviewBoxBorderTitle = "Data Preview: ";
        this.dataModelList = new DataModelList();
        this.validationResultTextPane = new JTextPane();
        this.loadingIndicatorDialog = new JDialog();
    }

    public void showDataLoaderDialog() throws IOException {
        this.container = Box.createVerticalBox();
        this.container.setPreferredSize(new Dimension(900, 620));
        this.loadDataSettings = new LoadDataSettings(this.loadedFiles);
        this.basicSettingsBox = this.loadDataSettings.basicSettings();
        this.advancedSettingsBox = this.loadDataSettings.advancedSettings();
        Box settingsContainer = Box.createVerticalBox();
        settingsContainer.add(this.basicSettingsBox);
        settingsContainer.add(Box.createVerticalStrut(10));
        settingsContainer.add(this.advancedSettingsBox);
        settingsContainer.add(Box.createVerticalStrut(10));
        this.container.add(settingsContainer);
        this.previewContainer = Box.createHorizontalBox();
        this.previewContainer.setPreferredSize(new Dimension(900, 250));
        for (File file : this.loadedFiles) {
            this.fileListModel.addElement(file.getName());
        }
        this.fileList = new JList(this.fileListModel);
        this.fileList.setSelectionMode(0);
        this.fileList.setSelectedIndex(0);
        this.fileList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int fileIndex = this.fileList.getMinSelectionIndex();
                if (fileIndex < 0) {
                    this.filePreviewBox.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(this.defaulyPreviewBoxBorderTitle), new EmptyBorder(5, 5, 5, 5)));
                    this.filePreviewTextArea.setText("");
                } else {
                    this.previewBoxBorderTitle = this.defaulyPreviewBoxBorderTitle + this.loadedFiles.get(fileIndex).getName();
                    this.filePreviewBox.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(this.previewBoxBorderTitle), new EmptyBorder(5, 5, 5, 5)));
                    this.setPreview(this.loadedFiles.get(fileIndex), this.filePreviewTextArea);
                }
            }
        });
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SwingUtilities.isRightMouseButton(e)) {
                    int index = LoadDataDialog.this.fileList.getSelectedIndex();
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem close = new JMenuItem("Remove this selected file from the loading list");
                    menu.add(close);
                    Point point = e.getPoint();
                    menu.show(LoadDataDialog.this.fileList, point.x, point.y);
                    close.addActionListener(evt -> {
                        if (LoadDataDialog.this.loadedFiles.size() == 1) {
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "You can't remove when there's only one file.");
                        } else {
                            int selectedAction = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Are you sure you want to remove this data file from the data loading list?", "Confirm", 2, 2);
                            if (selectedAction == 0) {
                                LoadDataDialog.this.fileListModel.remove(index);
                                System.out.println("Removing file of index = " + index + " from data loading list");
                                LoadDataDialog.this.loadedFiles.remove(index);
                                LoadDataDialog.this.fileList.setSelectedIndex(0);
                                LoadDataDialog.this.setPreview((File)LoadDataDialog.this.loadedFiles.get(0), LoadDataDialog.this.filePreviewTextArea);
                            }
                        }
                    });
                }
            }
        });
        JScrollPane fileListScrollPane = new JScrollPane(this.fileList);
        fileListScrollPane.setAlignmentX(0.0f);
        this.fileListBox = Box.createVerticalBox();
        this.fileListBox.setMinimumSize(new Dimension(305, 250));
        this.fileListBox.setMaximumSize(new Dimension(305, 250));
        this.fileListBox.add(fileListScrollPane);
        this.fileListBox.add(Box.createVerticalStrut(10));
        JButton addFileButton = new JButton("Add more files to the loading list ...");
        addFileButton.addActionListener(e -> {
            File[] newFiles;
            JFileChooser fileChooser = new JFileChooser();
            String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
            fileChooser.setCurrentDirectory(new File(sessionSaveLocation));
            fileChooser.resetChoosableFileFilters();
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle("Add more files");
            int _ret = fileChooser.showDialog(this.container, "Choose");
            if (_ret == 1) {
                return;
            }
            for (File newFile : newFiles = fileChooser.getSelectedFiles()) {
                if (this.loadedFiles.contains(newFile)) continue;
                this.loadedFiles.add(newFile);
                this.fileListModel.addElement(newFile.getName());
            }
        });
        this.fileListBox.add(addFileButton);
        String fileListBoxBorderTitle = "Files (right click to remove selected file)";
        this.fileListBox.setBorder(new CompoundBorder(BorderFactory.createTitledBorder("Files (right click to remove selected file)"), new EmptyBorder(5, 5, 5, 5)));
        this.previewContainer.add(this.fileListBox);
        this.previewContainer.add(Box.createHorizontalStrut(10), 1);
        this.filePreviewBox = Box.createVerticalBox();
        this.filePreviewBox.setMinimumSize(new Dimension(585, 250));
        this.filePreviewBox.setMaximumSize(new Dimension(585, 250));
        this.filePreviewTextArea.setEditable(false);
        this.filePreviewTextArea.setFont(new Font("Monospaced", 0, 12));
        this.setPreview(this.loadedFiles.get(0), this.filePreviewTextArea);
        JScrollPane filePreviewScrollPane = new JScrollPane(this.filePreviewTextArea);
        this.filePreviewBox.add(filePreviewScrollPane);
        this.filePreviewBox.add(Box.createVerticalStrut(10));
        JLabel previewInstructionText = new JLabel(String.format("Showing from line %d to line %d, up to %d characters per line", this.previewFromLine, this.previewToLine, this.previewNumOfCharactersPerLine));
        this.filePreviewBox.add(previewInstructionText);
        this.previewBoxBorderTitle = this.defaulyPreviewBoxBorderTitle + this.loadedFiles.get(0).getName();
        this.filePreviewBox.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(this.previewBoxBorderTitle), new EmptyBorder(5, 5, 5, 5)));
        this.previewContainer.add(this.filePreviewBox);
        this.container.add(this.previewContainer);
        this.validationResultsContainer = Box.createVerticalBox();
        Box validationSummaryBox = Box.createHorizontalBox();
        JLabel validationSummaryText = new JLabel("Please review. You can change the settings or add/remove files by clicking the Settings button.");
        validationSummaryBox.add(validationSummaryText);
        Box validationResultsBox = Box.createHorizontalBox();
        Box filesToValidateBox = Box.createVerticalBox();
        filesToValidateBox.setMinimumSize(new Dimension(305, 430));
        filesToValidateBox.setMaximumSize(new Dimension(305, 430));
        this.validationFileList = new JList(this.validatedFileListModel);
        this.validationFileList.setSelectionMode(0);
        this.validationFileList.addListSelectionListener(e -> {
            int fileIndex;
            if (!e.getValueIsAdjusting() && (fileIndex = this.validationFileList.getSelectedIndex()) != -1) {
                this.setValidationResult(this.validationResults.get(fileIndex), this.validationResultTextPane);
            }
        });
        JScrollPane filesToValidateScrollPane = new JScrollPane(this.validationFileList);
        filesToValidateScrollPane.setAlignmentX(0.0f);
        filesToValidateBox.add(filesToValidateScrollPane);
        validationResultsBox.add(filesToValidateBox);
        validationResultsBox.add(Box.createHorizontalStrut(10), 1);
        Box validationMessageBox = Box.createVerticalBox();
        validationMessageBox.setMinimumSize(new Dimension(560, 430));
        validationMessageBox.setMaximumSize(new Dimension(560, 430));
        this.validationResultTextPane.setContentType("text/html");
        this.validationResultTextPane.setEditable(false);
        JScrollPane summaryScrollPane = new JScrollPane(this.validationResultTextPane);
        validationMessageBox.add(summaryScrollPane);
        validationResultsBox.add(validationMessageBox);
        this.validationResultsContainer.add(validationSummaryBox);
        this.validationResultsContainer.add(Box.createVerticalStrut(10));
        this.validationResultsContainer.add(validationResultsBox);
        String validationResultsContainerBorderTitle = "Validate";
        this.validationResultsContainer.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(validationResultsContainerBorderTitle), new EmptyBorder(5, 5, 5, 5)));
        this.container.add(this.validationResultsContainer);
        this.validationResultsContainer.setVisible(false);
        this.settingsButton = new JButton("< Settings");
        this.settingsButton.addActionListener(e -> {
            this.fileListBox.setVisible(true);
            this.basicSettingsBox.setVisible(true);
            this.advancedSettingsBox.setVisible(true);
            this.previewContainer.setVisible(true);
            this.validationResultsContainer.setVisible(false);
            this.settingsButton.setVisible(false);
            this.validateButton.setVisible(true);
            this.loadButton.setVisible(false);
            this.validatedFileListModel.clear();
            this.validationResults.clear();
            this.failedFiles.clear();
        });
        this.validateButton = new JButton("Validate >");
        this.validateButton.addActionListener(e -> {
            ArrayList<String> inputErrors = new ArrayList<String>();
            if (!this.loadDataSettings.isColumnLabelSpecified()) {
                inputErrors.add("- Please specify the column labels to ignore.");
            }
            if (!this.loadDataSettings.isOtherCommentMarkerSpecified()) {
                inputErrors.add("- Please specify the comment marker.");
            }
            if (!inputErrors.isEmpty()) {
                StringBuilder inputErrorMessages = new StringBuilder();
                for (String error : inputErrors) {
                    inputErrorMessages.append(error).append("\n");
                }
                JOptionPane.showMessageDialog(this.container, inputErrorMessages.toString(), "Input Error", 0);
                return;
            }
            this.validateButton.setEnabled(false);
            this.validateButton.setText("Validating ...");
            new Thread(() -> {
                this.validateAllFiles();
                SwingUtilities.invokeLater(() -> {
                    this.hideLoadingIndicator();
                    this.validationResultsContainer.setVisible(true);
                    this.fileListBox.setVisible(false);
                    this.basicSettingsBox.setVisible(false);
                    this.advancedSettingsBox.setVisible(false);
                    this.previewContainer.setVisible(false);
                    this.settingsButton.setVisible(true);
                    this.validateButton.setVisible(false);
                    this.loadButton.setVisible(true);
                    this.loadButton.setEnabled(this.failedFiles.size() <= 0);
                    this.validateButton.setEnabled(true);
                    this.validateButton.setText("Validate >");
                });
            }).start();
            this.showLoadingIndicator("Validating...", e);
        });
        this.loadButton = new JButton("Load");
        this.loadButton.addActionListener(e -> {
            this.loadButton.setEnabled(false);
            this.loadButton.setText("Loading ...");
            new Thread(() -> {
                try {
                    this.loadAllFiles();
                }
                catch (IOException ex) {
                    Logger.getLogger(LoadDataDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
                SwingUtilities.invokeLater(() -> {
                    this.hideLoadingIndicator();
                    Window w = SwingUtilities.getWindowAncestor(this.loadButton);
                    if (w != null) {
                        w.setVisible(false);
                    }
                });
            }).start();
            this.showLoadingIndicator("Loading...", e);
        });
        Box buttonsContainer = Box.createVerticalBox();
        buttonsContainer.add(Box.createVerticalStrut(20));
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.add(this.settingsButton);
        buttonsBox.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonsBox.add(this.validateButton);
        buttonsBox.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonsBox.add(this.loadButton);
        this.settingsButton.setVisible(false);
        this.loadButton.setVisible(false);
        buttonsContainer.add(buttonsBox);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.container, "Center");
        mainPanel.add((Component)buttonsContainer, "South");
        JOptionPane.showOptionDialog(JOptionUtils.centeringComp(), mainPanel, "Data File Loader", 2, -1, null, new Object[0], null);
    }

    private void showLoadingIndicator(String message, ActionEvent evt) {
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setIndeterminate(true);
        Box dataLoadingIndicatorBox = Box.createVerticalBox();
        dataLoadingIndicatorBox.setPreferredSize(new Dimension(200, 60));
        JLabel label = new JLabel(message);
        label.setAlignmentX(0.5f);
        Box progressBarBox = Box.createHorizontalBox();
        progressBarBox.add(Box.createRigidArea(new Dimension(10, 1)));
        progressBarBox.add(progressBar);
        progressBarBox.add(Box.createRigidArea(new Dimension(10, 1)));
        dataLoadingIndicatorBox.add(Box.createVerticalStrut(10));
        dataLoadingIndicatorBox.add(label);
        dataLoadingIndicatorBox.add(Box.createVerticalStrut(10));
        dataLoadingIndicatorBox.add(progressBarBox);
        Frame ancestor = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)evt.getSource());
        this.loadingIndicatorDialog = new JDialog(ancestor, true);
        this.loadingIndicatorDialog.setUndecorated(true);
        this.loadingIndicatorDialog.getContentPane().add(dataLoadingIndicatorBox);
        this.loadingIndicatorDialog.pack();
        this.loadingIndicatorDialog.setLocationRelativeTo(JOptionUtils.centeringComp());
        this.loadingIndicatorDialog.setVisible(true);
    }

    private void hideLoadingIndicator() {
        this.loadingIndicatorDialog.setVisible(false);
        this.loadingIndicatorDialog.dispose();
    }

    private void validateAllFiles() {
        for (File loadedFile : this.loadedFiles) {
            try {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append("<p>Validation result of ");
                strBuilder.append(loadedFile.getName());
                strBuilder.append(":&gt; 0");
                List<ValidationResult> results = this.loadDataSettings.validateDataWithSettings(loadedFile);
                LinkedList<ValidationResult> infos = new LinkedList<ValidationResult>();
                LinkedList<ValidationResult> warnings = new LinkedList<ValidationResult>();
                LinkedList<ValidationResult> errors = new LinkedList<ValidationResult>();
                block7: for (ValidationResult result : results) {
                    switch (result.getCode()) {
                        case INFO: {
                            infos.add(result);
                            continue block7;
                        }
                        case WARNING: {
                            warnings.add(result);
                            continue block7;
                        }
                    }
                    errors.add(result);
                }
                if (!infos.isEmpty()) {
                    strBuilder.append("<p><b>File info:</b><br />");
                    infos.forEach(e -> {
                        strBuilder.append(e.getMessage());
                        strBuilder.append("<br />");
                    });
                    strBuilder.append("&gt; 0");
                }
                int validationWarnErrMsgThreshold = 10;
                if (!warnings.isEmpty()) {
                    int warnCount = warnings.size();
                    strBuilder.append("<p style=\"color: orange;\"><b>Warning (total ");
                    strBuilder.append(warnCount);
                    if (warnCount > validationWarnErrMsgThreshold) {
                        strBuilder.append(", showing the first ");
                        strBuilder.append(validationWarnErrMsgThreshold);
                        strBuilder.append("): </b><br />");
                        warnings.subList(0, validationWarnErrMsgThreshold).forEach(e -> {
                            strBuilder.append(e.getMessage());
                            strBuilder.append("<br />");
                        });
                    } else {
                        strBuilder.append("): </b><br />");
                        warnings.forEach(e -> {
                            strBuilder.append(e.getMessage());
                            strBuilder.append("<br />");
                        });
                    }
                    strBuilder.append("&gt; 0");
                }
                if (!errors.isEmpty()) {
                    int errorCount = errors.size();
                    String errorCountString = errorCount > 1 ? " errors" : " error";
                    strBuilder.append("<p style=\"color: red;\"><b>Validation failed!<br>Please fix the following ");
                    if (errorCount > validationWarnErrMsgThreshold) {
                        strBuilder.append(validationWarnErrMsgThreshold);
                        strBuilder.append(errorCountString);
                        strBuilder.append(" (total ");
                        strBuilder.append(errorCount);
                        strBuilder.append(") and validate again:</b><br />");
                        errors.subList(0, validationWarnErrMsgThreshold).forEach(e -> {
                            strBuilder.append(StringEscapeUtils.escapeHtml4(e.getMessage()));
                            strBuilder.append("<br />");
                        });
                    } else {
                        strBuilder.append(errorCount);
                        strBuilder.append(errorCountString);
                        strBuilder.append(" and validate again:</b><br />");
                        errors.forEach(e -> {
                            strBuilder.append(StringEscapeUtils.escapeHtml4(e.getMessage()));
                            strBuilder.append("<br />");
                        });
                    }
                    strBuilder.append("&gt; 0");
                    this.failedFiles.add(loadedFile.getName());
                } else if (loadedFile.length() == 0L) {
                    strBuilder.append("<p style=\"color: red;\"><b>This is an empty data file!</b>&gt; 0");
                    this.failedFiles.add(loadedFile.getName());
                } else {
                    strBuilder.append("<p style=\"color: green;\"><b>Validation passed with no error!</b>&gt; 0");
                }
                this.validationResults.add(strBuilder.toString());
            }
            catch (IOException ex) {
                Logger.getLogger(LoadDataDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.showValidationResults();
    }

    private void showValidationResults() {
        for (File loadedFile : this.loadedFiles) {
            String unicodePrefix = "\u2713";
            if (this.failedFiles.contains(loadedFile.getName())) {
                unicodePrefix = "\u2717";
            }
            this.validatedFileListModel.addElement("[" + unicodePrefix + "] " + loadedFile.getName());
        }
        this.validationFileList.setSelectedIndex(0);
        this.setValidationResult(this.validationResults.get(0), this.validationResultTextPane);
    }

    private void loadAllFiles() throws IOException {
        for (int i = 0; i < this.loadedFiles.size(); ++i) {
            DataModel dataModel = this.loadDataSettings.loadDataWithSettings(this.loadedFiles.get(i));
            if (dataModel == null) continue;
            dataModel.setName(this.loadedFiles.get(i).getName());
            this.dataModelList.add(dataModel);
            System.out.println("File index = " + i + " has been loaded successfully");
        }
    }

    public DataModelList getDataModels() {
        return this.dataModelList;
    }

    private void setValidationResult(String output, JTextPane textPane) {
        textPane.setText("<html><body style=\"font-family: Monospaced; font-size: 10px; white-space:nowrap; \"" + output + "</body></html>");
        textPane.setCaretPosition(0);
    }

    private void setPreview(File file, JTextArea textArea) {
        try {
            textArea.setText("");
            BasicDataPreviewer dataPreviewer = new BasicDataPreviewer(file.toPath());
            List<String> linePreviews = dataPreviewer.getPreviews(this.previewFromLine, this.previewToLine, this.previewNumOfCharactersPerLine);
            for (String line : linePreviews) {
                textArea.append(line + "\n");
            }
            textArea.setCaretPosition(0);
        }
        catch (IOException ex) {
            Logger.getLogger(LoadDataDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

