/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.StringTextField;
import edu.pitt.dbmi.data.reader.Data;
import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DataColumns;
import edu.pitt.dbmi.data.reader.DataReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.covariance.CovarianceData;
import edu.pitt.dbmi.data.reader.covariance.LowerCovarianceDataFileReader;
import edu.pitt.dbmi.data.reader.metadata.Metadata;
import edu.pitt.dbmi.data.reader.metadata.MetadataFileReader;
import edu.pitt.dbmi.data.reader.tabular.TabularColumnFileReader;
import edu.pitt.dbmi.data.reader.tabular.TabularDataFileReader;
import edu.pitt.dbmi.data.reader.util.TextFileUtils;
import edu.pitt.dbmi.data.reader.validation.ValidationResult;
import edu.pitt.dbmi.data.reader.validation.covariance.LowerCovarianceDataFileValidation;
import edu.pitt.dbmi.data.reader.validation.tabular.TabularColumnFileValidation;
import edu.pitt.dbmi.data.reader.validation.tabular.TabularDataFileValidation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class LoadDataSettings
extends JPanel {
    private static final long serialVersionUID = -7597768949622586036L;
    private final List<File> files;
    private File metadataFile;
    private Metadata metadata;
    private JRadioButton firstRowVarNamesYesRadioButton;
    private JRadioButton firstRowVarNamesNoRadioButton;
    private JRadioButton tabularRadioButton;
    private JRadioButton covarianceRadioButton;
    private JRadioButton contRadioButton;
    private JRadioButton discRadioButton;
    private JRadioButton mixedRadioButton;
    private IntTextField maxNumOfDiscCategoriesField;
    private JRadioButton commentDoubleSlashRadioButton;
    private JRadioButton commentPondRadioButton;
    private JRadioButton commentOtherRadioButton;
    private StringTextField commentStringField;
    private JRadioButton whitespaceDelimiterRadioButton;
    private JRadioButton singleCharDelimiterRadioButton;
    private JComboBox singleCharDelimiterComboBox;
    private JRadioButton doubleQuoteRadioButton;
    private JRadioButton singleQuoteRadioButton;
    private JButton metadataFileButton;
    private JRadioButton idNoneRadioButton;
    private JRadioButton idUnlabeledFirstColRadioButton;
    private JRadioButton idLabeledColRadioButton;
    private StringTextField idStringField;
    private final Color separatorColor;
    private JRadioButton missingValueStarRadioButton;
    private JRadioButton missingValueQuestionRadioButton;
    private StringTextField missingStringField;
    private final Dimension labelSize;

    public LoadDataSettings(List<File> files) {
        this.files = files;
        this.metadataFile = null;
        this.metadata = null;
        this.labelSize = new Dimension(200, 30);
        this.separatorColor = new Color(221, 221, 221);
    }

    public Box basicSettings() throws IOException {
        Box basicSettingsBox = Box.createVerticalBox();
        Box firstRowVarNamesBox = Box.createHorizontalBox();
        this.firstRowVarNamesYesRadioButton = new JRadioButton("Yes");
        this.firstRowVarNamesNoRadioButton = new JRadioButton("No");
        ButtonGroup firstRowVarNamesBtnGrp = new ButtonGroup();
        firstRowVarNamesBtnGrp.add(this.firstRowVarNamesYesRadioButton);
        firstRowVarNamesBtnGrp.add(this.firstRowVarNamesNoRadioButton);
        this.firstRowVarNamesYesRadioButton.setSelected(true);
        this.firstRowVarNamesYesRadioButton.addActionListener(actionEvent -> {
            JRadioButton button = (JRadioButton)actionEvent.getSource();
            if (button.isSelected()) {
                this.metadataFileButton.setEnabled(true);
                if (!this.idLabeledColRadioButton.isEnabled()) {
                    this.idLabeledColRadioButton.setEnabled(true);
                }
                if (!this.idStringField.isEnabled()) {
                    this.idStringField.setEnabled(true);
                }
            }
        });
        this.firstRowVarNamesNoRadioButton.addActionListener(actionEvent -> {
            JRadioButton button = (JRadioButton)actionEvent.getSource();
            if (button.isSelected()) {
                this.metadataFileButton.setEnabled(false);
                this.idLabeledColRadioButton.setEnabled(false);
                this.idStringField.setEnabled(false);
            }
        });
        Box firstRowVarNamesLabelBox = Box.createHorizontalBox();
        firstRowVarNamesLabelBox.setPreferredSize(this.labelSize);
        firstRowVarNamesLabelBox.add(new JLabel("First row variable names:"));
        JLabel firstRowVarNamesLabelInfoIcon = new JLabel(new ImageIcon(ImageUtils.getImage(this, "information_small_white.png")));
        firstRowVarNamesLabelInfoIcon.setToolTipText("Whether the column variable names are presented in the first row of data");
        firstRowVarNamesLabelBox.add(firstRowVarNamesLabelInfoIcon);
        Box firstRowVarNamesOption1Box = Box.createHorizontalBox();
        firstRowVarNamesOption1Box.setPreferredSize(new Dimension(160, 30));
        firstRowVarNamesOption1Box.add(this.firstRowVarNamesYesRadioButton);
        Box firstRowVarNamesOption2Box = Box.createHorizontalBox();
        firstRowVarNamesOption2Box.setPreferredSize(new Dimension(160, 30));
        firstRowVarNamesOption2Box.add(this.firstRowVarNamesNoRadioButton);
        firstRowVarNamesBox.add(firstRowVarNamesLabelBox);
        firstRowVarNamesBox.add(Box.createRigidArea(new Dimension(10, 1)));
        firstRowVarNamesBox.add(firstRowVarNamesOption1Box);
        firstRowVarNamesBox.add(firstRowVarNamesOption2Box);
        firstRowVarNamesBox.add(Box.createHorizontalGlue());
        basicSettingsBox.add(firstRowVarNamesBox);
        Box fileTypeBox = Box.createHorizontalBox();
        this.tabularRadioButton = new JRadioButton("Tabular data");
        this.covarianceRadioButton = new JRadioButton("Covariance data (lower triangle)");
        ButtonGroup fileTypeBtnGrp = new ButtonGroup();
        fileTypeBtnGrp.add(this.tabularRadioButton);
        fileTypeBtnGrp.add(this.covarianceRadioButton);
        this.tabularRadioButton.setSelected(true);
        this.tabularRadioButton.addActionListener(actionEvent -> {
            JRadioButton button = (JRadioButton)actionEvent.getSource();
            if (button.isSelected()) {
                if (this.firstRowVarNamesYesRadioButton.isSelected()) {
                    this.metadataFileButton.setEnabled(true);
                }
                if (!this.discRadioButton.isEnabled()) {
                    this.discRadioButton.setEnabled(true);
                }
                if (!this.mixedRadioButton.isEnabled()) {
                    this.mixedRadioButton.setEnabled(true);
                }
                if (!this.firstRowVarNamesYesRadioButton.isEnabled()) {
                    this.firstRowVarNamesYesRadioButton.setEnabled(true);
                }
                if (!this.firstRowVarNamesNoRadioButton.isEnabled()) {
                    this.firstRowVarNamesNoRadioButton.setEnabled(true);
                }
                if (!this.idUnlabeledFirstColRadioButton.isEnabled()) {
                    this.idUnlabeledFirstColRadioButton.setEnabled(true);
                }
                if (!this.idLabeledColRadioButton.isEnabled()) {
                    this.idLabeledColRadioButton.setEnabled(true);
                }
                if (!this.idStringField.isEnabled()) {
                    this.idStringField.setEnabled(true);
                }
            }
        });
        this.covarianceRadioButton.addActionListener(actionEvent -> {
            JRadioButton button = (JRadioButton)actionEvent.getSource();
            if (button.isSelected()) {
                this.metadataFileButton.setEnabled(false);
                this.contRadioButton.setSelected(true);
                this.discRadioButton.setEnabled(false);
                this.mixedRadioButton.setEnabled(false);
                this.firstRowVarNamesYesRadioButton.setEnabled(false);
                this.firstRowVarNamesNoRadioButton.setEnabled(false);
                this.idNoneRadioButton.setSelected(true);
                this.idUnlabeledFirstColRadioButton.setEnabled(false);
                this.idLabeledColRadioButton.setEnabled(false);
                this.idStringField.setEnabled(false);
            }
        });
        Box fileTypeLabelBox = Box.createHorizontalBox();
        fileTypeLabelBox.setPreferredSize(this.labelSize);
        fileTypeLabelBox.add(new JLabel("Data file type:"));
        Box fileTypeOption1Box = Box.createHorizontalBox();
        fileTypeOption1Box.setPreferredSize(new Dimension(160, 30));
        fileTypeOption1Box.add(this.tabularRadioButton);
        Box fileTypeOption2Box = Box.createHorizontalBox();
        fileTypeOption2Box.setPreferredSize(new Dimension(300, 30));
        fileTypeOption2Box.add(this.covarianceRadioButton);
        fileTypeBox.add(fileTypeLabelBox);
        fileTypeBox.add(Box.createRigidArea(new Dimension(10, 1)));
        fileTypeBox.add(fileTypeOption1Box);
        fileTypeBox.add(fileTypeOption2Box);
        fileTypeBox.add(Box.createHorizontalGlue());
        basicSettingsBox.add(fileTypeBox);
        JSeparator separator1 = new JSeparator(0);
        separator1.setForeground(this.separatorColor);
        basicSettingsBox.add(separator1);
        Box metadataFileBox = Box.createHorizontalBox();
        Box metadataFileLabelBox = Box.createHorizontalBox();
        metadataFileLabelBox.setPreferredSize(this.labelSize);
        metadataFileLabelBox.add(new JLabel("Metadata JSON file:"));
        JLabel metadataFileLabelInfoIcon = new JLabel(new ImageIcon(ImageUtils.getImage(this, "information_small_white.png")));
        metadataFileLabelInfoIcon.setToolTipText("Metadata file is REQUIRED for observational and interventional data");
        metadataFileLabelBox.add(metadataFileLabelInfoIcon);
        this.metadataFileButton = new JButton("Load...");
        JLabel selectedMetadataFileName = new JLabel("No metadata file slected");
        this.metadataFileButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
            fileChooser.setCurrentDirectory(new File(sessionSaveLocation));
            fileChooser.setFileFilter(new FileNameExtensionFilter("*.json", "json"));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle("Load metadata JSON file");
            int _ret = fileChooser.showDialog(SwingUtilities.getWindowAncestor(this.metadataFileButton), "Choose");
            if (_ret == 1) {
                return;
            }
            this.metadataFile = fileChooser.getSelectedFile();
            selectedMetadataFileName.setText(this.metadataFile.getName());
        });
        Box metadataFileButtonBox = Box.createHorizontalBox();
        metadataFileButtonBox.setPreferredSize(new Dimension(680, 30));
        metadataFileButtonBox.add(this.metadataFileButton);
        metadataFileButtonBox.add(Box.createHorizontalStrut(10));
        metadataFileButtonBox.add(selectedMetadataFileName);
        metadataFileBox.add(metadataFileLabelBox);
        metadataFileBox.add(Box.createRigidArea(new Dimension(10, 1)));
        metadataFileBox.add(metadataFileButtonBox);
        metadataFileBox.add(Box.createHorizontalGlue());
        basicSettingsBox.add(metadataFileBox);
        JSeparator separator = new JSeparator(0);
        separator.setForeground(this.separatorColor);
        basicSettingsBox.add(separator);
        Box dataTypeBox = Box.createHorizontalBox();
        this.contRadioButton = new JRadioButton("Continuous");
        this.discRadioButton = new JRadioButton("Discrete");
        this.mixedRadioButton = new JRadioButton("Mixed");
        ButtonGroup dataTypeBtnGrp = new ButtonGroup();
        dataTypeBtnGrp.add(this.contRadioButton);
        dataTypeBtnGrp.add(this.discRadioButton);
        dataTypeBtnGrp.add(this.mixedRadioButton);
        this.contRadioButton.setSelected(true);
        Box dataTypeLabelBox = Box.createHorizontalBox();
        dataTypeLabelBox.setPreferredSize(this.labelSize);
        dataTypeLabelBox.add(new JLabel("Data type:"));
        Box dataTypeOption1Box = Box.createHorizontalBox();
        dataTypeOption1Box.setPreferredSize(new Dimension(160, 30));
        dataTypeOption1Box.add(this.contRadioButton);
        Box dataTypeOption2Box = Box.createHorizontalBox();
        dataTypeOption2Box.setPreferredSize(new Dimension(160, 30));
        dataTypeOption2Box.add(this.discRadioButton);
        Box dataTypeOption3Box = Box.createHorizontalBox();
        dataTypeOption3Box.setPreferredSize(new Dimension(320, 30));
        dataTypeOption3Box.add(this.mixedRadioButton);
        JLabel maxDiscCatLabel = new JLabel(", max discrete categories: ");
        JLabel maxDiscCatLabelInfoIcon = new JLabel(new ImageIcon(ImageUtils.getImage(this, "information_small_white.png")));
        maxDiscCatLabelInfoIcon.setToolTipText("Integral columns with up to N (specify here) distinct values are discrete.");
        this.maxNumOfDiscCategoriesField = new IntTextField(0, 3);
        this.maxNumOfDiscCategoriesField.setValue(0);
        this.maxNumOfDiscCategoriesField.setFilter((value, oldValue) -> {
            if (value >= 0) {
                return value;
            }
            return oldValue;
        });
        this.maxNumOfDiscCategoriesField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (!LoadDataSettings.this.mixedRadioButton.isSelected()) {
                    LoadDataSettings.this.mixedRadioButton.setSelected(true);
                }
            }
        });
        dataTypeOption3Box.add(maxDiscCatLabel);
        dataTypeOption3Box.add(maxDiscCatLabelInfoIcon);
        dataTypeOption3Box.add(this.maxNumOfDiscCategoriesField);
        dataTypeBox.add(dataTypeLabelBox);
        dataTypeBox.add(Box.createRigidArea(new Dimension(10, 1)));
        dataTypeBox.add(dataTypeOption1Box);
        dataTypeBox.add(dataTypeOption2Box);
        dataTypeBox.add(dataTypeOption3Box);
        dataTypeBox.add(Box.createHorizontalGlue());
        basicSettingsBox.add(dataTypeBox);
        JSeparator separator2 = new JSeparator(0);
        separator2.setForeground(this.separatorColor);
        basicSettingsBox.add(separator2);
        Box valueDelimiterBox = Box.createHorizontalBox();
        this.whitespaceDelimiterRadioButton = new JRadioButton("Whitespace");
        this.singleCharDelimiterRadioButton = new JRadioButton("Single character: ");
        String[] singleCharDelimiterOptions = new String[]{"Comma", "Colon", "Tab", "Space", "Semicolon", "Pipe"};
        this.singleCharDelimiterComboBox = new JComboBox<String>(singleCharDelimiterOptions);
        this.singleCharDelimiterComboBox.setMaximumSize(new Dimension(90, 30));
        this.singleCharDelimiterComboBox.setSelectedIndex(0);
        ButtonGroup delimiterBtnGrp = new ButtonGroup();
        delimiterBtnGrp.add(this.whitespaceDelimiterRadioButton);
        delimiterBtnGrp.add(this.singleCharDelimiterRadioButton);
        char inferredDelimiter = this.getInferredDelimiter(this.files.get(0));
        switch (inferredDelimiter) {
            case ',': {
                this.singleCharDelimiterRadioButton.setSelected(true);
                this.singleCharDelimiterComboBox.setSelectedItem("Comma");
                break;
            }
            case '\t': {
                this.singleCharDelimiterRadioButton.setSelected(true);
                this.singleCharDelimiterComboBox.setSelectedItem("Tab");
                break;
            }
            case ':': {
                this.singleCharDelimiterRadioButton.setSelected(true);
                this.singleCharDelimiterComboBox.setSelectedItem("Colon");
                break;
            }
            case ';': {
                this.singleCharDelimiterRadioButton.setSelected(true);
                this.singleCharDelimiterComboBox.setSelectedItem("Semicolon");
                break;
            }
            case '|': {
                this.singleCharDelimiterRadioButton.setSelected(true);
                this.singleCharDelimiterComboBox.setSelectedItem("Pipe");
                break;
            }
            default: {
                this.whitespaceDelimiterRadioButton.setSelected(true);
            }
        }
        this.singleCharDelimiterComboBox.addActionListener(actionEvent -> {
            if (!this.singleCharDelimiterRadioButton.isSelected()) {
                this.singleCharDelimiterRadioButton.setSelected(true);
            }
        });
        Box valueDelimiterLabelBox = Box.createHorizontalBox();
        valueDelimiterLabelBox.setPreferredSize(this.labelSize);
        valueDelimiterLabelBox.add(new JLabel("Value delimiter:"));
        JLabel valueDelimiterLabelInfoIcon = new JLabel(new ImageIcon(ImageUtils.getImage(this, "information_small_white.png")));
        valueDelimiterLabelInfoIcon.setToolTipText("Delimiter used to seperate the variable names and data values");
        valueDelimiterLabelBox.add(valueDelimiterLabelInfoIcon);
        Box valueDelimiterOption1Box = Box.createHorizontalBox();
        valueDelimiterOption1Box.setPreferredSize(new Dimension(160, 30));
        valueDelimiterOption1Box.add(this.whitespaceDelimiterRadioButton);
        Box valueDelimiterOption2Box = Box.createHorizontalBox();
        valueDelimiterOption2Box.setPreferredSize(new Dimension(300, 30));
        valueDelimiterOption2Box.add(this.singleCharDelimiterRadioButton);
        valueDelimiterOption2Box.add(this.singleCharDelimiterComboBox);
        valueDelimiterBox.add(valueDelimiterLabelBox);
        valueDelimiterBox.add(Box.createRigidArea(new Dimension(10, 1)));
        valueDelimiterBox.add(valueDelimiterOption1Box);
        valueDelimiterBox.add(valueDelimiterOption2Box);
        valueDelimiterBox.add(Box.createHorizontalGlue());
        basicSettingsBox.add(valueDelimiterBox);
        JSeparator separator3 = new JSeparator(0);
        separator3.setForeground(this.separatorColor);
        basicSettingsBox.add(separator3);
        String borderTitle = "Basic Settings (apply to all files)";
        basicSettingsBox.setBorder(new CompoundBorder(BorderFactory.createTitledBorder("Basic Settings (apply to all files)"), new EmptyBorder(5, 5, 5, 5)));
        return basicSettingsBox;
    }

    public Box advancedSettings() {
        Box advancedSettingsBox = Box.createVerticalBox();
        Box caseIdProvidedBox = Box.createHorizontalBox();
        this.idNoneRadioButton = new JRadioButton("None");
        this.idUnlabeledFirstColRadioButton = new JRadioButton("First column");
        this.idLabeledColRadioButton = new JRadioButton("Column labeled: ");
        this.idStringField = new StringTextField("", 6);
        ButtonGroup caseIdBtnGrp = new ButtonGroup();
        caseIdBtnGrp.add(this.idNoneRadioButton);
        caseIdBtnGrp.add(this.idUnlabeledFirstColRadioButton);
        caseIdBtnGrp.add(this.idLabeledColRadioButton);
        this.idNoneRadioButton.setSelected(true);
        this.idStringField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (LoadDataSettings.this.idStringField.isEnabled() && !LoadDataSettings.this.idLabeledColRadioButton.isSelected()) {
                    LoadDataSettings.this.idLabeledColRadioButton.setSelected(true);
                }
            }
        });
        Box caseIdProvidedLabelBox = Box.createHorizontalBox();
        caseIdProvidedLabelBox.setPreferredSize(this.labelSize);
        caseIdProvidedLabelBox.add(new JLabel("Case column to exclude/ignore:"));
        Box caseIdProvidedOption1Box = Box.createHorizontalBox();
        caseIdProvidedOption1Box.setPreferredSize(new Dimension(160, 30));
        caseIdProvidedOption1Box.add(this.idNoneRadioButton);
        Box caseIdProvidedOption2Box = Box.createHorizontalBox();
        caseIdProvidedOption2Box.setPreferredSize(new Dimension(160, 30));
        caseIdProvidedOption2Box.add(this.idUnlabeledFirstColRadioButton);
        Box caseIdProvidedOption3Box = Box.createHorizontalBox();
        caseIdProvidedOption3Box.setPreferredSize(new Dimension(300, 30));
        caseIdProvidedOption3Box.add(this.idLabeledColRadioButton);
        caseIdProvidedOption3Box.add(this.idStringField);
        caseIdProvidedBox.add(caseIdProvidedLabelBox);
        caseIdProvidedBox.add(Box.createRigidArea(new Dimension(10, 1)));
        caseIdProvidedBox.add(caseIdProvidedOption1Box);
        caseIdProvidedBox.add(caseIdProvidedOption2Box);
        caseIdProvidedBox.add(caseIdProvidedOption3Box);
        caseIdProvidedBox.add(Box.createHorizontalGlue());
        advancedSettingsBox.add(caseIdProvidedBox);
        JSeparator separator1 = new JSeparator(0);
        separator1.setForeground(this.separatorColor);
        advancedSettingsBox.add(separator1);
        Box commentMarkerBox = Box.createHorizontalBox();
        this.commentDoubleSlashRadioButton = new JRadioButton("//");
        this.commentPondRadioButton = new JRadioButton("#");
        this.commentOtherRadioButton = new JRadioButton("Other: ");
        ButtonGroup commentMarkerBtnGrp = new ButtonGroup();
        commentMarkerBtnGrp.add(this.commentDoubleSlashRadioButton);
        commentMarkerBtnGrp.add(this.commentPondRadioButton);
        commentMarkerBtnGrp.add(this.commentOtherRadioButton);
        this.commentStringField = new StringTextField("", 6);
        this.commentDoubleSlashRadioButton.setSelected(true);
        this.commentStringField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (!LoadDataSettings.this.commentOtherRadioButton.isSelected()) {
                    LoadDataSettings.this.commentOtherRadioButton.setSelected(true);
                }
            }
        });
        Box commentMarkerLabelBox = Box.createHorizontalBox();
        commentMarkerLabelBox.setPreferredSize(this.labelSize);
        commentMarkerLabelBox.add(new JLabel("Comment marker:"));
        JLabel commentMarkerLabelInfoIcon = new JLabel(new ImageIcon(ImageUtils.getImage(this, "information_small_white.png")));
        commentMarkerLabelInfoIcon.setToolTipText("Validation and data loading will ingnore the rows started with the comment marker.");
        commentMarkerLabelBox.add(commentMarkerLabelInfoIcon);
        Box commentMarkerOption1Box = Box.createHorizontalBox();
        commentMarkerOption1Box.setPreferredSize(new Dimension(160, 30));
        commentMarkerOption1Box.add(this.commentDoubleSlashRadioButton);
        Box commentMarkerOption2Box = Box.createHorizontalBox();
        commentMarkerOption2Box.setPreferredSize(new Dimension(160, 30));
        commentMarkerOption2Box.add(this.commentPondRadioButton);
        Box commentMarkerOption3Box = Box.createHorizontalBox();
        commentMarkerOption3Box.setPreferredSize(new Dimension(260, 30));
        commentMarkerOption3Box.add(this.commentOtherRadioButton);
        commentMarkerOption3Box.add(this.commentStringField);
        commentMarkerBox.add(commentMarkerLabelBox);
        commentMarkerBox.add(Box.createRigidArea(new Dimension(10, 1)));
        commentMarkerBox.add(commentMarkerOption1Box);
        commentMarkerBox.add(commentMarkerOption2Box);
        commentMarkerBox.add(commentMarkerOption3Box);
        commentMarkerBox.add(Box.createHorizontalGlue());
        advancedSettingsBox.add(commentMarkerBox);
        JSeparator separator2 = new JSeparator(0);
        separator2.setForeground(this.separatorColor);
        advancedSettingsBox.add(separator2);
        Box quoteCharBox = Box.createHorizontalBox();
        JRadioButton noneQuoteRadioButton = new JRadioButton("None");
        this.doubleQuoteRadioButton = new JRadioButton("\"");
        this.singleQuoteRadioButton = new JRadioButton("'");
        ButtonGroup quoteCharBtnGrp = new ButtonGroup();
        quoteCharBtnGrp.add(noneQuoteRadioButton);
        quoteCharBtnGrp.add(this.doubleQuoteRadioButton);
        quoteCharBtnGrp.add(this.singleQuoteRadioButton);
        noneQuoteRadioButton.setSelected(true);
        Box quoteCharLabelBox = Box.createHorizontalBox();
        quoteCharLabelBox.setPreferredSize(this.labelSize);
        quoteCharLabelBox.add(new JLabel("Quote character:"));
        JLabel quoteCharLabelInfoIcon = new JLabel(new ImageIcon(ImageUtils.getImage(this, "information_small_white.png")));
        quoteCharLabelInfoIcon.setToolTipText("If variable names or/and actual data are quoted, choose either single quote or double quotes. ");
        quoteCharLabelBox.add(quoteCharLabelInfoIcon);
        Box quoteCharOption1Box = Box.createHorizontalBox();
        quoteCharOption1Box.setPreferredSize(new Dimension(160, 30));
        quoteCharOption1Box.add(noneQuoteRadioButton);
        Box quoteCharOption2Box = Box.createHorizontalBox();
        quoteCharOption2Box.setPreferredSize(new Dimension(160, 30));
        quoteCharOption2Box.add(this.doubleQuoteRadioButton);
        Box quoteCharOption3Box = Box.createHorizontalBox();
        quoteCharOption3Box.setPreferredSize(new Dimension(260, 30));
        quoteCharOption3Box.add(this.singleQuoteRadioButton);
        quoteCharBox.add(quoteCharLabelBox);
        quoteCharBox.add(Box.createRigidArea(new Dimension(10, 1)));
        quoteCharBox.add(quoteCharOption1Box);
        quoteCharBox.add(quoteCharOption2Box);
        quoteCharBox.add(quoteCharOption3Box);
        quoteCharBox.add(Box.createHorizontalGlue());
        advancedSettingsBox.add(quoteCharBox);
        JSeparator separator3 = new JSeparator(0);
        separator3.setForeground(this.separatorColor);
        advancedSettingsBox.add(separator3);
        Box missingDataMarkerBox = Box.createHorizontalBox();
        this.missingValueStarRadioButton = new JRadioButton("*");
        this.missingValueQuestionRadioButton = new JRadioButton("?");
        JRadioButton missingValueOtherRadioButton = new JRadioButton("Other: ");
        ButtonGroup missingDataMarkerBtnGrp = new ButtonGroup();
        missingDataMarkerBtnGrp.add(this.missingValueStarRadioButton);
        missingDataMarkerBtnGrp.add(this.missingValueQuestionRadioButton);
        missingDataMarkerBtnGrp.add(missingValueOtherRadioButton);
        this.missingStringField = new StringTextField("", 6);
        this.missingStringField.setText("");
        this.missingValueStarRadioButton.setSelected(true);
        Box missingDataMarkerOption1Box = Box.createHorizontalBox();
        missingDataMarkerOption1Box.setPreferredSize(new Dimension(160, 30));
        missingDataMarkerOption1Box.add(this.missingValueStarRadioButton);
        Box missingDataMarkerOption2Box = Box.createHorizontalBox();
        missingDataMarkerOption2Box.setPreferredSize(new Dimension(160, 30));
        missingDataMarkerOption2Box.add(this.missingValueQuestionRadioButton);
        Box missingDataMarkerOption3Box = Box.createHorizontalBox();
        missingDataMarkerOption3Box.setPreferredSize(new Dimension(260, 30));
        missingDataMarkerOption3Box.add(missingValueOtherRadioButton);
        missingDataMarkerOption3Box.add(this.missingStringField);
        Box missingDataMarkerLabelBox = Box.createHorizontalBox();
        missingDataMarkerLabelBox.setPreferredSize(this.labelSize);
        missingDataMarkerLabelBox.add(new JLabel("Missing value marker:"));
        missingDataMarkerBox.add(missingDataMarkerLabelBox);
        missingDataMarkerBox.add(Box.createRigidArea(new Dimension(10, 1)));
        missingDataMarkerBox.add(missingDataMarkerOption1Box);
        missingDataMarkerBox.add(missingDataMarkerOption2Box);
        missingDataMarkerBox.add(missingDataMarkerOption3Box);
        missingDataMarkerBox.add(Box.createHorizontalGlue());
        advancedSettingsBox.add(missingDataMarkerBox);
        advancedSettingsBox.add(Box.createVerticalStrut(5));
        String borderTitle = "Advanced Settings (apply to all files)";
        advancedSettingsBox.setBorder(new CompoundBorder(BorderFactory.createTitledBorder("Advanced Settings (apply to all files)"), new EmptyBorder(5, 5, 5, 5)));
        return advancedSettingsBox;
    }

    private void setQuoteChar(DataReader dataReader) {
        if (this.doubleQuoteRadioButton.isSelected()) {
            dataReader.setQuoteCharacter('\"');
        }
        if (this.singleQuoteRadioButton.isSelected()) {
            dataReader.setQuoteCharacter('\'');
        }
    }

    private String getCommentMarker() {
        if (this.commentDoubleSlashRadioButton.isSelected()) {
            return "//";
        }
        if (this.commentPondRadioButton.isSelected()) {
            return "#";
        }
        if (this.commentOtherRadioButton.isSelected()) {
            return this.commentStringField.getText();
        }
        throw new IllegalArgumentException("Unexpected Comment Marker selection.");
    }

    private char getInferredDelimiter(File file) throws IOException {
        System.out.println("Infer demiliter for file: " + file.getName());
        int n = 20;
        int skip = 2;
        String comment = "//";
        int quoteCharacter = 34;
        char[] delims = new char[]{'\t', ' ', ',', ':', ';', '|'};
        return TextFileUtils.inferDelimiter(file, 20, 2, "//", '\"', delims);
    }

    private Delimiter getDelimiterType() {
        if (this.whitespaceDelimiterRadioButton.isSelected()) {
            return Delimiter.WHITESPACE;
        }
        if (this.singleCharDelimiterRadioButton.isSelected()) {
            String singleCharDelimiter;
            switch (singleCharDelimiter = Objects.requireNonNull(this.singleCharDelimiterComboBox.getSelectedItem()).toString()) {
                case "Comma": {
                    return Delimiter.COMMA;
                }
                case "Space": {
                    return Delimiter.SPACE;
                }
                case "Tab": {
                    return Delimiter.TAB;
                }
                case "Colon": {
                    return Delimiter.COLON;
                }
                case "Semicolon": {
                    return Delimiter.SEMICOLON;
                }
                case "Pipe": {
                    return Delimiter.PIPE;
                }
            }
            throw new IllegalArgumentException("Unexpected Value delimiter selection.");
        }
        throw new IllegalArgumentException("Unexpected Value delimiter selection.");
    }

    private boolean isVarNamesFirstRow() {
        if (this.firstRowVarNamesYesRadioButton.isSelected()) {
            return true;
        }
        if (this.firstRowVarNamesNoRadioButton.isSelected()) {
            return false;
        }
        throw new IllegalArgumentException("Unexpected Variable Names in First Row selection.");
    }

    public boolean isColumnLabelSpecified() {
        if (this.idLabeledColRadioButton.isSelected()) {
            return !this.idStringField.getText().isEmpty();
        }
        return true;
    }

    public boolean isOtherCommentMarkerSpecified() {
        if (this.commentOtherRadioButton.isSelected()) {
            return !this.commentStringField.getText().isEmpty();
        }
        return true;
    }

    private String getMissingDataMarker() {
        if (this.missingValueStarRadioButton.isSelected()) {
            return "*";
        }
        if (this.missingValueQuestionRadioButton.isSelected()) {
            return "?";
        }
        return this.missingStringField.getText();
    }

    private int getMaxNumOfDiscCategories() {
        return this.maxNumOfDiscCategoriesField.getValue();
    }

    private DataColumn[] generateTabularColumns(File file, Delimiter delimiter) throws IOException {
        DataColumn[] dataColumns = null;
        String commentMarker = this.getCommentMarker();
        TabularColumnFileReader columnFileReader = new TabularColumnFileReader(file.toPath(), delimiter);
        columnFileReader.setCommentMarker(commentMarker);
        this.setQuoteChar(columnFileReader);
        boolean isDiscrete = this.discRadioButton.isSelected();
        if (this.idNoneRadioButton.isSelected()) {
            dataColumns = columnFileReader.generateColumns(new int[0], isDiscrete);
        } else if (this.idUnlabeledFirstColRadioButton.isSelected()) {
            dataColumns = columnFileReader.generateColumns(new int[]{1}, isDiscrete);
        }
        return dataColumns;
    }

    public List<ValidationResult> validateDataWithSettings(File file) throws IOException {
        Delimiter delimiter = this.getDelimiterType();
        boolean hasHeader = this.isVarNamesFirstRow();
        String commentMarker = this.getCommentMarker();
        String missingDataMarker = this.getMissingDataMarker();
        if (this.tabularRadioButton.isSelected()) {
            DataColumn[] dataColumns;
            List<Object> tabularColumnValidationResults = new LinkedList();
            if (!hasHeader) {
                dataColumns = this.generateTabularColumns(file, delimiter);
            } else {
                TabularColumnFileValidation tabularColumnValidation = new TabularColumnFileValidation(file.toPath(), delimiter);
                tabularColumnValidation.setCommentMarker(commentMarker);
                this.setQuoteChar(tabularColumnValidation);
                if (this.idNoneRadioButton.isSelected()) {
                    tabularColumnValidationResults = tabularColumnValidation.validate();
                } else if (this.idUnlabeledFirstColRadioButton.isSelected()) {
                    tabularColumnValidationResults = tabularColumnValidation.validate(new int[]{1});
                } else if (this.idLabeledColRadioButton.isSelected() && !this.idStringField.getText().isEmpty()) {
                    tabularColumnValidationResults = tabularColumnValidation.validate(new HashSet<String>(Collections.singletonList(this.idStringField.getText())));
                }
                dataColumns = this.readInTabularColumns(file);
            }
            LinkedList<ValidationResult> validationInfos = new LinkedList<ValidationResult>();
            LinkedList<ValidationResult> validationWarnings = new LinkedList<ValidationResult>();
            LinkedList<ValidationResult> validationErrors = new LinkedList<ValidationResult>();
            block4: for (ValidationResult result : tabularColumnValidationResults) {
                switch (result.getCode()) {
                    case INFO: {
                        validationInfos.add(result);
                        continue block4;
                    }
                    case WARNING: {
                        validationWarnings.add(result);
                        continue block4;
                    }
                }
                validationErrors.add(result);
            }
            if (validationErrors.size() > 0) {
                return tabularColumnValidationResults;
            }
            if (this.mixedRadioButton.isSelected()) {
                TabularDataFileReader dataReader = new TabularDataFileReader(file.toPath(), delimiter);
                dataReader.setCommentMarker(commentMarker);
                dataReader.setMissingDataMarker(missingDataMarker);
                this.setQuoteChar(dataReader);
                dataReader.determineDiscreteDataColumns(dataColumns, this.getMaxNumOfDiscCategories(), hasHeader);
            }
            if (this.metadataFile != null) {
                MetadataFileReader metadataReader = new MetadataFileReader(this.metadataFile.toPath());
                this.metadata = metadataReader.read();
                dataColumns = DataColumns.update(dataColumns, this.metadata);
            }
            TabularDataFileValidation tabularDataValidation = new TabularDataFileValidation(file.toPath(), delimiter);
            tabularDataValidation.setCommentMarker(commentMarker);
            this.setQuoteChar(tabularDataValidation);
            tabularDataValidation.setMissingDataMarker(missingDataMarker);
            return tabularDataValidation.validate(dataColumns, hasHeader);
        }
        if (this.covarianceRadioButton.isSelected()) {
            LowerCovarianceDataFileValidation covarianceValidation = new LowerCovarianceDataFileValidation(file.toPath(), delimiter);
            covarianceValidation.setCommentMarker(commentMarker);
            this.setQuoteChar(covarianceValidation);
            return covarianceValidation.validate();
        }
        throw new UnsupportedOperationException("You can only choose either tabular data or covariance data!");
    }

    private DataColumn[] readInTabularColumns(File file) throws IOException {
        DataColumn[] dataColumns = null;
        Delimiter delimiter = this.getDelimiterType();
        String commentMarker = this.getCommentMarker();
        TabularColumnFileReader columnReader = new TabularColumnFileReader(file.toPath(), delimiter);
        columnReader.setCommentMarker(commentMarker);
        this.setQuoteChar(columnReader);
        boolean isDiscrete = this.discRadioButton.isSelected();
        if (this.idNoneRadioButton.isSelected()) {
            dataColumns = columnReader.readInDataColumns(new int[0], isDiscrete);
        } else if (this.idUnlabeledFirstColRadioButton.isSelected()) {
            dataColumns = columnReader.readInDataColumns(new int[]{1}, isDiscrete);
        } else if (this.idLabeledColRadioButton.isSelected() && !this.idStringField.getText().isEmpty()) {
            dataColumns = columnReader.readInDataColumns(new HashSet<String>(Collections.singletonList(this.idStringField.getText())), isDiscrete);
        }
        return dataColumns;
    }

    public DataModel loadDataWithSettings(File file) throws IOException {
        DataModel dataModel;
        Delimiter delimiter = this.getDelimiterType();
        boolean hasHeader = this.isVarNamesFirstRow();
        String commentMarker = this.getCommentMarker();
        String missingDataMarker = this.getMissingDataMarker();
        if (this.tabularRadioButton.isSelected()) {
            Data data;
            DataColumn[] dataColumns = !hasHeader ? this.generateTabularColumns(file, delimiter) : this.readInTabularColumns(file);
            TabularDataFileReader dataReader = new TabularDataFileReader(file.toPath(), delimiter);
            dataReader.setCommentMarker(commentMarker);
            dataReader.setMissingDataMarker(missingDataMarker);
            this.setQuoteChar(dataReader);
            if (this.mixedRadioButton.isSelected()) {
                dataReader.determineDiscreteDataColumns(dataColumns, this.getMaxNumOfDiscCategories(), hasHeader);
            }
            if (this.metadataFile != null) {
                MetadataFileReader metadataReader = new MetadataFileReader(this.metadataFile.toPath());
                this.metadata = metadataReader.read();
                dataColumns = DataColumns.update(dataColumns, this.metadata);
            }
            if (this.metadata != null) {
                data = dataReader.read(dataColumns, hasHeader, this.metadata);
                dataModel = DataConvertUtils.toDataModel(data, this.metadata);
            } else {
                data = dataReader.read(dataColumns, hasHeader);
                dataModel = DataConvertUtils.toDataModel(data);
            }
        } else if (this.covarianceRadioButton.isSelected()) {
            LowerCovarianceDataFileReader dataFileReader = new LowerCovarianceDataFileReader(file.toPath(), delimiter);
            dataFileReader.setCommentMarker(commentMarker);
            this.setQuoteChar(dataFileReader);
            CovarianceData covarianceData = dataFileReader.readInData();
            dataModel = DataConvertUtils.toDataModel(covarianceData);
        } else {
            throw new UnsupportedOperationException("Unsupported selection of File Type!");
        }
        return dataModel;
    }
}

