/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetradapp.editor.GraphEditable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

class LoadGraphPcalg
extends AbstractAction {
    private final GraphEditable graphEditable;

    public LoadGraphPcalg(GraphEditable graphEditable, String title) {
        super(title);
        if (graphEditable == null) {
            throw new NullPointerException("Component must not be null.");
        }
        this.graphEditable = graphEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = LoadGraphPcalg.getJFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.showOpenDialog((Component)((Object)this.graphEditable));
        File file = chooser.getSelectedFile();
        if (file == null) {
            System.out.println("File was null.");
            return;
        }
        Preferences.userRoot().put("fileSaveLocation", file.getParent());
        Graph graph = GraphPersistence.loadGraphPcalg(file);
        LayoutUtil.circleLayout(graph, 200, 200, 150);
        this.graphEditable.setGraph(graph);
    }

    private static JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }
}

