/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LogParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params;

    @Override
    public void setParams(Parameters params) {
        this.params = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        this.buildGui();
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private void buildGui() {
        this.setLayout(new BorderLayout());
        DoubleTextField aField = new DoubleTextField(this.params.getDouble("a", 10.0), 6, NumberFormatUtil.getInstance().getNumberFormat());
        aField.setFilter((value, oldValue) -> {
            try {
                this.params.set("a", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        IntTextField baseField = new IntTextField(this.params.getInt("base", 0), 4);
        baseField.setFilter((value, oldValue) -> {
            try {
                this.params.set("base", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("<html>The input dataset will be logarithmically transformed by applying f(x) = ln(a + x) to each data point x.<br> Can also 'unlog' the data i.e., apply g(x) = exp(x) - a, or override the base"));
        Box b9 = Box.createHorizontalBox();
        b9.add(Box.createHorizontalGlue());
        b9.add(new JLabel("<html> base (use 0 for natural log and base <i>e</i>): </html>"));
        b9.add(baseField);
        Box b7 = Box.createHorizontalBox();
        b7.add(Box.createHorizontalGlue());
        b7.add(new JLabel("<html><i>a =  </i></html>"));
        b7.add(aField);
        JCheckBox unlog = new JCheckBox();
        unlog.setSelected(this.params.getBoolean("unlog", false));
        unlog.addActionListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.params.set("unlog", (Object)box.isSelected());
        });
        Box b8 = Box.createHorizontalBox();
        b8.add(Box.createHorizontalGlue());
        b8.add(new JLabel("<html>Unlog: </html>"));
        b8.add(unlog);
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        b1.add(b7);
        b1.add(Box.createHorizontalGlue());
        b1.add(b8);
        b1.add(Box.createHorizontalGlue());
        b1.add(b9);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }
}

