/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.LogisticRegression;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.RegressionParamsEditorPanel;
import edu.cmu.tetradapp.model.LogisticRegressionRunner;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class LogisticRegressionEditor
extends JPanel {
    private static final long serialVersionUID = 7779226528390174L;
    private final JTextArea modelParameters;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public LogisticRegressionEditor(LogisticRegressionRunner regressionRunner) {
        DataSet dataSet = (DataSet)regressionRunner.getDataModel();
        for (Node node : dataSet.getVariables()) {
            DiscreteVariable v;
            if (!(node instanceof DiscreteVariable) || (v = (DiscreteVariable)node).getNumCategories() == 2) continue;
            throw new IllegalArgumentException("Logistic regression requires a dataset in which all variables are either continuous or binary.");
        }
        GraphWorkbench workbench = new GraphWorkbench();
        this.modelParameters = new JTextArea();
        JButton executeButton = new JButton("Execute");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(600, 400));
        tabbedPane.add("Model", new JScrollPane(this.modelParameters));
        tabbedPane.add("Output Graph", new JScrollPane(workbench));
        Parameters params = regressionRunner.getParams();
        RegressionParamsEditorPanel paramsPanel = new RegressionParamsEditorPanel(regressionRunner, params, regressionRunner.getDataModel(), true);
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(paramsPanel);
        b1.add(Box.createHorizontalStrut(5));
        b1.add(tabbedPane);
        b.add(b1);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(executeButton);
        b.add(buttonPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
        int numModels = regressionRunner.getNumModels();
        if (numModels > 1) {
            JComboBox<Integer> comp = new JComboBox<Integer>();
            for (int i = 0; i < numModels; ++i) {
                comp.addItem(i + 1);
            }
            comp.addActionListener(e -> {
                Object selectedItem = comp.getSelectedItem();
                if (selectedItem instanceof Integer) {
                    regressionRunner.setModelIndex((Integer)selectedItem - 1);
                }
            });
            comp.setMaximumSize(comp.getPreferredSize());
            Box c = Box.createHorizontalBox();
            c.add(new JLabel("Using model"));
            c.add(comp);
            c.add(new JLabel("from "));
            c.add(new JLabel(regressionRunner.getModelSourceName()));
            c.add(Box.createHorizontalGlue());
            this.add((Component)c, "North");
        }
        executeButton.addActionListener(e -> {
            regressionRunner.setAlpha(paramsPanel.getParams().getDouble("alpha", 0.001));
            regressionRunner.execute();
            this.print(regressionRunner.getResult(), regressionRunner.getAlpha());
            Graph outGraph = regressionRunner.getOutGraph();
            LayoutUtil.circleLayout(outGraph, 200, 200, 150);
            LayoutUtil.fruchtermanReingoldLayout(outGraph);
            workbench.setGraph(outGraph);
            TetradLogger.getInstance().log("result", this.modelParameters.getText());
        });
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private void print(LogisticRegression.Result result, double alpha) {
        int i;
        if (result == null) {
            return;
        }
        StringBuilder text = new StringBuilder(result.getNy0() + " cases have " + result.getTarget() + " = 0; ");
        text.append(result.getNy1()).append(" cases have ").append(result.getTarget()).append(" = 1.\n\n");
        text.append("Var\tAvg\tSD\n");
        for (i = 1; i <= result.getNumRegressors(); ++i) {
            text.append(result.getRegressorNames().get(i - 1)).append("\t");
            text.append(this.nf.format(result.getxMeans()[i])).append("\t");
            text.append(this.nf.format(result.getxStdDevs()[i])).append("\n");
        }
        text.append("\nCoefficients and Standard Errors:\n");
        text.append("Var\tCoeff.\tStdErr\tProb.\tSig.\n");
        for (i = 1; i <= result.getNumRegressors(); ++i) {
            text.append(result.getRegressorNames().get(i - 1)).append("\t");
            text.append(this.nf.format(result.getCoefs()[i])).append("\t");
            text.append(this.nf.format(result.getStdErrs()[i])).append("\t");
            text.append(this.nf.format(result.getProbs()[i])).append("\t");
            if (result.getProbs()[i] < alpha) {
                text.append("*\n");
                continue;
            }
            text.append("\n");
        }
        text.append("\n\nIntercept = ").append(this.nf.format(result.getIntercept())).append("\n");
        this.modelParameters.setText(text.toString());
    }
}

