/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphFileMenu;
import edu.cmu.tetradapp.editor.IndTestMenuItems;
import edu.cmu.tetradapp.editor.IndTestTypeSetter;
import edu.cmu.tetradapp.editor.SaveDataAction;
import edu.cmu.tetradapp.editor.TabularDataJTable;
import edu.cmu.tetradapp.model.MarkovBlanketSearchRunner;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;

public class MarkovBlanketSearchEditor
extends JPanel
implements GraphEditable,
IndTestTypeSetter {
    private final MarkovBlanketSearchRunner algorithmRunner;
    private final JButton executeButton = new JButton();
    private JScrollPane workbenchScroll;
    private final TabularDataJTable table;
    private boolean knowledgeMessageShown;

    public MarkovBlanketSearchEditor(MarkovBlanketSearchRunner algorithmRunner) {
        if (algorithmRunner == null) {
            throw new NullPointerException();
        }
        this.algorithmRunner = algorithmRunner;
        Parameters params = algorithmRunner.getParams();
        List<String> vars = algorithmRunner.getSource().getVariableNames();
        if (params.getString("targetName", null) == null && !vars.isEmpty()) {
            params.set("targetName", vars.get(0));
        }
        DataSet data = algorithmRunner.getDataModelForMarkovBlanket() == null ? algorithmRunner.getSource() : algorithmRunner.getDataModelForMarkovBlanket();
        this.table = new TabularDataJTable(data);
        this.table.setEditable(false);
        this.table.setTableHeader(null);
        this.setup();
    }

    @Override
    public DataModel getDataModel() {
        if (this.algorithmRunner.getDataModelForMarkovBlanket() != null) {
            return this.algorithmRunner.getDataModelForMarkovBlanket();
        }
        return this.algorithmRunner.getSource();
    }

    @Override
    public Object getSourceGraph() {
        return this.getParams().get("sourceGraph", null);
    }

    private void execute() {
        Window owner = (Window)this.getTopLevelAncestor();
        WatchedProcess process = new WatchedProcess(owner){

            @Override
            public void watch() {
                Knowledge knowledge;
                MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(false);
                this.setErrorMessage(null);
                if (!MarkovBlanketSearchEditor.this.knowledgeMessageShown && !(knowledge = (Knowledge)MarkovBlanketSearchEditor.this.getAlgorithmRunner().getParams().get("knowledge", new Knowledge())).isEmpty()) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using previously set knowledge. (To edit, use the Knowledge menu.)");
                    MarkovBlanketSearchEditor.this.knowledgeMessageShown = true;
                }
                try {
                    MarkovBlanketSearchEditor.this.getAlgorithmRunner().execute();
                }
                catch (Exception e) {
                    CharArrayWriter writer1 = new CharArrayWriter();
                    PrintWriter writer2 = new PrintWriter(writer1);
                    e.printStackTrace(writer2);
                    String message = writer1.toString();
                    writer2.close();
                    e.printStackTrace(System.out);
                    TetradLogger.getInstance().error(message);
                    String messageString = e.getMessage();
                    if (e.getCause() != null) {
                        messageString = e.getCause().getMessage();
                    }
                    if (messageString == null) {
                        messageString = message;
                    }
                    this.setErrorMessage(messageString);
                    MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(true);
                    throw new RuntimeException(e);
                }
                MarkovBlanketSearchEditor.this.setLabel();
                DataSet modelForMarkovBlanket = MarkovBlanketSearchEditor.this.algorithmRunner.getDataModelForMarkovBlanket();
                if (modelForMarkovBlanket != null) {
                    MarkovBlanketSearchEditor.this.table.setDataSet(modelForMarkovBlanket);
                }
                MarkovBlanketSearchEditor.this.table.repaint();
                MarkovBlanketSearchEditor.this.getExecuteButton().setEnabled(true);
            }
        };
        Thread watcher = new Thread(() -> {
            try {
                do {
                    Thread.sleep(300L);
                } while (process.isAlive());
                this.getExecuteButton().setEnabled(true);
                return;
            }
            catch (InterruptedException e) {
                this.getExecuteButton().setEnabled(true);
                return;
            }
        });
        watcher.start();
    }

    private void setLabel() {
        this.getWorkbenchScroll().setBorder(new TitledBorder(this.algorithmRunner.getSearchName()));
    }

    private JButton getExecuteButton() {
        return this.executeButton;
    }

    private MarkovBlanketSearchRunner getAlgorithmRunner() {
        return this.algorithmRunner;
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbar(), "West");
        this.add((Component)this.workbenchScroll(), "Center");
        this.add((Component)this.menuBar(), "North");
    }

    private JPanel createToolbar() {
        JPanel toolbar = new JPanel();
        this.getExecuteButton().setText("Execute*");
        this.getExecuteButton().addActionListener(e -> this.execute());
        Box b1 = Box.createVerticalBox();
        b1.add(this.getParamEditor());
        b1.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(this.getExecuteButton());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(10));
        Box b3 = Box.createHorizontalBox();
        JLabel label = new JLabel("<html>*Please note that some<br>searches may take a<br>long time to complete.</html>");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBorder(new TitledBorder(""));
        b3.add(label);
        b1.add(b3);
        toolbar.add(b1);
        return toolbar;
    }

    private JComponent getParamEditor() {
        Box box = Box.createVerticalBox();
        JComboBox<Object> comboBox = new JComboBox<Object>(this.algorithmRunner.getSource().getVariableNames().toArray());
        comboBox.addItemListener(e -> {
            String s = (String)e.getItem();
            if (s != null) {
                this.algorithmRunner.getParams().set("targetName", s);
            }
        });
        DoubleTextField alphaField = new DoubleTextField(this.getParams().getDouble("alpha", 0.001), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter((value, oldValue) -> {
            try {
                this.getParams().set("alpha", (Object)0.001);
                Preferences.userRoot().putDouble("alpha", this.getParams().getDouble("alpha", 0.001));
                return value;
            }
            catch (Exception e) {
                return oldValue;
            }
        });
        box.add(comboBox);
        box.add(Box.createVerticalStrut(4));
        box.add(this.createLabeledComponent(alphaField));
        box.setBorder(new TitledBorder("Parameters"));
        return box;
    }

    private Box createLabeledComponent(JComponent comp) {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Alpha"));
        box.add(Box.createHorizontalStrut(5));
        box.add(comp);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Parameters getParams() {
        return this.algorithmRunner.getParams();
    }

    private JScrollPane workbenchScroll() {
        this.workbenchScroll = new JScrollPane(this.table);
        this.workbenchScroll.setPreferredSize(new Dimension(500, 500));
        this.setLabel();
        return this.workbenchScroll;
    }

    private JMenuBar menuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(new JMenuItem(new SaveDataAction(this)));
        file.add(new GraphFileMenu(this, this.getWorkbench(), false));
        JMenu edit = new JMenu("Edit");
        JMenuItem copyCells = new JMenuItem("Copy Cells");
        copyCells.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        copyCells.addActionListener(e -> {
            Action copyAction = TransferHandler.getCopyAction();
            ActionEvent actionEvent = new ActionEvent(this.table, 1001, "copy");
            copyAction.actionPerformed(actionEvent);
        });
        edit.add(copyCells);
        menuBar.add(file);
        menuBar.add(edit);
        JMenu independence = new JMenu("Independence");
        if (this.algorithmRunner.getSource().isContinuous()) {
            IndTestMenuItems.addContinuousTestMenuItems(independence, this);
            menuBar.add(independence);
        } else if (this.algorithmRunner.getSource().isDiscrete()) {
            IndTestMenuItems.addDiscreteTestMenuItems(independence, this);
            menuBar.add(independence);
        }
        menuBar.add(independence);
        return menuBar;
    }

    private JScrollPane getWorkbenchScroll() {
        return this.workbenchScroll;
    }

    @Override
    public List getSelectedModelComponents() {
        throw new UnsupportedOperationException("Cannot return selected components.");
    }

    @Override
    public void pasteSubsession(List<Object> sessionElements, Point upperLeft) {
        throw new UnsupportedOperationException("Cannot paste subsessions on a search editor.");
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return null;
    }

    @Override
    public void setGraph(Graph g) {
        throw new UnsupportedOperationException("Cannot set the graph on a search editor.");
    }

    @Override
    public Graph getGraph() {
        if (this.getWorkbench().getGraph() != null) {
            return this.getWorkbench().getGraph();
        }
        return new EdgeListGraph();
    }

    @Override
    public void setTestType(IndTestType testType) {
        this.getParams().set("indTestType", (Object)testType);
    }

    @Override
    public IndTestType getTestType() {
        return (IndTestType)this.getParams().get("indTestType", IndTestType.FISHER_Z);
    }
}

