/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.Histogram;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.HistogramView;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.MarkovCheckIndTestModel;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.apache.commons.math3.util.FastMath;

public class MarkovCheckEditor
extends JPanel {
    private Graph dag;
    private final MarkovCheckIndTestModel model;
    private AbstractTableModel tableModelIndep;
    private AbstractTableModel tableModelDep;
    private int sortDir;
    private int lastSortCol;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private boolean parallelized = true;
    private final IndependenceTest test;
    private double fractionDependentIndep = Double.NaN;
    private double fractionDependentDep = Double.NaN;
    private JLabel fractionDepLabelIndep;
    private JLabel fractionDepLabelDep;

    public MarkovCheckEditor(MarkovCheckIndTestModel model) {
        if (model == null) {
            throw new NullPointerException("Expecting a model");
        }
        IndTestProducer indTestProducer = model.getIndTestProducer();
        this.test = indTestProducer.getIndependenceTest();
        this.model = model;
        Graph sourceGraph = model.getGraph();
        List<Node> variables = this.test.getVariables();
        ArrayList<Node> newVars = new ArrayList<Node>();
        for (Node node : variables) {
            if (sourceGraph.getNode(node.getName()) == null) continue;
            newVars.add(node);
        }
        sourceGraph = GraphUtils.replaceNodes(sourceGraph, newVars);
        for (Edge edge : sourceGraph.getEdges()) {
            if (edge.isDirected()) continue;
            throw new IllegalArgumentException("At least this edge in the source graph is not directed: " + edge);
        }
        ArrayList<Node> missingVars = new ArrayList<Node>();
        for (Node w : sourceGraph.getNodes()) {
            if (this.test.getVariable(w.getName()) != null) continue;
            missingVars.add(w);
            if (missingVars.size() < 5) continue;
            break;
        }
        if (!missingVars.isEmpty()) {
            throw new IllegalArgumentException("At least these variables in the DAG are missing from the data:\n    " + missingVars);
        }
        if (sourceGraph.paths().existsDirectedCycle()) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp().getTopLevelAncestor(), "That graph is not a DAG. For linear models, this is OK, but for nonlinear models,\nyou would either have to form the \u201ccollapsed graph\u201d or use sigma-separation.");
        }
        this.dag = sourceGraph;
        model.setVars(this.dag.getNodeNames());
        JPanel jPanel = this.buildGuiIndep();
        JPanel dep = this.buildGuiDep();
        JTabbedPane pane = new JTabbedPane();
        pane.addTab("Should be Independent", jPanel);
        pane.addTab("Should be Dependent", dep);
        this.add(pane);
    }

    private JPanel buildGuiDep() {
        JButton list = new JButton("CHECK");
        list.setFont(new Font("Dialog", 1, 14));
        list.addActionListener(e -> this.generateResults(false));
        JButton clear = new JButton("Clear");
        clear.setFont(new Font("Dialog", 0, 14));
        clear.addActionListener(e -> {
            this.model.getResults(false).clear();
            this.revalidate();
            this.repaint();
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Checks whether X ~_||_ Y | parents(X) for Y in desc(X)"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        Box b2a = Box.createHorizontalBox();
        b2a.add(new JLabel("Test: "));
        b2a.add(new JLabel(this.getIndependenceTest().toString()));
        b2a.add(Box.createHorizontalGlue());
        b1.add(b2a);
        b1.add(Box.createVerticalStrut(5));
        this.tableModelDep = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Index";
                }
                if (column == 1) {
                    return "Fact";
                }
                if (column == 2) {
                    return "Result";
                }
                if (column == 3) {
                    return "P-value";
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public int getRowCount() {
                return MarkovCheckEditor.this.model.getResults(false).size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex > MarkovCheckEditor.this.model.getResults(false).size()) {
                    return null;
                }
                if (columnIndex == 0) {
                    return rowIndex + 1;
                }
                if (columnIndex == 1) {
                    return MarkovCheckEditor.this.model.getResults(false).get(rowIndex).getFact();
                }
                IndependenceResult result = MarkovCheckEditor.this.model.getResults(false).get(rowIndex);
                if (columnIndex == 2) {
                    if (MarkovCheckEditor.this.getIndependenceTest() instanceof IndTestDSep) {
                        if (result.independent()) {
                            return "D-SEPARATED";
                        }
                        return "d-connected";
                    }
                    if (result.independent()) {
                        return "INDEPENDENT";
                    }
                    return "dependent";
                }
                if (columnIndex == 3) {
                    return MarkovCheckEditor.this.nf.format(result.getPValue());
                }
                return null;
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Number.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                return Number.class;
            }
        };
        JTable table = new JTable(this.tableModelDep);
        table.getColumnModel().getColumn(0).setMinWidth(40);
        table.getColumnModel().getColumn(0).setMaxWidth(40);
        table.getColumnModel().getColumn(1).setMinWidth(200);
        table.getColumnModel().getColumn(1).setCellRenderer(new Renderer());
        table.getColumnModel().getColumn(2).setMinWidth(100);
        table.getColumnModel().getColumn(2).setMaxWidth(100);
        table.getColumnModel().getColumn(3).setMinWidth(100);
        table.getColumnModel().getColumn(3).setMaxWidth(100);
        table.getColumnModel().getColumn(2).setCellRenderer(new Renderer());
        table.getColumnModel().getColumn(3).setCellRenderer(new Renderer());
        JTableHeader header = table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTableHeader header = (JTableHeader)e.getSource();
                Point point = e.getPoint();
                int col = header.columnAtPoint(point);
                int sortCol = header.getTable().convertColumnIndexToModel(col);
                MarkovCheckEditor.this.sortByColumn(sortCol, false);
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(400, 400));
        b1.add(scroll);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createGlue());
        b4.add(Box.createHorizontalStrut(10));
        JButton showHistogram = new JButton("Show P-Value Histogram");
        showHistogram.setFont(new Font("Dialog", 0, 14));
        showHistogram.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JPanel component = MarkovCheckEditor.this.createHistogramPanel(false);
                EditorWindow editorWindow = new EditorWindow(component, "Histogram", "Close", false, MarkovCheckEditor.this);
                DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                editorWindow.pack();
                editorWindow.setVisible(true);
            }
        });
        b4.add(Box.createHorizontalGlue());
        b4.add(clear);
        b4.add(list);
        b4.add(showHistogram);
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        Box b5 = Box.createHorizontalBox();
        b5.add(Box.createGlue());
        int dependent = 0;
        for (IndependenceResult result : this.model.getResults(false)) {
            if (!result.dependent() || Double.isNaN(result.getPValue())) continue;
            ++dependent;
        }
        this.fractionDependentDep = (double)dependent / (double)this.model.getResults(false).size();
        this.fractionDepLabelDep = new JLabel("% dependent = " + (Double.isNaN(this.fractionDependentDep) ? "-" : NumberFormatUtil.getInstance().getNumberFormat().format(this.fractionDependentDep)));
        b5.add(this.fractionDepLabelDep);
        b1.add(b5);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)b1, "Center");
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private JPanel buildGuiIndep() {
        JButton list = new JButton("CHECK");
        list.setFont(new Font("Dialog", 1, 14));
        list.addActionListener(e -> this.generateResults(true));
        JButton clear = new JButton("Clear");
        clear.setFont(new Font("Dialog", 0, 14));
        clear.addActionListener(e -> {
            this.model.getResults(true).clear();
            this.revalidate();
            this.repaint();
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Checks whether X _||_ Y | parents(X) for Y not in (desc(X) U parentx(X))"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        Box b2a = Box.createHorizontalBox();
        b2a.add(new JLabel("Test: "));
        b2a.add(new JLabel(this.getIndependenceTest().toString()));
        b2a.add(Box.createHorizontalGlue());
        b1.add(b2a);
        b1.add(Box.createVerticalStrut(5));
        this.tableModelIndep = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Index";
                }
                if (column == 1) {
                    return "Fact";
                }
                if (column == 2) {
                    return "Result";
                }
                if (column == 3) {
                    return "P-value";
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public int getRowCount() {
                return MarkovCheckEditor.this.model.getResults(true).size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex > MarkovCheckEditor.this.model.getResults(true).size()) {
                    return null;
                }
                if (columnIndex == 0) {
                    return rowIndex + 1;
                }
                if (columnIndex == 1) {
                    return MarkovCheckEditor.this.model.getResults(true).get(rowIndex).getFact();
                }
                IndependenceResult result = MarkovCheckEditor.this.model.getResults(true).get(rowIndex);
                if (columnIndex == 2) {
                    if (MarkovCheckEditor.this.getIndependenceTest() instanceof IndTestDSep) {
                        if (result.independent()) {
                            return "D-SEPARATED";
                        }
                        return "d-connected";
                    }
                    if (result.independent()) {
                        return "INDEPENDENT";
                    }
                    return "dependent";
                }
                if (columnIndex == 3) {
                    return MarkovCheckEditor.this.nf.format(result.getPValue());
                }
                return null;
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Number.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                return Number.class;
            }
        };
        JTable table = new JTable(this.tableModelIndep);
        table.getColumnModel().getColumn(0).setMinWidth(40);
        table.getColumnModel().getColumn(0).setMaxWidth(40);
        table.getColumnModel().getColumn(1).setMinWidth(200);
        table.getColumnModel().getColumn(1).setCellRenderer(new Renderer());
        table.getColumnModel().getColumn(2).setMinWidth(100);
        table.getColumnModel().getColumn(2).setMaxWidth(100);
        table.getColumnModel().getColumn(3).setMinWidth(100);
        table.getColumnModel().getColumn(3).setMaxWidth(100);
        table.getColumnModel().getColumn(2).setCellRenderer(new Renderer());
        table.getColumnModel().getColumn(3).setCellRenderer(new Renderer());
        JTableHeader header = table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTableHeader header = (JTableHeader)e.getSource();
                Point point = e.getPoint();
                int col = header.columnAtPoint(point);
                int sortCol = header.getTable().convertColumnIndexToModel(col);
                MarkovCheckEditor.this.sortByColumn(sortCol, true);
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(400, 400));
        b1.add(scroll);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createGlue());
        b4.add(Box.createHorizontalStrut(10));
        JButton showHistogram = new JButton("Show P-Value Histogram");
        showHistogram.setFont(new Font("Dialog", 0, 14));
        showHistogram.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JPanel component = MarkovCheckEditor.this.createHistogramPanel(true);
                EditorWindow editorWindow = new EditorWindow(component, "Histogram", "Close", false, MarkovCheckEditor.this);
                DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                editorWindow.pack();
                editorWindow.setVisible(true);
            }
        });
        b4.add(Box.createHorizontalGlue());
        b4.add(clear);
        b4.add(list);
        b4.add(showHistogram);
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        Box b5 = Box.createHorizontalBox();
        b5.add(Box.createGlue());
        int dependent = 0;
        for (IndependenceResult result : this.model.getResults(true)) {
            if (!result.dependent() || Double.isNaN(result.getPValue())) continue;
            ++dependent;
        }
        this.fractionDependentIndep = (double)dependent / (double)this.model.getResults(true).size();
        this.fractionDepLabelIndep = new JLabel("% dependent = " + (Double.isNaN(this.fractionDependentIndep) ? "-" : NumberFormatUtil.getInstance().getNumberFormat().format(this.fractionDependentIndep)));
        b5.add(this.fractionDepLabelIndep);
        b1.add(b5);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)b1, "Center");
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private void sortByColumn(int sortCol, boolean indep) {
        if (sortCol == this.getLastSortCol()) {
            this.setSortDir(-1 * this.getSortDir());
        } else {
            this.setSortDir(1);
        }
        this.setLastSortCol(sortCol);
        this.model.getResults(indep).sort(Comparator.comparing(IndependenceResult::getFact));
        if (indep) {
            this.tableModelIndep.fireTableDataChanged();
        } else {
            this.tableModelDep.fireTableDataChanged();
        }
    }

    private void generateResults(final boolean indep) {
        Window owner = (Window)JOptionUtils.centeringComp().getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                if (MarkovCheckEditor.this.model.getVars().size() < 2) {
                    if (indep) {
                        MarkovCheckEditor.this.tableModelIndep.fireTableDataChanged();
                    } else {
                        MarkovCheckEditor.this.tableModelDep.fireTableDataChanged();
                    }
                    return;
                }
                ArrayList<IndependenceFact> facts = new ArrayList<IndependenceFact>();
                for (Node x : MarkovCheckEditor.this.dag.getNodes()) {
                    List<Node> desc = MarkovCheckEditor.this.dag.paths().getDescendants(Collections.singletonList(x));
                    List<Node> nondesc = MarkovCheckEditor.this.dag.getNodes();
                    nondesc.removeAll(desc);
                    nondesc.removeAll(MarkovCheckEditor.this.dag.getParents(x));
                    nondesc.remove(x);
                    List<Node> list = MarkovCheckEditor.this.dag.getParents(x);
                    System.out.println("Node " + x + " parents = " + list + " non-descendants = " + nondesc);
                    if (indep) {
                        for (Node y : nondesc) {
                            facts.add(new IndependenceFact(x, y, list));
                        }
                        continue;
                    }
                    for (Node y : desc) {
                        facts.add(new IndependenceFact(x, y, list));
                    }
                }
                class IndCheckTask
                implements Callable<List<IndependenceResult>> {
                    private final int from;
                    private final int to;
                    private final List<IndependenceFact> facts;

                    IndCheckTask(int from, int to, List<IndependenceFact> facts) {
                        this.from = from;
                        this.to = to;
                        this.facts = facts;
                    }

                    @Override
                    public List<IndependenceResult> call() {
                        ArrayList<IndependenceResult> results = new ArrayList<IndependenceResult>();
                        for (int i = this.from; i < this.to && !Thread.interrupted(); ++i) {
                            IndependenceFact fact = this.facts.get(i);
                            Node x = fact.getX();
                            Node y = fact.getY();
                            List<Node> z = fact.getZ();
                            boolean verbose = MarkovCheckEditor.this.test.isVerbose();
                            MarkovCheckEditor.this.test.setVerbose(verbose);
                            IndependenceResult result = MarkovCheckEditor.this.test.checkIndependence(x, y, z);
                            boolean indep = result.independent();
                            double pValue = result.getPValue();
                            MarkovCheckEditor.this.test.setVerbose(verbose);
                            results.add(new IndependenceResult(fact, indep, pValue));
                            if (indep) {
                                MarkovCheckEditor.this.tableModelIndep.fireTableDataChanged();
                                continue;
                            }
                            MarkovCheckEditor.this.tableModelDep.fireTableDataChanged();
                        }
                        return results;
                    }
                }
                ArrayList<IndCheckTask> tasks = new ArrayList<IndCheckTask>();
                int chunkSize = MarkovCheckEditor.this.getChunkSize(facts.size());
                for (int i = 0; i < facts.size() && !Thread.currentThread().isInterrupted(); i += chunkSize) {
                    IndCheckTask task = new IndCheckTask(i, FastMath.min(facts.size(), i + chunkSize), facts);
                    if (!MarkovCheckEditor.this.parallelized) {
                        Object object = task.call();
                        MarkovCheckEditor.this.model.getResults(indep).addAll((Collection<IndependenceResult>)object);
                        continue;
                    }
                    tasks.add(task);
                }
                if (MarkovCheckEditor.this.parallelized) {
                    List theseResults = ForkJoinPool.commonPool().invokeAll(tasks);
                    for (Future future : theseResults) {
                        try {
                            MarkovCheckEditor.this.model.getResults(indep).addAll((Collection)future.get());
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                int dependent = 0;
                for (IndependenceResult independenceResult : MarkovCheckEditor.this.model.getResults(indep)) {
                    if (!independenceResult.dependent() || Double.isNaN(independenceResult.getPValue())) continue;
                    ++dependent;
                }
                if (indep) {
                    MarkovCheckEditor.this.fractionDependentIndep = (double)dependent / (double)MarkovCheckEditor.this.model.getResults(indep).size();
                } else {
                    MarkovCheckEditor.this.fractionDependentDep = (double)dependent / (double)MarkovCheckEditor.this.model.getResults(indep).size();
                }
                if (indep) {
                    MarkovCheckEditor.this.fractionDepLabelIndep.setText("% dependent = " + (Double.isNaN(MarkovCheckEditor.this.fractionDependentIndep) ? "-" : NumberFormatUtil.getInstance().getNumberFormat().format(MarkovCheckEditor.this.fractionDependentIndep)));
                } else {
                    MarkovCheckEditor.this.fractionDepLabelDep.setText("% dependent = " + (Double.isNaN(MarkovCheckEditor.this.fractionDependentDep) ? "-" : NumberFormatUtil.getInstance().getNumberFormat().format(MarkovCheckEditor.this.fractionDependentDep)));
                }
                if (indep) {
                    MarkovCheckEditor.this.tableModelIndep.fireTableDataChanged();
                } else {
                    MarkovCheckEditor.this.tableModelDep.fireTableDataChanged();
                }
            }
        };
    }

    private int getChunkSize(int n) {
        int chunk = (int)FastMath.ceil((double)n / (double)(5 * Runtime.getRuntime().availableProcessors()));
        if (chunk < 1) {
            chunk = 1;
        }
        return chunk;
    }

    private IndependenceTest getIndependenceTest() {
        return this.test;
    }

    private int getLastSortCol() {
        return this.lastSortCol;
    }

    private void setLastSortCol(int lastSortCol) {
        if (lastSortCol < 0 || lastSortCol > 4) {
            throw new IllegalArgumentException();
        }
        this.lastSortCol = lastSortCol;
    }

    private int getSortDir() {
        return this.sortDir;
    }

    private void setSortDir(int sortDir) {
        if (sortDir != 1 && sortDir != -1) {
            throw new IllegalArgumentException();
        }
        this.sortDir = sortDir;
    }

    private JPanel createHistogramPanel(boolean indep) {
        BoxDataSet dataSet = new BoxDataSet(new VerticalDoubleDataBox(this.model.getResults(indep).size(), 1), Collections.singletonList(new ContinuousVariable("P-Values")));
        for (int i = 0; i < this.model.getResults(indep).size(); ++i) {
            dataSet.setDouble(i, 0, this.model.getResults(indep).get(i).getPValue());
        }
        Histogram histogram = new Histogram(dataSet);
        histogram.setTarget("P-Values");
        HistogramView view = new HistogramView(histogram);
        Box box = Box.createHorizontalBox();
        box.add(view);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)vBox, "Center");
        return panel;
    }

    static class Renderer
    extends DefaultTableCellRenderer {
        private JTable table;
        private boolean selected;

        @Override
        public void setValue(Object value) {
            if (this.selected) {
                this.setForeground(this.table.getSelectionForeground());
                this.setBackground(this.table.getSelectionBackground());
            } else {
                this.setForeground(this.table.getForeground());
                this.setBackground(this.table.getBackground());
            }
            this.setText(value.toString());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.table = table;
            this.selected = isSelected;
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

