/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.Font;
import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;

class NumberCellRenderer
extends DefaultTableCellRenderer {
    private final NumberFormat nf;
    private String emptyString = "";

    public NumberCellRenderer() {
        this(NumberFormatUtil.getInstance().getNumberFormat());
    }

    public NumberCellRenderer(NumberFormat nf) {
        if (nf == null) {
            throw new NullPointerException();
        }
        this.nf = nf;
        this.setHorizontalAlignment(4);
        this.setFont(new Font("Serif", 0, 12));
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText(this.getEmptyString());
        } else if (value instanceof Integer) {
            this.setText(value.toString());
        } else if (value instanceof Double) {
            double doubleValue = (Double)value;
            if (Double.isNaN(doubleValue)) {
                this.setText(this.getEmptyString());
            } else {
                this.setText(this.nf.format(doubleValue));
            }
        } else {
            this.setText("");
        }
    }

    private String getEmptyString() {
        return this.emptyString;
    }

    public void setEmptyString(String emptyString) {
        if (emptyString == null) {
            throw new NullPointerException();
        }
        this.emptyString = emptyString;
    }
}

