/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;

public class PagColorer
extends JCheckBoxMenuItem {
    public PagColorer(GraphWorkbench workbench) {
        super("Add/Remove PAG Coloring");
        if (workbench == null) {
            throw new NullPointerException("Desktop must not be null.");
        }
        GraphWorkbench _workbench = workbench;
        Graph graph = workbench.getGraph();
        _workbench.setDoPagColoring(workbench.isDoPagColoring());
        this.setSelected(workbench.isDoPagColoring());
        this.addItemListener(e -> {
            if (!this.isSelected()) {
                workbench.setDoPagColoring(false);
            } else {
                int ret = JOptionPane.showConfirmDialog(workbench, this.breakDown("Would you like to verify that this is a legal PAG?", 60), "Legal PAG check", 0, 2);
                if (ret == 0) {
                    SearchGraphUtils.LegalPagRet legalPag = SearchGraphUtils.isLegalPag(graph);
                    String reason = this.breakDown(legalPag.getReason(), 60);
                    if (!legalPag.isLegalPag()) {
                        JOptionPane.showMessageDialog(workbench, "This is not a legal PAG--one reason is as follows:\n\n" + reason + ".", "Legal PAG check", 2);
                    } else {
                        JOptionPane.showMessageDialog(workbench, reason);
                    }
                }
                _workbench.setDoPagColoring(true);
            }
        });
    }

    private String breakDown(String reason, int maxColumns) {
        String[] tokens;
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        for (String token : tokens = reason.split(" ")) {
            if (buf1.length() + token.length() > maxColumns) {
                buf2.append((CharSequence)buf1);
                buf2.append("\n");
                buf1 = new StringBuilder();
                buf1.append(token);
                continue;
            }
            buf1.append(" ").append(token);
        }
        if (buf1.length() > 0) {
            buf2.append((CharSequence)buf1);
        }
        return buf2.toString();
    }
}

