/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PathsAction
extends AbstractAction
implements ClipboardOwner {
    private final GraphWorkbench workbench;
    private List<Node> nodes1;
    private List<Node> nodes2;
    private JTextArea textArea;
    private String method;

    public PathsAction(GraphWorkbench workbench) {
        super("Paths");
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Graph graph = this.workbench.getGraph();
        this.textArea = new JTextArea();
        JScrollPane scroll = new JScrollPane(this.textArea);
        scroll.setPreferredSize(new Dimension(600, 400));
        List<Node> allNodes = graph.getNodes();
        allNodes.sort(Comparator.naturalOrder());
        allNodes.add(new GraphNode("SELECT_ALL"));
        Node[] array = allNodes.toArray(new Node[0]);
        Node pathFrom = graph.getNode(Preferences.userRoot().get("pathFrom", ""));
        this.nodes1 = pathFrom == null ? Collections.singletonList(graph.getNodes().get(0)) : Collections.singletonList(pathFrom);
        JComboBox<Node> node1Box = new JComboBox<Node>(array);
        node1Box.addActionListener(e1 -> {
            JComboBox box = (JComboBox)e1.getSource();
            Node node = (Node)box.getSelectedItem();
            System.out.println(node);
            assert (node != null);
            this.nodes1 = "SELECT_ALL".equals(node.getName()) ? new ArrayList<Node>(graph.getNodes()) : Collections.singletonList(node);
            Preferences.userRoot().put("pathFrom", node.getName());
        });
        node1Box.setSelectedItem(this.nodes1.get(0));
        Node pathTo = graph.getNode(Preferences.userRoot().get("pathTo", ""));
        this.nodes2 = pathTo == null ? Collections.singletonList(graph.getNodes().get(0)) : Collections.singletonList(pathTo);
        JComboBox<Node> node2Box = new JComboBox<Node>(array);
        node2Box.addActionListener(e12 -> {
            JComboBox box = (JComboBox)e12.getSource();
            Node node = (Node)box.getSelectedItem();
            System.out.println(node);
            this.nodes2 = "SELECT_ALL".equals(node.getName()) ? new ArrayList<Node>(graph.getNodes()) : Collections.singletonList(node);
            Preferences.userRoot().put("pathTo", node.getName());
        });
        node2Box.setSelectedItem(this.nodes2.get(0));
        JComboBox<String> methodBox = new JComboBox<String>(new String[]{"Directed Paths", "Semidirected Paths", "Treks", "Adjacents"});
        this.method = Preferences.userRoot().get("pathMethod", "Directed Paths");
        methodBox.addActionListener(e13 -> {
            JComboBox box = (JComboBox)e13.getSource();
            this.method = (String)box.getSelectedItem();
            Preferences.userRoot().put("pathMethod", this.method);
        });
        methodBox.setSelectedItem(this.method);
        IntTextField maxField = new IntTextField(Preferences.userRoot().getInt("pathMaxLength", 3), 2);
        maxField.setFilter((value, oldValue) -> {
            try {
                this.setMaxLength(value);
                return value;
            }
            catch (Exception e14) {
                return oldValue;
            }
        });
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(e15 -> this.update(graph, this.textArea, this.nodes1, this.nodes2, this.method));
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("From "));
        b1.add(node1Box);
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel(" To "));
        b1.add(node2Box);
        b1.add(Box.createHorizontalGlue());
        b1.add(methodBox);
        b1.add(new JLabel("Max length"));
        b1.add(maxField);
        b1.add(updateButton);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(scroll);
        this.textArea.setCaretPosition(0);
        b.add(b2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(b);
        EditorWindow window = new EditorWindow(panel, "Directed Paths", "Close", false, this.workbench);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
        this.update(graph, this.textArea, this.nodes1, this.nodes2, this.method);
    }

    private void update(Graph graph, JTextArea textArea, List<Node> nodes1, List<Node> nodes2, String method) {
        if ("Directed Paths".equals(method)) {
            textArea.setText("");
            this.allDirectedPaths(graph, textArea, nodes1, nodes2);
        } else if ("Semidirected Paths".equals(method)) {
            textArea.setText("");
            this.allSemidirectedPaths(graph, textArea, nodes1, nodes2);
        } else if ("Treks".equals(method)) {
            textArea.setText("");
            this.allTreks(graph, textArea, nodes1, nodes2);
        } else if ("Adjacents".equals(method)) {
            textArea.setText("");
            this.adjacentNodes(graph, textArea, nodes1, nodes2);
        }
    }

    private void allDirectedPaths(Graph graph, JTextArea textArea, List<Node> nodes1, List<Node> nodes2) {
        boolean pathListed = false;
        for (Node node1 : nodes1) {
            for (Node node2 : nodes2) {
                List<List<Node>> paths = graph.paths().directedPathsFromTo(node1, node2, Preferences.userRoot().getInt("pathMaxLength", 3));
                if (paths.isEmpty()) continue;
                pathListed = true;
                textArea.append("\n\nBetween " + node1 + " and " + node2 + ":");
                for (List<Node> path : paths) {
                    textArea.append("\n    " + GraphUtils.pathString(graph, path));
                }
            }
        }
        if (!pathListed) {
            textArea.append("No directedPaths listed.");
        }
    }

    private void allSemidirectedPaths(Graph graph, JTextArea textArea, List<Node> nodes1, List<Node> nodes2) {
        boolean pathListed = false;
        for (Node node1 : nodes1) {
            for (Node node2 : nodes2) {
                List<List<Node>> paths = graph.paths().semidirectedPathsFromTo(node1, node2, Preferences.userRoot().getInt("pathMaxLength", 3));
                if (paths.isEmpty()) continue;
                pathListed = true;
                textArea.append("\n\nBetween " + node1 + " and " + node2 + ":");
                for (List<Node> path : paths) {
                    textArea.append("\n    " + GraphUtils.pathString(graph, path));
                }
            }
        }
        if (!pathListed) {
            textArea.append("No semidirected paths listed.");
        }
    }

    private void allTreks(Graph graph, JTextArea textArea, List<Node> nodes1, List<Node> nodes2) {
        boolean pathListed = false;
        for (Node node1 : nodes1) {
            for (Node node2 : nodes2) {
                List<List<Node>> treks = graph.paths().treks(node1, node2, Preferences.userRoot().getInt("pathMaxLength", 3));
                if (treks.isEmpty()) continue;
                pathListed = true;
                textArea.append("\n\nBetween " + node1 + " and " + node2 + ":");
                for (List<Node> trek : treks) {
                    textArea.append("\n    " + GraphUtils.pathString(graph, trek));
                }
            }
        }
        if (!pathListed) {
            textArea.append("No treks listed.");
        }
    }

    private void adjacentNodes(Graph graph, JTextArea textArea, List<Node> nodes1, List<Node> nodes2) {
        for (Node node1 : nodes1) {
            for (Node node2 : nodes2) {
                List<Node> parents = graph.getParents(node1);
                List<Node> children = graph.getChildren(node1);
                List<Node> ambiguous = graph.getAdjacentNodes(node1);
                ambiguous.removeAll(parents);
                ambiguous.removeAll(children);
                textArea.append("\n\nAdjacents for " + node1 + ":");
                textArea.append("\n\nParents: " + this.niceList(parents));
                textArea.append("\nChildren: " + this.niceList(children));
                textArea.append("\nAmbiguous: " + this.niceList(ambiguous));
                List<Node> parents2 = graph.getParents(node2);
                List<Node> children2 = graph.getChildren(node2);
                List<Node> ambiguous2 = graph.getAdjacentNodes(node2);
                ambiguous2.removeAll(parents2);
                ambiguous2.removeAll(children2);
                textArea.append("\n\nAdjacents for " + node2 + ":");
                textArea.append("\n\nParents: " + this.niceList(parents2));
                textArea.append("\nChildren: " + this.niceList(children2));
                textArea.append("\nAmbiguous: " + this.niceList(ambiguous2));
            }
        }
    }

    private String niceList(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return "--NONE--";
        }
        Collections.sort(nodes);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            buf.append(nodes.get(i));
            if (i >= nodes.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void setMaxLength(int maxLength) {
        if (maxLength < -1) {
            throw new IllegalArgumentException();
        }
        Preferences.userRoot().putInt("pathMaxLength", maxLength);
    }
}

